/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class RabbitMQProducer
extends DefaultProducer {
    private int closeTimeout = 30000;
    private Connection conn;
    private Channel channel;
    private ExecutorService executorService;

    public RabbitMQProducer(RabbitMQEndpoint endpoint) throws IOException {
        super((Endpoint)endpoint);
    }

    public RabbitMQEndpoint getEndpoint() {
        return (RabbitMQEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.executorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelRabbitMQProducer[" + this.getEndpoint().getQueue() + "]");
        this.log.trace("Creating connection...");
        this.conn = this.getEndpoint().connect(this.executorService);
        this.log.debug("Created connection: {}", (Object)this.conn);
        this.log.trace("Creating channel...");
        this.channel = this.conn.createChannel();
        this.log.debug("Created channel: {}", (Object)this.channel);
    }

    protected void doStop() throws Exception {
        if (this.channel != null) {
            this.log.debug("Closing channel: {}", (Object)this.channel);
            this.channel.close();
            this.channel = null;
        }
        if (this.conn != null) {
            this.log.debug("Closing connection: {} with timeout: {} ms.", (Object)this.conn, (Object)this.closeTimeout);
            this.conn.close(this.closeTimeout);
            this.conn = null;
        }
        if (this.executorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
    }

    public void process(Exchange exchange) throws Exception {
        String key;
        String exchangeName = (String)exchange.getIn().getHeader("rabbitmq.EXCHANGE_NAME", String.class);
        if (exchangeName == null || this.getEndpoint().isBridgeEndpoint()) {
            exchangeName = this.getEndpoint().getExchangeName();
        }
        if ((key = (String)exchange.getIn().getHeader("rabbitmq.ROUTING_KEY", null, String.class)) == null || this.getEndpoint().isBridgeEndpoint()) {
            String string = key = this.getEndpoint().getRoutingKey() == null ? "" : this.getEndpoint().getRoutingKey();
        }
        if (ObjectHelper.isEmpty((Object)key) && ObjectHelper.isEmpty((Object)exchangeName)) {
            throw new IllegalArgumentException("ExchangeName and RoutingKey is not provided in the endpoint: " + (Object)((Object)this.getEndpoint()));
        }
        byte[] messageBodyBytes = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        AMQP.BasicProperties.Builder properties = this.buildProperties(exchange);
        this.channel.basicPublish(exchangeName, key, properties.build(), messageBodyBytes);
    }

    AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        Object contentType = exchange.getIn().getHeader("rabbitmq.CONTENT_TYPE");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = exchange.getIn().getHeader("rabbitmq.PRIORITY")) != null) {
            properties.priority(Integer.parseInt(priority.toString()));
        }
        if ((messageId = exchange.getIn().getHeader("rabbitmq.MESSAGE_ID")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = exchange.getIn().getHeader("rabbitmq.CLUSTERID")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = exchange.getIn().getHeader("rabbitmq.REPLY_TO")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = exchange.getIn().getHeader("rabbitmq.CORRELATIONID")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = exchange.getIn().getHeader("rabbitmq.DELIVERY_MODE")) != null) {
            properties.deliveryMode(Integer.parseInt(deliveryMode.toString()));
        }
        if ((userId = exchange.getIn().getHeader("rabbitmq.USERID")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = exchange.getIn().getHeader("rabbitmq.TYPE")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = exchange.getIn().getHeader("rabbitmq.CONTENT_ENCODING")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = exchange.getIn().getHeader("rabbitmq.EXPIRATION")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = exchange.getIn().getHeader("rabbitmq.APP_ID")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = exchange.getIn().getHeader("rabbitmq.TIMESTAMP")) != null) {
            properties.timestamp(new Date(Long.parseLong(timestamp.toString())));
        }
        Map headers = exchange.getIn().getHeaders();
        HashMap<String, Object> filteredHeaders = new HashMap<String, Object>();
        for (Map.Entry header : headers.entrySet()) {
            Object value = this.getValidRabbitMQHeaderValue(header.getValue());
            if (value != null) {
                filteredHeaders.put((String)header.getKey(), header.getValue());
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            if (header.getValue() == null) {
                this.log.debug("Ignoring header: {} with null value", header.getKey());
                continue;
            }
            this.log.debug("Ignoring header: {} of class: {} with value: {}", new Object[]{header.getKey(), ObjectHelper.classCanonicalName(header.getValue()), header.getValue()});
        }
        properties.headers(filteredHeaders);
        return properties;
    }

    private Object getValidRabbitMQHeaderValue(Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (headerValue instanceof byte[]) {
            return headerValue;
        }
        return null;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }
}

