/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import com.rabbitmq.client.AMQP;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.rabbitmq.reply.ReplyHandler;
import org.apache.camel.component.rabbitmq.reply.ReplyHolder;
import org.apache.camel.component.rabbitmq.reply.ReplyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryQueueReplyHandler
implements ReplyHandler {
    protected final Logger log = LoggerFactory.getLogger(TemporaryQueueReplyHandler.class);
    protected final ReplyManager replyManager;
    protected final Exchange exchange;
    protected final AsyncCallback callback;
    protected final String originalCorrelationId;
    protected final String correlationId;
    protected final long timeout;

    public TemporaryQueueReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long timeout) {
        this.replyManager = replyManager;
        this.exchange = exchange;
        this.originalCorrelationId = originalCorrelationId;
        this.correlationId = correlationId;
        this.callback = callback;
        this.timeout = timeout;
    }

    @Override
    public void onReply(String correlationId, AMQP.BasicProperties properties, byte[] reply) {
        this.log.info("in onReply with correlationId= {}", (Object)correlationId);
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, this.originalCorrelationId, correlationId, properties, reply);
        this.replyManager.processReply(holder);
    }

    @Override
    public void onTimeout(String correlationId) {
        this.log.info("in onTimeout with correlationId= {}", (Object)correlationId);
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, this.originalCorrelationId, correlationId, this.timeout);
        this.replyManager.processReply(holder);
    }
}

