/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;

public class RabbitMQConnectionFactorySupport {
    public ConnectionFactory createFactoryFor(RabbitMQEndpoint endpoint) {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(endpoint.getUsername());
        factory.setPassword(endpoint.getPassword());
        factory.setVirtualHost(endpoint.getVhost());
        factory.setHost(endpoint.getHostname());
        factory.setPort(endpoint.getPortNumber());
        if (endpoint.getClientProperties() != null) {
            factory.setClientProperties(endpoint.getClientProperties());
        }
        factory.setConnectionTimeout(endpoint.getConnectionTimeout());
        factory.setRequestedChannelMax(endpoint.getRequestedChannelMax());
        factory.setRequestedFrameMax(endpoint.getRequestedFrameMax());
        factory.setRequestedHeartbeat(endpoint.getRequestedHeartbeat());
        if (endpoint.getSslProtocol() != null) {
            try {
                if (endpoint.getSslProtocol().equals("true")) {
                    factory.useSslProtocol();
                } else if (endpoint.getTrustManager() == null) {
                    factory.useSslProtocol(endpoint.getSslProtocol());
                } else {
                    factory.useSslProtocol(endpoint.getSslProtocol(), endpoint.getTrustManager());
                }
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid sslProtocol " + endpoint.getSslProtocol(), e);
            }
        }
        if (endpoint.getAutomaticRecoveryEnabled() != null) {
            factory.setAutomaticRecoveryEnabled(endpoint.getAutomaticRecoveryEnabled());
        }
        if (endpoint.getNetworkRecoveryInterval() != null) {
            factory.setNetworkRecoveryInterval(endpoint.getNetworkRecoveryInterval());
        }
        if (endpoint.getTopologyRecoveryEnabled() != null) {
            factory.setTopologyRecoveryEnabled(endpoint.getTopologyRecoveryEnabled());
        }
        return factory;
    }
}

