/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class ReactiveStreamsConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile ReactiveStreamsConverter reactiveStreamsConverter;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        ReactiveStreamsConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getReactiveStreamsConverter().convertToPublisher(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private ReactiveStreamsConverter getReactiveStreamsConverter() {
        if (this.reactiveStreamsConverter == null) {
            this.reactiveStreamsConverter = new ReactiveStreamsConverter();
            CamelContextAware.trySetCamelContext(this.reactiveStreamsConverter, this.camelContext);
        }
        return this.reactiveStreamsConverter;
    }
}

