/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsDiscardedException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.engine.CamelPublisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSubscription
implements Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSubscription.class);
    private final String id;
    private final ExecutorService workerPool;
    private final String streamName;
    private final CamelPublisher publisher;
    private final Subscriber<? super Exchange> subscriber;
    private ReactiveStreamsBackpressureStrategy backpressureStrategy;
    private final Lock mutex = new ReentrantLock(true);
    private final LinkedList<Exchange> buffer = new LinkedList();
    private long requested;
    private boolean terminating;
    private boolean terminated;
    private boolean sending;

    public CamelSubscription(String id, ExecutorService workerPool, CamelPublisher publisher, String streamName, ReactiveStreamsBackpressureStrategy backpressureStrategy, Subscriber<? super Exchange> subscriber) {
        this.id = id;
        this.workerPool = workerPool;
        this.publisher = publisher;
        this.streamName = streamName;
        this.backpressureStrategy = backpressureStrategy;
        this.subscriber = subscriber;
    }

    @Override
    public void request(long l) {
        LOG.debug("Requested {} events from subscriber", (Object)l);
        if (l <= 0L) {
            this.mutex.lock();
            this.terminated = true;
            this.mutex.unlock();
            this.publisher.unsubscribe(this);
            this.subscriber.onError(new IllegalArgumentException("3.9"));
        } else {
            this.mutex.lock();
            this.requested += l;
            this.mutex.unlock();
            this.checkAndFlush();
        }
    }

    protected void checkAndFlush() {
        boolean shouldFlush;
        this.mutex.lock();
        boolean bl = shouldFlush = !this.terminated && !this.sending && this.requested > 0L && !this.buffer.isEmpty();
        if (shouldFlush) {
            this.sending = true;
        }
        this.mutex.unlock();
        if (shouldFlush) {
            this.workerPool.execute(() -> {
                this.flush();
                this.mutex.lock();
                this.sending = false;
                this.mutex.unlock();
                this.checkAndFlush();
            });
        } else {
            boolean shouldComplete;
            this.mutex.lock();
            boolean bl2 = shouldComplete = this.terminating && !this.terminated;
            if (shouldComplete) {
                this.terminated = true;
            }
            this.mutex.unlock();
            if (shouldComplete) {
                this.publisher.unsubscribe(this);
                this.subscriber.onComplete();
                this.discardBuffer(this.buffer);
            }
        }
    }

    protected void flush() {
        LinkedList<Exchange> sendingQueue = null;
        try {
            this.mutex.lock();
            if (this.terminated) {
                return;
            }
            int amount = (int)Math.min(this.requested, (long)this.buffer.size());
            if (amount > 0) {
                this.requested -= (long)amount;
                sendingQueue = new LinkedList<Exchange>();
                while (amount > 0) {
                    sendingQueue.add(this.buffer.removeFirst());
                    --amount;
                }
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (sendingQueue != null) {
            LOG.debug("Sending {} events to the subscriber", (Object)sendingQueue.size());
            for (Exchange data : sendingQueue) {
                this.subscriber.onNext(data);
                this.mutex.lock();
                boolean shouldStop = this.terminated;
                this.mutex.unlock();
                if (!shouldStop) continue;
                break;
            }
        }
    }

    public void signalCompletion() {
        this.mutex.lock();
        this.terminating = true;
        this.mutex.unlock();
        this.checkAndFlush();
    }

    @Override
    public void cancel() {
        LinkedList<Exchange> bufferCopy;
        this.publisher.unsubscribe(this);
        this.mutex.lock();
        try {
            this.terminated = true;
            bufferCopy = new LinkedList<Exchange>(this.buffer);
            this.buffer.clear();
        }
        finally {
            this.mutex.unlock();
        }
        this.discardBuffer(bufferCopy);
    }

    protected void discardBuffer(List<Exchange> remaining) {
        for (Exchange data : remaining) {
            ReactiveStreamsHelper.invokeDispatchCallback(data, new IllegalStateException("Cannot process the exchange " + data + ": subscription cancelled"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Exchange message) {
        Map<Exchange, String> discardedMessages = null;
        try {
            this.mutex.lock();
            if (!this.terminating && !this.terminated) {
                Collection<Exchange> discarded = this.backpressureStrategy.update(this.buffer, message);
                if (!discarded.isEmpty()) {
                    discardedMessages = new HashMap<Exchange, String>();
                    for (Exchange ex : discarded) {
                        discardedMessages.put(ex, "Exchange " + ex + " discarded by backpressure strategy " + (Object)((Object)this.backpressureStrategy));
                    }
                }
            } else {
                discardedMessages = Collections.singletonMap(message, "Exchange " + message + " discarded: subscription closed");
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (discardedMessages != null) {
            for (Exchange exchange : discardedMessages.keySet()) {
                ReactiveStreamsHelper.invokeDispatchCallback(exchange, new ReactiveStreamsDiscardedException("Discarded by backpressure strategy", exchange, this.streamName));
            }
        }
        this.checkAndFlush();
    }

    public void setBackpressureStrategy(ReactiveStreamsBackpressureStrategy backpressureStrategy) {
        this.mutex.lock();
        this.backpressureStrategy = backpressureStrategy;
        this.mutex.unlock();
    }

    public long getBufferSize() {
        return this.buffer.size();
    }

    public ReactiveStreamsBackpressureStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    public String getId() {
        return this.id;
    }
}

