/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.InterceptStrategy;

public class InterceptReifier<T extends InterceptDefinition>
extends ProcessorReifier<T> {
    public InterceptReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (InterceptDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        final Processor output = this.createChildProcessor(true);
        this.route.getInterceptStrategies().add(new InterceptStrategy(){
            private Processor interceptedTarget;

            @Override
            public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) throws Exception {
                this.interceptedTarget = target;
                ((InterceptDefinition)InterceptReifier.this.definition).getIntercepted().add(this.interceptedTarget);
                if (this.interceptedTarget != null) {
                    return Pipeline.newInstance(context, output, this.interceptedTarget);
                }
                return output;
            }

            public String toString() {
                return "intercept[" + (this.interceptedTarget != null ? this.interceptedTarget : output) + "]";
            }
        });
        ((RouteDefinition)this.route.getRoute()).getOutputs().remove(this.definition);
        return null;
    }
}

