/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.StringHelper;

public class WireTapReifier
extends ToDynamicReifier<WireTapDefinition<?>> {
    public WireTapReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ExecutorService threadPool = this.getConfiguredExecutorService("WireTap", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ((WireTapDefinition)this.definition).setPattern(ExchangePattern.InOnly.name());
        String uri = ((WireTapDefinition)this.definition).getEndpointProducerBuilder() != null ? ((WireTapDefinition)this.definition).getEndpointProducerBuilder().getUri() : StringHelper.notEmpty(((WireTapDefinition)this.definition).getUri(), "uri", this);
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute(this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        }
        SendDynamicProcessor dynamicSendProcessor = null;
        SendProcessor sendProcessor = null;
        boolean simple = LanguageSupport.hasSimpleFunction(((WireTapDefinition)this.definition).getUri());
        boolean dynamic = this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true);
        if (dynamic && simple) {
            dynamicSendProcessor = (SendDynamicProcessor)super.createProcessor();
        } else {
            Endpoint endpoint = CamelContextHelper.resolveEndpoint(this.camelContext, uri, null);
            sendProcessor = new SendProcessor(endpoint);
        }
        SendDynamicProcessor producer = dynamicSendProcessor != null ? dynamicSendProcessor : sendProcessor;
        Processor childProcessor = this.wrapInErrorHandler(producer);
        InternalProcessor target = this.camelContext.adapt(ExtendedCamelContext.class).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        boolean isCopy = this.parseBoolean(((WireTapDefinition)this.definition).getCopy(), true);
        WireTapProcessor answer = new WireTapProcessor(dynamicSendProcessor, target, uri, this.parse(ExchangePattern.class, ((WireTapDefinition)this.definition).getPattern()), isCopy, threadPool, shutdownThreadPool, dynamic);
        Processor newExchangeProcessor = ((WireTapDefinition)this.definition).getNewExchangeProcessor();
        String ref = this.parseString(((WireTapDefinition)this.definition).getNewExchangeProcessorRef());
        if (ref != null) {
            newExchangeProcessor = this.mandatoryLookup(ref, Processor.class);
        }
        if (newExchangeProcessor != null) {
            answer.addNewExchangeProcessor(newExchangeProcessor);
        }
        if (((WireTapDefinition)this.definition).getNewExchangeExpression() != null) {
            answer.setNewExchangeExpression(this.createExpression(((WireTapDefinition)this.definition).getNewExchangeExpression()));
        }
        if (((WireTapDefinition)this.definition).getHeaders() != null && !((WireTapDefinition)this.definition).getHeaders().isEmpty()) {
            for (SetHeaderDefinition header : ((WireTapDefinition)this.definition).getHeaders()) {
                Processor processor = this.createProcessor(header);
                answer.addNewExchangeProcessor(processor);
            }
        }
        Processor onPrepare = ((WireTapDefinition)this.definition).getOnPrepare();
        ref = this.parseString(((WireTapDefinition)this.definition).getOnPrepareRef());
        if (ref != null) {
            onPrepare = this.mandatoryLookup(ref, Processor.class);
        }
        if (onPrepare != null) {
            answer.setOnPrepare(onPrepare);
        }
        return answer;
    }

    @Override
    protected Expression createExpression(String uri) {
        if (this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true)) {
            return super.createExpression(uri);
        }
        return this.camelContext.resolveLanguage("constant").createExpression(uri);
    }
}

