/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;

public class AggregationStrategyClause<T>
implements AggregationStrategy {
    private final T parent;
    private AggregationStrategy strategy;

    public AggregationStrategyClause(T parent) {
        this.parent = parent;
        this.strategy = null;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        return ObjectHelper.notNull(this.strategy, "AggregationStrategy").aggregate(oldExchange, newExchange);
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        return ObjectHelper.notNull(this.strategy, "AggregationStrategy").aggregate(oldExchange, newExchange, inputExchange);
    }

    public T exchange(BiFunction<Exchange, Exchange, Exchange> function) {
        this.strategy = function::apply;
        return this.parent;
    }

    public T message(BiFunction<Message, Message, Message> function) {
        return this.exchange((oldExchange, newExchange) -> {
            Message oldMessage = oldExchange != null ? oldExchange.getIn() : null;
            Message newMessage = ObjectHelper.notNull(newExchange, "NewExchange").getIn();
            Message result = (Message)function.apply(oldMessage, newMessage);
            if (oldExchange != null) {
                oldExchange.setIn(result);
                return oldExchange;
            }
            newExchange.setIn(result);
            return newExchange;
        });
    }

    public T body(BiFunction<Object, Object, Object> function) {
        return this.body(Object.class, function);
    }

    public <B> T body(Class<B> type, BiFunction<B, B, Object> function) {
        return this.body(type, type, function);
    }

    public <O, N> T body(Class<O> oldType, Class<N> newType, BiFunction<O, N, Object> function) {
        return this.exchange((oldExchange, newExchange) -> {
            Message oldMessage = oldExchange != null ? oldExchange.getIn() : null;
            Message newMessage = ObjectHelper.notNull(newExchange, "NewExchange").getIn();
            Object result = function.apply(oldMessage != null ? (Object)oldMessage.getBody(oldType) : null, newMessage != null ? (Object)newMessage.getBody(newType) : null);
            if (oldExchange != null) {
                oldExchange.getIn().setBody(result);
                return oldExchange;
            }
            newExchange.getIn().setBody(result);
            return newExchange;
        });
    }
}

