/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.AbstractLocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;

public class ClasspathPropertiesSource
extends AbstractLocationPropertiesSource
implements Ordered {
    public ClasspathPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        super(propertiesComponent, location);
    }

    @Override
    public String getName() {
        return "ClasspathPropertiesSource[" + this.getLocation().getPath() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Properties loadPropertiesFromLocation(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        BufferedReader reader;
        InputStream is;
        OrderedProperties answer;
        block6: {
            answer = new OrderedProperties();
            String path = location.getPath();
            is = propertiesComponent.getCamelContext().getClassResolver().loadResourceAsStream(path);
            reader = null;
            if (is == null) {
                if (propertiesComponent.isIgnoreMissingLocation() || location.isOptional()) return answer;
                throw RuntimeCamelException.wrapRuntimeCamelException(new FileNotFoundException("Properties file " + path + " not found in classpath"));
            }
            try {
                if (propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader(is, propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block6;
                }
                answer.load(is);
            }
            catch (IOException e) {
                try {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(reader, is);
                    throw throwable;
                }
            }
        }
        IOHelper.close(reader, is);
        return answer;
    }

    @Override
    public int getOrder() {
        return 300;
    }
}

