/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContextAware;
import org.apache.camel.TimerListener;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;

public final class DefaultPeriodTaskScheduler
extends TimerListenerManager
implements PeriodTaskScheduler {
    @Override
    public void schedulePeriodTask(Runnable task, long period) {
        this.addTimerListener(new TaskWrapper(task, period));
    }

    @Override
    public <T> T getTaskByType(Class<T> type) {
        for (TimerListener listener : this.getListeners()) {
            Object task = listener;
            if (listener instanceof TaskWrapper) {
                task = ((TaskWrapper)listener).getTask();
            }
            if (!type.isInstance(task)) continue;
            return type.cast(task);
        }
        return null;
    }

    @Override
    public void addTimerListener(TimerListener listener) {
        if (!(listener instanceof TaskWrapper)) {
            throw new IllegalArgumentException("Use the addPeriodTask method");
        }
        super.addTimerListener(listener);
    }

    private final class TaskWrapper
    extends ServiceSupport
    implements TimerListener {
        private final StopWatch watch = new StopWatch();
        private final Runnable task;
        private final long period;

        public TaskWrapper(Runnable task, long period) {
            this.task = task;
            this.period = period;
        }

        public Runnable getTask() {
            return this.task;
        }

        @Override
        public void onTimer() {
            if (this.watch.taken() > this.period) {
                this.watch.restart();
                this.task.run();
            }
        }

        @Override
        protected void doBuild() throws Exception {
            CamelContextAware.trySetCamelContext(this.task, DefaultPeriodTaskScheduler.this.getCamelContext());
            ServiceHelper.buildService((Object)this.task);
        }

        @Override
        protected void doInit() throws Exception {
            ServiceHelper.initService((Object)this.task);
        }

        @Override
        protected void doStart() throws Exception {
            ServiceHelper.startService((Object)this.task);
        }

        @Override
        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.task);
        }

        @Override
        protected void doShutdown() throws Exception {
            ServiceHelper.stopAndShutdownService(this.task);
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

