/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.BatchOptions;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.BaseRedisBatchExecutor;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.AsyncCountDownLatch;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedisQueuedBatchExecutor<V, R>
extends BaseRedisBatchExecutor<V, R> {
    private final ConcurrentMap<MasterSlaveEntry, CommandBatchService.ConnectionEntry> connections;
    private final AsyncCountDownLatch latch;

    public RedisQueuedBatchExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, ConcurrentMap<MasterSlaveEntry, CommandBatchService.Entry> commands, ConcurrentMap<MasterSlaveEntry, CommandBatchService.ConnectionEntry> connections, BatchOptions options, AtomicInteger index, AtomicBoolean executed, AsyncCountDownLatch latch, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry) {
        super(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, connectionManager, objectBuilder, commands, options, index, executed, referenceType, noRetry);
        this.connections = connections;
        this.latch = latch;
    }

    @Override
    public void execute() {
        this.addBatchCommandData(null);
        if (!this.readOnlyMode && this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC) {
            throw new IllegalStateException("Data modification commands can't be used with queueStore=REDIS_READ_ATOMIC");
        }
        super.execute();
    }

    @Override
    protected void releaseConnection(RPromise<R> attemptPromise, RFuture<RedisConnection> connectionFuture) {
        if (RedisCommands.EXEC.getName().equals(this.command.getName()) || RedisCommands.DISCARD.getName().equals(this.command.getName())) {
            super.releaseConnection(attemptPromise, connectionFuture);
        } else {
            this.connectionManager.getShutdownLatch().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSuccess(RPromise<R> promise, RFuture<RedisConnection> connectionFuture, R res) throws ReflectiveOperationException {
        if (RedisCommands.EXEC.getName().equals(this.command.getName())) {
            super.handleSuccess(promise, connectionFuture, res);
            return;
        }
        if (RedisCommands.DISCARD.getName().equals(this.command.getName())) {
            super.handleSuccess(promise, connectionFuture, null);
            return;
        }
        try {
            BatchPromise batchPromise = (BatchPromise)promise;
            RPromise sentPromise = (RPromise)batchPromise.getSentPromise();
            super.handleSuccess(sentPromise, connectionFuture, null);
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleError(RFuture<RedisConnection> connectionFuture, Throwable cause) {
        try {
            if (this.mainPromise instanceof BatchPromise) {
                BatchPromise batchPromise = (BatchPromise)this.mainPromise;
                RPromise sentPromise = (RPromise)batchPromise.getSentPromise();
                sentPromise.tryFailure(cause);
                this.mainPromise.tryFailure(cause);
                if (this.executed.compareAndSet(false, true)) {
                    connectionFuture.getNow().forceFastReconnectAsync().onComplete((res, e) -> RedisQueuedBatchExecutor.super.releaseConnection(this.mainPromise, connectionFuture));
                }
                return;
            }
            super.handleError(connectionFuture, cause);
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    protected void sendCommand(RPromise<R> attemptPromise, RedisConnection connection) {
        boolean syncSlaves;
        MasterSlaveEntry msEntry = this.getEntry(this.source);
        CommandBatchService.ConnectionEntry connectionEntry = (CommandBatchService.ConnectionEntry)this.connections.get(msEntry);
        boolean bl = syncSlaves = this.options.getSyncSlaves() > 0;
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            RedissonPromise promise = new RedissonPromise();
            list.add(new CommandData(promise, this.codec, RedisCommands.ASKING, new Object[0]));
            if (connectionEntry.isFirstCommand()) {
                list.add(new CommandData(promise, this.codec, RedisCommands.MULTI, new Object[0]));
                connectionEntry.setFirstCommand(false);
            }
            list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
            RedissonPromise<Void> main = new RedissonPromise<Void>();
            this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("acquired connection for command {} and params {} from slot {} using node {}... {}", new Object[]{this.command, LogHelper.toString(this.params), this.source, connection.getRedisClient().getAddr(), connection});
            }
            if (connectionEntry.isFirstCommand()) {
                ArrayList list = new ArrayList(2);
                list.add(new CommandData(new RedissonPromise(), this.codec, RedisCommands.MULTI, new Object[0]));
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
                connectionEntry.setFirstCommand(false);
            } else if (RedisCommands.EXEC.getName().equals(this.command.getName())) {
                CommandBatchService.Entry entry = (CommandBatchService.Entry)this.commands.get(msEntry);
                ArrayList list = new ArrayList();
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new RedissonPromise(), this.codec, RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}));
                }
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new RedissonPromise(), this.codec, RedisCommands.CLIENT_REPLY, new Object[]{"ON"}));
                }
                if (this.options.getSyncSlaves() > 0) {
                    BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                    list.add(waitCommand);
                    entry.getCommands().add(waitCommand);
                }
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                this.writeFuture = connection.send(new CommandsData(main, list, new ArrayList(entry.getCommands()), this.options.isSkipResult(), false, true, syncSlaves));
            } else {
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                ArrayList list = new ArrayList();
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RFuture<RedisConnection> getConnection() {
        CommandBatchService.ConnectionEntry oldEntry;
        MasterSlaveEntry msEntry = this.getEntry(this.source);
        CommandBatchService.ConnectionEntry entry = (CommandBatchService.ConnectionEntry)this.connections.get(msEntry);
        if (entry == null && (oldEntry = this.connections.putIfAbsent(msEntry, entry = new CommandBatchService.ConnectionEntry())) != null) {
            entry = oldEntry;
        }
        if (entry.getConnectionFuture() != null) {
            return entry.getConnectionFuture();
        }
        RedisQueuedBatchExecutor redisQueuedBatchExecutor = this;
        synchronized (redisQueuedBatchExecutor) {
            if (entry.getConnectionFuture() != null) {
                return entry.getConnectionFuture();
            }
            RFuture<RedisConnection> connectionFuture = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC ? this.connectionManager.connectionWriteOp(this.source, null) : this.connectionManager.connectionReadOp(this.source, null);
            connectionFuture.toCompletableFuture().join();
            entry.setConnectionFuture(connectionFuture);
            entry.setCancelCallback(() -> this.handleError(connectionFuture, new CancellationException()));
            return connectionFuture;
        }
    }
}

