/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import org.redisson.misc.RPromise;

public class TransferListener<T>
implements BiConsumer<Object, Throwable> {
    private final RPromise<T> promise;
    private final T value;

    public TransferListener(RPromise<T> promise) {
        this(promise, null);
    }

    public TransferListener(RPromise<T> promise, T value) {
        this.promise = promise;
        this.value = value;
    }

    @Override
    public void accept(Object t, Throwable u) {
        if (u != null) {
            if (u instanceof CompletionException) {
                u = u.getCause();
            }
            this.promise.tryFailure(u);
            return;
        }
        if (this.value != null) {
            this.promise.trySuccess(this.value);
        } else {
            this.promise.trySuccess(t);
        }
    }
}

