/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasResponse;

public abstract class AddResponseDefinitionCommand
extends AbstractCommand {
    public boolean _defExisted;
    public String _newDefinitionName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newDefinitionObj;

    AddResponseDefinitionCommand() {
    }

    AddResponseDefinitionCommand(String definitionName) {
        this._newDefinitionName = definitionName;
    }

    AddResponseDefinitionCommand(String definitionName, Object obj) {
        this._newDefinitionName = definitionName;
        this._newDefinitionObj = obj;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddResponseDefinitionCommand] Executing.", new Object[0]);
        OasDocument doc = (OasDocument)document;
        if (this.defExists(doc)) {
            LoggerCompat.info("[AddResponseDefinitionCommand] Definition with name %s already exists.", this._newDefinitionName);
            this._defExisted = true;
            return;
        }
        this.prepareDocumentForDef(doc);
        OasResponse definition = this.createResponseDefinition(doc);
        this.addDefinition(doc, definition);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddResponseDefinitionCommand] Reverting.", new Object[0]);
        if (this._defExisted) {
            return;
        }
        OasDocument doc = (OasDocument)document;
        this.removeDefinition(doc);
    }

    protected abstract boolean defExists(OasDocument var1);

    protected abstract void prepareDocumentForDef(OasDocument var1);

    protected abstract OasResponse createResponseDefinition(OasDocument var1);

    protected abstract void addDefinition(OasDocument var1, OasResponse var2);

    protected abstract void removeDefinition(OasDocument var1);
}

