/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.io.OasDataModelWriter;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Example;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Headers;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Scopes;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import java.util.List;

public class Oas20DataModelWriter
extends OasDataModelWriter
implements IOas20Visitor {
    @Override
    protected void writeDocument(Document node, Object json) {
        Oas20Document doc = (Oas20Document)node;
        JsonCompat.setPropertyString(json, "swagger", doc.swagger);
        JsonCompat.setPropertyNull(json, "info");
        JsonCompat.setPropertyString(json, "host", doc.host);
        JsonCompat.setPropertyString(json, "basePath", doc.basePath);
        JsonCompat.setPropertyStringArray(json, "schemes", doc.schemes);
        JsonCompat.setPropertyStringArray(json, "consumes", doc.consumes);
        JsonCompat.setPropertyStringArray(json, "produces", doc.produces);
        JsonCompat.setPropertyNull(json, "paths");
        JsonCompat.setPropertyNull(json, "definitions");
        JsonCompat.setPropertyNull(json, "parameters");
        JsonCompat.setPropertyNull(json, "responses");
        JsonCompat.setPropertyNull(json, "securityDefinitions");
        JsonCompat.setPropertyNull(json, "security");
        JsonCompat.setPropertyNull(json, "tags");
        JsonCompat.setPropertyNull(json, "externalDocs");
        this.writeExtraProperties(json, node);
    }

    @Override
    public void visitItems(Oas20Items node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "type", node.type);
        JsonCompat.setPropertyString(json, "format", node.format);
        JsonCompat.setPropertyNull(json, "items");
        JsonCompat.setPropertyString(json, "collectionFormat", node.collectionFormat);
        JsonCompat.setProperty(json, "default", node.default_);
        JsonCompat.setPropertyNumber(json, "maximum", node.maximum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMaximum", node.exclusiveMaximum);
        JsonCompat.setPropertyNumber(json, "minimum", node.minimum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMinimum", node.exclusiveMinimum);
        JsonCompat.setPropertyNumber(json, "maxLength", node.maxLength);
        JsonCompat.setPropertyNumber(json, "minLength", node.minLength);
        JsonCompat.setPropertyString(json, "pattern", node.pattern);
        JsonCompat.setPropertyNumber(json, "maxItems", node.maxItems);
        JsonCompat.setPropertyNumber(json, "minItems", node.minItems);
        JsonCompat.setPropertyBoolean(json, "uniqueItems", node.uniqueItems);
        JsonCompat.setPropertyStringArray(json, "enum", node.enum_);
        JsonCompat.setPropertyNumber(json, "multipleOf", node.multipleOf);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "items", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitSecurityDefinitions(Oas20SecurityDefinitions node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "securityDefinitions", json);
        this.updateIndex(node, json);
    }

    @Override
    protected void writeSecurityScheme(Object json, SecurityScheme node) {
        Oas20SecurityScheme node20 = (Oas20SecurityScheme)node;
        JsonCompat.setPropertyString(json, "flow", node20.flow);
        JsonCompat.setPropertyString(json, "authorizationUrl", node20.authorizationUrl);
        JsonCompat.setPropertyString(json, "tokenUrl", node20.tokenUrl);
        JsonCompat.setPropertyNull(json, "scopes");
        super.writeSecurityScheme(json, node);
    }

    @Override
    public void visitScopes(Oas20Scopes node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        for (String scope : node.getScopeNames()) {
            String description = node.getScopeDescription(scope);
            JsonCompat.setPropertyString(json, scope, description);
        }
        JsonCompat.setProperty(parent, "scopes", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitDefinitions(Oas20Definitions node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        if (node.getDefinitionNames().size() > 0) {
            JsonCompat.setProperty(parent, "definitions", json);
            this.updateIndex(node, json);
        }
    }

    @Override
    protected void writeSchema(Object json, Schema node) {
        super.writeSchema(json, node);
        Oas20Schema schema = (Oas20Schema)node;
        JsonCompat.setPropertyString(json, "discriminator", schema.discriminator);
    }

    @Override
    protected void writeOperation(Object json, Operation node) {
        Oas20Operation operation = (Oas20Operation)node;
        JsonCompat.setPropertyStringArray(json, "consumes", operation.consumes);
        JsonCompat.setPropertyStringArray(json, "produces", operation.produces);
        JsonCompat.setPropertyStringArray(json, "schemes", operation.schemes);
        super.writeOperation(json, node);
    }

    @Override
    public void visitParameterDefinitions(Oas20ParameterDefinitions node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        if (node.getParameterNames().size() > 0) {
            JsonCompat.setProperty(parent, "parameters", json);
            this.updateIndex(node, json);
        }
    }

    @Override
    protected void writeParameter(Object json, Parameter node) {
        super.writeParameter(json, node);
        Oas20Parameter param = (Oas20Parameter)node;
        JsonCompat.setPropertyString(json, "type", param.type);
        JsonCompat.setPropertyString(json, "format", param.format);
        JsonCompat.setPropertyNull(json, "items");
        JsonCompat.setPropertyString(json, "collectionFormat", param.collectionFormat);
        JsonCompat.setProperty(json, "default", param.default_);
        JsonCompat.setPropertyNumber(json, "maximum", param.maximum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMaximum", param.exclusiveMaximum);
        JsonCompat.setPropertyNumber(json, "minimum", param.minimum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMinimum", param.exclusiveMinimum);
        JsonCompat.setPropertyNumber(json, "maxLength", param.maxLength);
        JsonCompat.setPropertyNumber(json, "minLength", param.minLength);
        JsonCompat.setPropertyString(json, "pattern", param.pattern);
        JsonCompat.setPropertyNumber(json, "maxItems", param.maxItems);
        JsonCompat.setPropertyNumber(json, "minItems", param.minItems);
        JsonCompat.setPropertyBoolean(json, "uniqueItems", param.uniqueItems);
        JsonCompat.setPropertyStringArray(json, "enum", param.enum_);
        JsonCompat.setPropertyNumber(json, "multipleOf", param.multipleOf);
    }

    @Override
    public void visitExample(Oas20Example node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        List<String> contentTypes = node.getExampleContentTypes();
        contentTypes.forEach(ct -> {
            Object example = node.getExample((String)ct);
            JsonCompat.setProperty(json, ct, example);
        });
        JsonCompat.setProperty(parent, "examples", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitHeaders(Oas20Headers node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        if (node.getHeaderNames().size() > 0) {
            JsonCompat.setProperty(parent, "headers", json);
            this.updateIndex(node, json);
        }
    }

    @Override
    protected void writeHeader(Object json, OasHeader node) {
        super.writeHeader(json, node);
        Oas20Header header = (Oas20Header)node;
        JsonCompat.setPropertyString(json, "type", header.type);
        JsonCompat.setPropertyString(json, "format", header.format);
        JsonCompat.setPropertyNull(json, "items");
        JsonCompat.setPropertyString(json, "collectionFormat", header.collectionFormat);
        JsonCompat.setProperty(json, "default", header.default_);
        JsonCompat.setPropertyNumber(json, "maximum", header.maximum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMaximum", header.exclusiveMaximum);
        JsonCompat.setPropertyNumber(json, "minimum", header.minimum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMinimum", header.exclusiveMinimum);
        JsonCompat.setPropertyNumber(json, "maxLength", header.maxLength);
        JsonCompat.setPropertyNumber(json, "minLength", header.minLength);
        JsonCompat.setPropertyString(json, "pattern", header.pattern);
        JsonCompat.setPropertyNumber(json, "maxItems", header.maxItems);
        JsonCompat.setPropertyNumber(json, "minItems", header.minItems);
        JsonCompat.setPropertyBoolean(json, "uniqueItems", header.uniqueItems);
        JsonCompat.setPropertyStringArray(json, "enum", header.enum_);
        JsonCompat.setPropertyNumber(json, "multipleOf", header.multipleOf);
    }

    @Override
    public void visitResponseDefinitions(Oas20ResponseDefinitions node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        if (node.getResponseNames().size() > 0) {
            JsonCompat.setProperty(parent, "responses", json);
            this.updateIndex(node, json);
        }
    }
}

