/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenApiProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@UriEndpoint(firstVersion="3.1.0", scheme="rest-openapi", title="REST OpenApi", syntax="rest-openapi:specificationUri#operationId", category={Category.OPENAPI, Category.REST, Category.API}, producerOnly=true)
public final class RestOpenApiEndpoint
extends DefaultEndpoint {
    private static final Pattern PATH_EXTRACTOR = Pattern.compile("/([^{}/]+)");
    Map<String, Object> parameters = Collections.emptyMap();
    @UriParam(description="API basePath, for example \"`/v2`\". Default is unset, if set overrides the value present in OpenApi specification and in the component configuration.", defaultValue="", label="producer")
    private String basePath;
    @UriParam(description="Name of the Camel component that will perform the requests. The component must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Overrides component configuration.", label="producer")
    private String componentName;
    @UriParam(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the OpenApi specification and. in the component configuration", label="producer")
    private String consumes;
    @UriParam(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the corresponding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-openapi` next, and global configuration last. If set overrides any value found in the OpenApi specification, RestConfiguration. Overrides all other  configuration.", label="producer")
    private String host;
    @UriPath(description="ID of the operation from the OpenApi specification.", label="producer")
    @Metadata(required=true)
    private String operationId;
    @UriParam(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the OpenApi specification. Overrides all other configuration.", label="producer")
    private String produces;
    @UriPath(description="Path to the OpenApi specification file. The scheme, host base path are taken from this specification, but these can be overridden with properties on the component or endpoint level. If not given the component tries to load `openapi.json` resource from the classpath. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `http://api.example.com:8080`). Overrides component configuration. The OpenApi specification can be loaded from different sources by prefixing with file: classpath: http: https:. Support for https is limited to using the JDK installed UrlHandler, and as such it can be cumbersome to setup TLS/SSL certificates for https (such as setting a number of javax.net.ssl JVM system properties). How to do that consult the JDK documentation for UrlHandler.", defaultValue="openapi.json", defaultValueNote="By default loads `openapi.json` file", label="producer")
    private URI specificationUri = RestOpenApiComponent.DEFAULT_SPECIFICATION_URI;

    public RestOpenApiEndpoint() {
    }

    public RestOpenApiEndpoint(String uri, String remaining, RestOpenApiComponent component, Map<String, Object> parameters) {
        super(StringHelper.notEmpty(uri, "uri"), ObjectHelper.notNull(component, "component"));
        this.parameters = parameters;
        this.specificationUri = StringHelper.before(remaining, "#", StringHelper::trimToNull).map(URI::create).orElse(Optional.ofNullable(component.getSpecificationUri()).orElse(RestOpenApiComponent.DEFAULT_SPECIFICATION_URI));
        this.operationId = Optional.ofNullable(StringHelper.after(remaining, "#")).orElse(remaining);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    @Override
    public Producer createProducer() throws Exception {
        CamelContext camelContext = this.getCamelContext();
        Document openapiDoc = RestOpenApiEndpoint.loadSpecificationFrom(camelContext, this.specificationUri);
        OasPaths paths = ((OasDocument)openapiDoc).paths;
        for (OasPathItem path : paths.getItems()) {
            Optional<Map.Entry> maybeOperationEntry = this.getOperationMap(path).entrySet().stream().filter(operationEntry -> this.operationId.equals(((OasOperation)operationEntry.getValue()).operationId)).findAny();
            if (!maybeOperationEntry.isPresent()) continue;
            Map.Entry operationEntry2 = maybeOperationEntry.get();
            OasOperation operation = (OasOperation)operationEntry2.getValue();
            Map<String, OasParameter> pathParameters = operation.getParameters() != null ? operation.getParameters().stream().filter(p -> "path".equals(p.in)).collect(Collectors.toMap(Parameter::getName, Function.identity())) : new HashMap<String, OasParameter>();
            String uriTemplate = this.resolveUri(path.getPath(), pathParameters);
            HttpMethod httpMethod = (HttpMethod)((Object)operationEntry2.getKey());
            String method = httpMethod.name();
            return this.createProducerFor(openapiDoc, operation, method, uriTemplate);
        }
        String supportedOperations = paths.getItems().stream().flatMap(p -> this.getOperationMap((OasPathItem)p).values().stream()).map(p -> p.operationId).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("The specified operation with ID: `" + this.operationId + "` cannot be found in the OpenApi specification loaded from `" + this.specificationUri + "`. Operations defined in the specification are: " + supportedOperations);
    }

    private void generateMissingOperationId(String path, OasOperation operation) {
        if (null == operation.operationId) {
            StringBuilder idBuilder = new StringBuilder(operation.getMethod().toLowerCase());
            Matcher matcher = PATH_EXTRACTOR.matcher(path);
            while (matcher.find()) {
                idBuilder.append('-').append(matcher.group(1));
            }
            operation.operationId = idBuilder.toString();
        }
    }

    private Map<HttpMethod, OasOperation> getOperationMap(OasPathItem path) {
        LinkedHashMap<HttpMethod, OasOperation> result = new LinkedHashMap<HttpMethod, OasOperation>();
        String uriPath = path.getPath();
        if (path.get != null) {
            this.generateMissingOperationId(uriPath, path.get);
            result.put(HttpMethod.GET, path.get);
        }
        if (path.put != null) {
            this.generateMissingOperationId(uriPath, path.put);
            result.put(HttpMethod.PUT, path.put);
        }
        if (path.post != null) {
            this.generateMissingOperationId(uriPath, path.post);
            result.put(HttpMethod.POST, path.post);
        }
        if (path.delete != null) {
            this.generateMissingOperationId(uriPath, path.delete);
            result.put(HttpMethod.DELETE, path.delete);
        }
        if (path.patch != null) {
            this.generateMissingOperationId(uriPath, path.patch);
            result.put(HttpMethod.PATCH, path.patch);
        }
        if (path.head != null) {
            this.generateMissingOperationId(uriPath, path.head);
            result.put(HttpMethod.HEAD, path.head);
        }
        if (path.options != null) {
            this.generateMissingOperationId(uriPath, path.options);
            result.put(HttpMethod.OPTIONS, path.options);
        }
        return result;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getProduces() {
        return this.produces;
    }

    public URI getSpecificationUri() {
        return this.specificationUri;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    public void setBasePath(String basePath) {
        this.basePath = StringHelper.notEmpty(basePath, "basePath");
    }

    public void setComponentName(String componentName) {
        this.componentName = StringHelper.notEmpty(componentName, "componentName");
    }

    public void setConsumes(String consumes) {
        this.consumes = RestOpenApiHelper.isMediaRange(consumes, "consumes");
    }

    public void setHost(String host) {
        this.host = RestOpenApiHelper.isHostParam(host);
    }

    public void setOperationId(String operationId) {
        this.operationId = StringHelper.notEmpty(operationId, "operationId");
    }

    public void setProduces(String produces) {
        this.produces = RestOpenApiHelper.isMediaRange(produces, "produces");
    }

    public void setSpecificationUri(URI specificationUri) {
        this.specificationUri = ObjectHelper.notNull(specificationUri, "specificationUri");
    }

    RestOpenApiComponent component() {
        return (RestOpenApiComponent)this.getComponent();
    }

    Producer createProducerFor(Document openapi, OasOperation operation, String method, String uriTemplate) throws Exception {
        String basePath = this.determineBasePath(openapi);
        String componentEndpointUri = "rest:" + method + ":" + basePath + ":" + uriTemplate;
        CamelContext camelContext = this.getCamelContext();
        Endpoint endpoint = camelContext.getEndpoint(componentEndpointUri);
        Map<String, Object> params = this.determineEndpointParameters(openapi, operation);
        boolean hasHost = params.containsKey("host");
        endpoint.configureProperties(params);
        return new RestOpenApiProducer(endpoint.createAsyncProducer(), hasHost);
    }

    String determineBasePath(Document openapi) {
        if (ObjectHelper.isNotEmpty(this.basePath)) {
            return this.basePath;
        }
        String componentBasePath = this.component().getBasePath();
        if (ObjectHelper.isNotEmpty(componentBasePath)) {
            return componentBasePath;
        }
        String specificationBasePath = RestOpenApiEndpoint.getBasePathFromOasDocument((OasDocument)openapi);
        if (ObjectHelper.isNotEmpty(specificationBasePath)) {
            return specificationBasePath;
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration restConfiguration = CamelContextHelper.getRestConfiguration(camelContext, null, this.determineComponentName());
        String restConfigurationBasePath = restConfiguration.getContextPath();
        if (ObjectHelper.isNotEmpty(restConfigurationBasePath)) {
            return restConfigurationBasePath;
        }
        return "/";
    }

    public static String getBasePathFromOasDocument(OasDocument openapi) {
        String basePath = null;
        if (openapi instanceof Oas20Document) {
            basePath = ((Oas20Document)openapi).basePath;
        } else if (openapi instanceof Oas30Document && ((Oas30Document)openapi).getServers() != null && ((Oas30Document)openapi).getServers().get(0) != null) {
            try {
                Oas30Server server = (Oas30Server)((Oas30Document)openapi).getServers().get(0);
                if (server.variables != null && server.variables.get("basePath") != null) {
                    basePath = ((ServerVariable)server.variables.get((Object)"basePath")).default_;
                }
                if (basePath == null) {
                    URL serverUrl = new URL(RestOpenApiEndpoint.parseVariables(((Oas30Document)openapi).getServers().get((int)0).url, server));
                    basePath = serverUrl.getPath();
                    if (basePath.indexOf("//") == 0) {
                        basePath = basePath.substring(1);
                    }
                    if ("/".equals(basePath)) {
                        basePath = "";
                    }
                }
            }
            catch (MalformedURLException e) {
                basePath = ((Oas30Document)openapi).getServers().get((int)0).url;
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Oas30Server server) {
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String var = m.group(1);
            if (server == null || server.variables == null || server.variables.get(var) == null) continue;
            String varValue = ((ServerVariable)server.variables.get((Object)var)).default_;
            url = url.replace("{" + var + "}", varValue);
        }
        return url;
    }

    String determineComponentName() {
        return Optional.ofNullable(this.componentName).orElse(this.component().getComponentName());
    }

    Map<String, Object> determineEndpointParameters(Document openapi, OasOperation operation) {
        String queryParameters;
        String host;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String componentName = this.determineComponentName();
        if (componentName != null) {
            parameters.put("producerComponentName", componentName);
        }
        if ((host = this.determineHost(openapi)) != null) {
            parameters.put("host", host);
        }
        RestOpenApiComponent component = this.component();
        ArrayList<String> specificationLevelConsumers = new ArrayList();
        if (openapi instanceof Oas20Document) {
            specificationLevelConsumers = ((Oas20Document)openapi).produces;
        }
        ArrayList<String> operationLevelConsumers = new ArrayList();
        if (operation instanceof Oas20Operation) {
            operationLevelConsumers = ((Oas20Operation)operation).produces;
        } else if (operation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)operation;
            if (oas30Operation.responses != null) {
                for (OasResponse response : oas30Operation.responses.getResponses()) {
                    operationLevelConsumers.addAll(((Oas30Response)response).content.keySet());
                }
            }
        }
        String determinedConsumes = RestOpenApiEndpoint.determineOption(specificationLevelConsumers, operationLevelConsumers, component.getConsumes(), this.consumes);
        if (ObjectHelper.isNotEmpty(determinedConsumes)) {
            parameters.put("consumes", determinedConsumes);
        }
        ArrayList<String> specificationLevelProducers = new ArrayList();
        if (openapi instanceof Oas20Document) {
            specificationLevelProducers = ((Oas20Document)openapi).consumes;
        }
        ArrayList<String> operationLevelProducers = new ArrayList();
        if (operation instanceof Oas20Operation) {
            operationLevelProducers = ((Oas20Operation)operation).consumes;
        } else if (operation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)operation;
            if (oas30Operation.requestBody != null && oas30Operation.requestBody.content != null) {
                operationLevelProducers.addAll(oas30Operation.requestBody.content.keySet());
            }
        }
        String determinedProducers = RestOpenApiEndpoint.determineOption(specificationLevelProducers, operationLevelProducers, component.getProduces(), this.produces);
        if (ObjectHelper.isNotEmpty(determinedProducers)) {
            parameters.put("produces", determinedProducers);
        }
        if (ObjectHelper.isNotEmpty(queryParameters = RestOpenApiEndpoint.determineQueryParameters(openapi, operation).map(this::queryParameter).collect(Collectors.joining("&")))) {
            parameters.put("queryParameters", queryParameters);
        }
        HashMap<String, Object> componentParameters = new HashMap<String, Object>();
        if (component.isUseGlobalSslContextParameters()) {
            componentParameters.put("useGlobalSslContextParameters", component.isUseGlobalSslContextParameters());
        }
        if (component.getSslContextParameters() != null) {
            componentParameters.put("sslContextParameters", component.getSslContextParameters());
        }
        if (!componentParameters.isEmpty()) {
            HashMap<String, HashMap<String, Object>> nestedParameters = new HashMap<String, HashMap<String, Object>>();
            nestedParameters.put("component", componentParameters);
            parameters.put("parameters", nestedParameters);
        }
        return parameters;
    }

    String determineHost(Document openapi) {
        CamelContext camelContext;
        RestConfiguration globalRestConfiguration;
        String globalConfigurationHost;
        Oas30Document oas30Document;
        if (ObjectHelper.isNotEmpty(this.host)) {
            return this.host;
        }
        String componentHost = this.component().getHost();
        if (ObjectHelper.isNotEmpty(componentHost)) {
            return componentHost;
        }
        if (openapi instanceof Oas20Document) {
            String openapiScheme = RestOpenApiEndpoint.pickBestScheme(this.specificationUri.getScheme(), ((Oas20Document)openapi).schemes);
            String openapiHost = ((Oas20Document)openapi).host;
            if (ObjectHelper.isNotEmpty(openapiScheme) && ObjectHelper.isNotEmpty(openapiHost)) {
                return openapiScheme + "://" + openapiHost;
            }
        } else if (openapi instanceof Oas30Document && (oas30Document = (Oas30Document)openapi).getServers() != null && oas30Document.getServers().get(0) != null) {
            try {
                URL serverUrl = new URL(RestOpenApiEndpoint.parseVariables(oas30Document.getServers().get((int)0).url, (Oas30Server)oas30Document.getServers().get(0)));
                String openapiScheme = serverUrl.getProtocol();
                String openapiHost = serverUrl.getHost();
                if (ObjectHelper.isNotEmpty(openapiScheme) && ObjectHelper.isNotEmpty(openapiHost)) {
                    return openapiScheme + "://" + openapiHost;
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((globalConfigurationHost = RestOpenApiEndpoint.hostFrom(globalRestConfiguration = CamelContextHelper.getRestConfiguration(camelContext = this.getCamelContext(), null, this.determineComponentName()))) != null) {
            return globalConfigurationHost;
        }
        String specificationScheme = this.specificationUri.getScheme();
        String prefix = "http";
        if (this.specificationUri.isAbsolute() && specificationScheme.regionMatches(true, 0, prefix, 0, prefix.length())) {
            try {
                return new URI(this.specificationUri.getScheme(), this.specificationUri.getUserInfo(), this.specificationUri.getHost(), this.specificationUri.getPort(), null, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unable to create a new URI from: " + this.specificationUri, e);
            }
        }
        throw new IllegalStateException("Unable to determine destination host for requests. The OpenApi specification does not specify `scheme` and `host` parameters, the specification URI is not absolute with `http` or `https` scheme, and no RestConfigurations configured with `scheme`, `host` and `port` were found for `" + (this.determineComponentName() != null ? this.determineComponentName() : "default` component") + " and there is no global RestConfiguration with those properties");
    }

    String literalPathParameterValue(OasParameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode(valueStr);
        return encoded;
    }

    String literalQueryParameterValue(OasParameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode(valueStr);
        return name + "=" + encoded;
    }

    String queryParameter(OasParameter parameter) {
        String name = parameter.getName();
        if (ObjectHelper.isEmpty(name)) {
            return "";
        }
        if (this.parameters.containsKey(name)) {
            return this.literalQueryParameterValue(parameter);
        }
        return RestOpenApiEndpoint.queryParameterExpression(parameter);
    }

    String resolveUri(String uriTemplate, Map<String, OasParameter> pathParameters) {
        if (pathParameters.isEmpty()) {
            return uriTemplate;
        }
        int start = uriTemplate.indexOf(123);
        if (start == -1) {
            return uriTemplate;
        }
        int pos = 0;
        StringBuilder resolved = new StringBuilder(uriTemplate.length() * 2);
        while (start != -1) {
            resolved.append(uriTemplate, pos, start);
            int end = uriTemplate.indexOf(125, start);
            String name = uriTemplate.substring(start + 1, end);
            if (this.parameters.containsKey(name)) {
                OasParameter parameter = pathParameters.get(name);
                String value = this.literalPathParameterValue(parameter);
                resolved.append((Object)value);
            } else {
                resolved.append('{').append(name).append('}');
            }
            pos = end + 1;
            start = uriTemplate.indexOf(123, pos);
        }
        if (pos < uriTemplate.length()) {
            resolved.append(uriTemplate, pos, uriTemplate.length());
        }
        return resolved.toString();
    }

    static String determineOption(List<String> specificationLevel, List<String> operationLevel, String componentLevel, String endpointLevel) {
        if (ObjectHelper.isNotEmpty(endpointLevel)) {
            return endpointLevel;
        }
        if (ObjectHelper.isNotEmpty(componentLevel)) {
            return componentLevel;
        }
        if (operationLevel != null && !operationLevel.isEmpty()) {
            return String.join((CharSequence)", ", operationLevel);
        }
        if (specificationLevel != null && !specificationLevel.isEmpty()) {
            return String.join((CharSequence)", ", specificationLevel);
        }
        return null;
    }

    static Stream<OasParameter> determineQueryParameters(Document openapi, OasOperation operation) {
        List<SecurityRequirement> securityRequirements = operation.security;
        ArrayList<OasParameter> apiKeyQueryParameters = new ArrayList<OasParameter>();
        if (securityRequirements != null) {
            if (openapi instanceof Oas20Document) {
                Oas20Document oas20Document = (Oas20Document)openapi;
                Oas20SecurityDefinitions securityDefinitions = oas20Document.securityDefinitions;
                for (SecurityRequirement securityRequirement : securityRequirements) {
                    for (String securityRequirementName : securityRequirement.getSecurityRequirementNames()) {
                        Oas20SecurityScheme securitySchemeDefinition = securityDefinitions.getSecurityScheme(securityRequirementName);
                        if (securitySchemeDefinition.in == null || !securitySchemeDefinition.in.equals("query")) continue;
                        Oas20Parameter securityParameter = new Oas20Parameter(securitySchemeDefinition.name);
                        securityParameter.required = true;
                        securityParameter.type = "string";
                        securityParameter.description = securitySchemeDefinition.description;
                        apiKeyQueryParameters.add(securityParameter);
                    }
                }
            } else if (openapi instanceof Oas30Document) {
                Oas30Document oas30Document = (Oas30Document)openapi;
                for (SecurityRequirement securityRequirement : securityRequirements) {
                    for (String securityRequirementName : securityRequirement.getSecurityRequirementNames()) {
                        Oas30SecurityScheme securitySchemeDefinition = oas30Document.components.getSecurityScheme(securityRequirementName);
                        if (securitySchemeDefinition.in == null || !securitySchemeDefinition.in.equals("query")) continue;
                        Oas30Parameter securityParameter = new Oas30Parameter(securitySchemeDefinition.name);
                        securityParameter.required = true;
                        securityParameter.description = securitySchemeDefinition.description;
                        apiKeyQueryParameters.add(securityParameter);
                    }
                }
            } else {
                throw new IllegalStateException("We only support OpenApi 2.0 or 3.0 document here");
            }
        }
        if (operation.getParameters() != null) {
            return Stream.concat(apiKeyQueryParameters.stream(), operation.getParameters().stream().filter(p -> "query".equals(p.in)));
        }
        return apiKeyQueryParameters.stream();
    }

    static String hostFrom(RestConfiguration restConfiguration) {
        if (restConfiguration == null) {
            return null;
        }
        String scheme = restConfiguration.getScheme();
        String host = restConfiguration.getHost();
        int port = restConfiguration.getPort();
        if (scheme == null || host == null) {
            return null;
        }
        StringBuilder answer = new StringBuilder(scheme).append("://").append(host);
        if (!(port <= 0 || "http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443)) {
            answer.append(':').append(port);
        }
        return answer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Document loadSpecificationFrom(CamelContext camelContext, URI uri) {
        ObjectMapper mapper = new ObjectMapper();
        String uriAsString = uri.toString();
        try (InputStream stream = ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, uriAsString);){
            JsonNode node = mapper.readTree(stream);
            Document document = Library.readDocument(node);
            return document;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given OpenApi specification could not be loaded from `" + uri + "`. Tried loading using Camel's resource resolution and using OpenApi's own resource resolution. OpenApi tends to swallow exceptions while parsing, try specifying Java system property `debugParser` (e.g. `-DdebugParser=true`), the exception that occurred when loading using Camel's resource loader follows", e);
        }
    }

    static String pickBestScheme(String specificationScheme, List<String> schemes) {
        if (schemes != null && !schemes.isEmpty()) {
            if (schemes.contains("https")) {
                return "https";
            }
            if (schemes.contains("http")) {
                return "http";
            }
        }
        return specificationScheme;
    }

    static String queryParameterExpression(OasParameter parameter) {
        String name = parameter.getName();
        StringBuilder expression = new StringBuilder(name).append("={").append(name);
        if (parameter.required == null || !parameter.required.booleanValue()) {
            expression.append('?');
        }
        expression.append('}');
        return expression.toString();
    }

    static enum HttpMethod {
        POST,
        GET,
        PUT,
        PATCH,
        DELETE,
        HEAD,
        OPTIONS;

    }
}

