/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Server;

public class ChangeServerCommand_Aai20
extends AbstractCommand {
    public String _serverName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _serverObj;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldServer;

    ChangeServerCommand_Aai20() {
    }

    ChangeServerCommand_Aai20(AaiServer server) {
        this._serverName = server.getName();
        this._serverObj = Library.writeNode(server);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeServerCommand_Aai20] Executing.", new Object[0]);
        this._oldServer = null;
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent.servers)) {
            return;
        }
        AaiServer server = (AaiServer)parent.servers.get(this._serverName);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        this._oldServer = Library.writeNode(server);
        this.replaceServerWith(server, this._serverObj);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeServerCommand_Aai20] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldServer)) {
            return;
        }
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent.servers)) {
            return;
        }
        AaiServer server = (AaiServer)parent.servers.get(this._serverName);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        this.replaceServerWith(server, this._oldServer);
    }

    protected void replaceServerWith(Server toServer, Object fromServer) {
        toServer.getServerVariables().forEach(var_ -> toServer.removeServerVariable(var_.getName()));
        Library.readNode(fromServer, toServer);
    }
}

