/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;

public class DeleteHeaderCommand
extends AbstractCommand {
    public String _headerName;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldHeader;

    DeleteHeaderCommand() {
    }

    DeleteHeaderCommand(OasHeader header) {
        this._headerName = header.getName();
        this._parentPath = Library.createNodePath(header.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteHeaderCommand] Executing.", new Object[0]);
        this._oldHeader = null;
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        OasHeader header = parent.getHeader(this._headerName);
        if (this.isNullOrUndefined(header)) {
            return;
        }
        parent.removeHeader(this._headerName);
        this._oldHeader = Library.writeNode(header);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteHeaderCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldHeader)) {
            return;
        }
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        OasHeader header = parent.createHeader(this._headerName);
        Library.readNode(this._oldHeader, header);
        parent.addHeader(this._headerName, header);
    }
}

