/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Scopes;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import java.util.ArrayList;
import java.util.List;

public class OasUnexpectedSecurityRequirementScopesRule
extends OasInvalidPropertyValueRule {
    public OasUnexpectedSecurityRequirementScopesRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidScopes(List<String> requiredScopes, Oas20Scopes definedScopes) {
        boolean rval = true;
        List<Object> dscopes = new ArrayList();
        if (this.hasValue(definedScopes)) {
            dscopes = definedScopes.getScopeNames();
        }
        for (String requiredScope : requiredScopes) {
            if (dscopes.indexOf(requiredScope) != -1) continue;
            rval = false;
        }
        return rval;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        List<String> snames = node.getSecurityRequirementNames();
        snames.forEach(sname -> {
            Oas20SecurityScheme scheme;
            Oas20SecurityDefinitions sdefs = ((Oas20Document)node.ownerDocument()).securityDefinitions;
            if (this.hasValue(sdefs) && this.hasValue(scheme = sdefs.getSecurityScheme((String)sname)) && this.equals(scheme.type, "oauth2")) {
                Oas20Scopes definedScopes = scheme.scopes;
                List<String> requiredScopes = node.getScopes((String)sname);
                this.reportIfInvalid(this.isValidScopes(requiredScopes, definedScopes), node, null, this.map("sname", (String)sname));
            }
        });
    }
}

