/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.rest.RestComponentVerifierExtension;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Component(value="rest")
@Metadata(label="verifiers", enums="parameters,connectivity")
public class RestComponent
extends DefaultComponent {
    public static final String DEFAULT_REST_CONFIGURATION_ID = "rest-configuration";
    @Deprecated
    @Metadata(label="producer")
    private String componentName;
    @Metadata(label="consumer")
    private String consumerComponentName;
    @Metadata(label="producer")
    private String producerComponentName;
    @Metadata(label="producer")
    private String apiDoc;
    @Metadata(label="producer")
    private String host;

    public RestComponent() {
        this.registerExtension(RestComponentVerifierExtension::new);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name;
        String uriTemplate;
        String path;
        String cname = this.getAndRemoveParameter(parameters, "consumerComponentName", String.class, this.consumerComponentName);
        String pname = this.getAndRemoveParameter(parameters, "producerComponentName", String.class, this.producerComponentName);
        RestEndpoint answer = new RestEndpoint(uri, this);
        answer.setConsumerComponentName(cname);
        answer.setProducerComponentName(pname);
        answer.setApiDoc(this.apiDoc);
        RestConfiguration config = CamelContextHelper.getRestConfiguration(this.getCamelContext(), cname, pname);
        Object h = this.getAndRemoveOrResolveReferenceParameter(parameters, "host", String.class, this.host);
        if (h == null) {
            h = config.getHost();
            int port = config.getPort();
            if (port > 0 && port != 80 && port != 443) {
                h = (String)h + ":" + port;
            }
        }
        if (h != null && !((String)h).startsWith("http://") && !((String)h).startsWith("https://")) {
            h = "http://" + (String)h;
        }
        answer.setHost((String)h);
        this.setProperties(answer, parameters);
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, Object> queryParameters = new LinkedHashMap<String, Object>(parameters);
            Map<String, Object> existingQueryParameters = URISupport.parseQuery(answer.getQueryParameters());
            queryParameters.putAll(existingQueryParameters);
            String remainingParameters = URISupport.createQueryString(queryParameters);
            answer.setQueryParameters(remainingParameters);
        }
        answer.setParameters(parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be rest:method:path[:uriTemplate] where uriTemplate is optional");
        }
        String method = StringHelper.before(remaining, ":");
        String s = StringHelper.after(remaining, ":");
        if (s != null && s.contains(":")) {
            path = StringHelper.before(s, ":");
            uriTemplate = StringHelper.after(s, ":");
        } else {
            path = s;
            uriTemplate = null;
        }
        path = FileUtil.stripTrailingSeparator(path);
        uriTemplate = FileUtil.stripTrailingSeparator(uriTemplate);
        answer.setMethod(method);
        answer.setPath(path);
        answer.setUriTemplate(uriTemplate);
        if (answer.getProducerComponentName() == null) {
            name = config.getProducerComponent();
            answer.setProducerComponentName(name);
        }
        if (answer.getConsumerComponentName() == null) {
            name = config.getComponent();
            answer.setConsumerComponentName(name);
        }
        if (answer.getApiDoc() == null) {
            answer.setApiDoc(config.getProducerApiDoc());
        }
        return answer;
    }

    public String getConsumerComponentName() {
        return this.consumerComponentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public String getProducerComponentName() {
        return this.producerComponentName;
    }

    public void setProducerComponentName(String producerComponentName) {
        this.producerComponentName = producerComponentName;
    }

    @Deprecated
    public String getComponentName() {
        return this.producerComponentName;
    }

    @Deprecated
    public void setComponentName(String componentName) {
        this.producerComponentName = componentName;
    }

    public String getApiDoc() {
        return this.apiDoc;
    }

    public void setApiDoc(String apiDoc) {
        this.apiDoc = apiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new).verify(scope, parameters);
    }
}

