/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;

@Converter(generateLoader=true)
public final class HttpEntityConverter {
    private HttpEntityConverter() {
    }

    @Converter
    public static HttpEntity toHttpEntity(byte[] data, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(data, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(InputStream inStream, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(inStream, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(String str, Exchange exchange) throws Exception {
        if (exchange != null && GZIPHelper.isGzip(exchange.getIn())) {
            byte[] data = exchange.getContext().getTypeConverter().convertTo(byte[].class, str);
            return HttpEntityConverter.asHttpEntity(data, exchange);
        }
        return null;
    }

    private static HttpEntity asHttpEntity(InputStream in, Exchange exchange) throws IOException {
        String contentEncoding;
        InputStream stream;
        InputStreamEntity entity = exchange != null && !exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class).booleanValue() ? new InputStreamEntity(stream, (stream = GZIPHelper.compressGzip(contentEncoding = exchange.getIn().getHeader("Content-Encoding", String.class), in)) instanceof ByteArrayInputStream ? (stream.available() != 0 ? (long)stream.available() : -1L) : -1L) : new InputStreamEntity(in, -1L);
        if (exchange != null) {
            String contentType;
            contentEncoding = exchange.getIn().getHeader("Content-Encoding", String.class);
            if (contentEncoding != null) {
                entity.setContentEncoding(contentEncoding);
            }
            if ((contentType = ExchangeHelper.getContentType(exchange)) != null) {
                entity.setContentType(contentType);
            }
        }
        return entity;
    }

    private static HttpEntity asHttpEntity(byte[] data, Exchange exchange) throws Exception {
        InputStream stream;
        boolean gzip;
        String contentEncoding = null;
        if (exchange != null) {
            contentEncoding = exchange.getIn().getHeader("Content-Encoding", String.class);
        }
        AbstractHttpEntity entity = exchange != null && !exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class).booleanValue() ? ((gzip = GZIPHelper.isGzip(contentEncoding)) ? new InputStreamEntity(stream, (stream = GZIPHelper.compressGzip(contentEncoding, data)) instanceof ByteArrayInputStream ? (stream.available() != 0 ? (long)stream.available() : -1L) : -1L) : new ByteArrayEntity(data)) : new ByteArrayEntity(data);
        if (exchange != null) {
            String contentType;
            if (contentEncoding != null) {
                entity.setContentEncoding(contentEncoding);
            }
            if ((contentType = ExchangeHelper.getContentType(exchange)) != null) {
                entity.setContentType(contentType);
            }
        }
        return entity;
    }
}

