/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http.HttpDeleteWithBodyMethod;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpEntityConverter;
import org.apache.camel.component.http.HttpGetWithBodyMethod;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpMethodHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private static final Integer OK_RESPONSE_CODE = 200;
    private HttpClient httpClient;
    private final HttpContext httpContext;
    private final boolean throwException;
    private final boolean transferException;
    private final HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();
    private int minOkRange;
    private int maxOkRange;
    private String defaultUrl;
    private URI defaultUri;
    private HttpHost defaultHttpHost;

    public HttpProducer(HttpEndpoint endpoint) {
        super(endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.httpContext = endpoint.getHttpContext();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        String range = this.getEndpoint().getOkStatusCodeRange();
        if (!range.contains(",")) {
            this.minOkRange = Integer.parseInt(StringHelper.before(range, "-"));
            this.maxOkRange = Integer.parseInt(StringHelper.after(range, "-"));
        }
        String url = this.getEndpoint().getHttpUri().toASCIIString();
        url = UnsafeUriCharactersEncoder.encodeHttpURI(url);
        URI uri = new URI(url);
        String queryString = this.getEndpoint().getHttpUri().getRawQuery();
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI(queryString);
            uri = URISupport.createURIWithQuery(uri, queryString);
        }
        this.defaultUri = uri;
        this.defaultUrl = uri.toASCIIString();
        this.defaultHttpHost = URIUtils.extractHost(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        HttpResponse response;
        String hostHeader;
        String key;
        boolean cookies;
        boolean bl = cookies = !this.getEndpoint().getComponent().isCookieManagementDisabled();
        if (cookies && this.getEndpoint().isClearExpiredCookies() && !this.getEndpoint().isBridgeEndpoint()) {
            this.getEndpoint().getCookieStore().clearExpired(new Date());
        }
        Map<String, Object> skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery(queryString, false, true);
            }
        }
        HttpRequestBase httpRequest = this.createMethod(exchange);
        HttpHost httpHost = this.createHost(httpRequest, exchange);
        Message in = exchange.getIn();
        String httpProtocolVersion = in.getHeader("CamelHttpProtocolVersion", String.class);
        if (httpProtocolVersion != null) {
            int[] version = HttpHelper.parserHttpVersion(httpProtocolVersion);
            httpRequest.setProtocolVersion(new HttpVersion(version[0], version[1]));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        if (!this.getEndpoint().isSkipRequestHeaders() && strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry<String, Object> entry : in.getHeaders().entrySet()) {
                Object headerValue;
                key = entry.getKey();
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || (headerValue = entry.getValue()) == null) continue;
                if (headerValue instanceof String || headerValue instanceof Integer || headerValue instanceof Long || headerValue instanceof Boolean || headerValue instanceof Date) {
                    String value = headerValue.toString();
                    if (strategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
                    httpRequest.addHeader(key, value);
                    continue;
                }
                Iterator<?> it = ObjectHelper.createIterator(headerValue, null, true);
                ArrayList<String> multiValues = null;
                String prev = null;
                while (it.hasNext()) {
                    String value = tc.convertTo(String.class, it.next());
                    if (value == null || strategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
                    if (prev == null) {
                        prev = value;
                        continue;
                    }
                    if (multiValues == null) {
                        multiValues = new ArrayList<String>();
                        multiValues.add(prev);
                    }
                    multiValues.add(value);
                }
                if (multiValues != null) {
                    String s = multiValues.size() > 1 ? ((Object)multiValues).toString() : (String)multiValues.get(0);
                    httpRequest.addHeader(key, s);
                    continue;
                }
                if (prev == null) continue;
                httpRequest.addHeader(key, prev);
            }
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map<String, List<String>> cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, httpRequest.getURI());
            for (Map.Entry<String, Object> exception : cookieHeaders.entrySet()) {
                key = exception.getKey();
                if (((List)exception.getValue()).isEmpty()) continue;
                httpRequest.addHeader(key, String.join((CharSequence)";", (Iterable)exception.getValue()));
            }
        }
        if (this.getEndpoint().getCustomHostHeader() != null) {
            httpRequest.setHeader("Host", this.getEndpoint().getCustomHostHeader());
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = exchange.getIn().getHeader("Host", String.class)) != null) {
            httpRequest.setHeader("Host", hostHeader);
        }
        if (this.getEndpoint().isConnectionClose()) {
            httpRequest.addHeader("Connection", "Close");
        }
        HttpResponse httpResponse = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing http {} method: {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getURI());
            }
            httpResponse = this.executeMethod(httpHost, httpRequest);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Http responseCode: {}", (Object)responseCode);
            }
            if (!this.throwException) {
                this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
            } else {
                void var11_18;
                if (this.minOkRange > 0) {
                    boolean bl2 = responseCode >= this.minOkRange && responseCode <= this.maxOkRange;
                } else {
                    boolean bl3 = HttpHelper.isStatusCodeOk(responseCode, this.getEndpoint().getOkStatusCodeRange());
                }
                if (var11_18 != false) {
                    this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
                } else {
                    throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
                }
            }
            response = httpResponse;
        }
        catch (Throwable throwable) {
            HttpResponse response2 = httpResponse;
            if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
                exchange.adapt(ExtendedExchange.class).addOnCompletion(new SynchronizationAdapter(response2){
                    final /* synthetic */ HttpResponse val$response;
                    {
                        this.val$response = httpResponse;
                    }

                    @Override
                    public void onDone(Exchange exchange) {
                        try {
                            EntityUtils.consume(this.val$response.getEntity());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else if (httpResponse != null) {
                try {
                    EntityUtils.consume(response2.getEntity());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
            exchange.adapt(ExtendedExchange.class).addOnCompletion(new /* invalid duplicate definition of identical inner class */);
        } else if (httpResponse != null) {
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Object response = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        Message answer = exchange.getOut();
        if (responseCode == 200) {
            answer.setHeader("CamelHttpResponseCode", OK_RESPONSE_CODE);
        } else {
            answer.setHeader("CamelHttpResponseCode", responseCode);
        }
        if (httpResponse.getStatusLine() != null) {
            answer.setHeader("CamelHttpResponseText", httpResponse.getStatusLine().getReasonPhrase());
        }
        answer.setBody(response);
        if (!this.getEndpoint().isSkipResponseHeaders()) {
            HashMap<String, List<String>> cookieHeaders = null;
            if (this.getEndpoint().getCookieHandler() != null) {
                cookieHeaders = new HashMap<String, List<String>>();
            }
            boolean found = false;
            HeaderIterator it = httpResponse.headerIterator();
            while (it.hasNext()) {
                Header header = it.nextHeader();
                String name = header.getName();
                String value = header.getValue();
                if (cookieHeaders != null) {
                    cookieHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
                }
                if (!found && name.equalsIgnoreCase("content-type")) {
                    name = "Content-Type";
                    exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType(value));
                    found = true;
                }
                Object extracted = HttpHelper.extractHttpParameterValue(value);
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                HttpHelper.appendHeader(answer.getHeaders(), name, extracted);
            }
            if (this.getEndpoint().getCookieHandler() != null) {
                this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), cookieHeaders);
            }
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders(exchange.getIn(), answer, this.httpProtocolHeaderFilterStrategy, false);
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        Header locationHeader;
        String uri = httpRequest.getURI().toString();
        String statusText = httpResponse.getStatusLine() != null ? httpResponse.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getAllHeaders());
        if (this.getEndpoint().getCookieHandler() != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), Collections.singletonList(e.getValue()));
            }
            this.getEndpoint().getCookieHandler().storeCookies(exchange, httpRequest.getURI(), m);
        }
        Object responseBody = this.extractResponseBody(httpRequest, httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = (locationHeader = httpResponse.getFirstHeader("location")) != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return answer;
    }

    protected HttpResponse executeMethod(HttpHost httpHost, HttpUriRequest httpRequest) throws IOException {
        BasicHttpContext localContext = new BasicHttpContext();
        if (this.getEndpoint().isAuthenticationPreemptive()) {
            BasicScheme basicAuth = new BasicScheme();
            localContext.setAttribute("preemptive-auth", basicAuth);
        }
        if (this.httpContext != null) {
            localContext = new BasicHttpContext(this.httpContext);
        }
        return this.httpClient.execute(httpHost, (HttpRequest)httpRequest, (HttpContext)localContext);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(HttpRequestBase httpRequest, HttpResponse httpResponse, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        String contentEncoding;
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class).booleanValue()) {
            is = GZIPHelper.uncompressGzip(contentEncoding, is);
        }
        String contentType = null;
        header = httpResponse.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType(contentType, exchange);
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream(is, exchange.getContext());
            }
            return null;
        }
        if (!this.getEndpoint().isDisableStreamCache()) {
            long len;
            if (ignoreResponseBody) {
                return null;
            }
            int max = this.getEndpoint().getComponent().getResponsePayloadStreamingThreshold();
            if (max > 0 && (len = entity.getContentLength()) > 0L && len <= (long)max) {
                int i = (int)len;
                byte[] arr = new byte[i];
                int read = 0;
                int offset = 0;
                for (int remain = i; (read = is.read(arr, offset, remain)) > 0 && remain > 0; remain -= read) {
                    offset += read;
                }
                IOHelper.close((Closeable)is);
                return arr;
            }
            return this.doExtractResponseBodyAsStream(is, exchange);
        }
        return is;
    }

    private InputStream doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        CachedOutputStream cos = null;
        try {
            cos = new CachedOutputStream(exchange, false);
            IOHelper.copy(is, cos);
            InputStream inputStream = cos.getWrappedInputStream();
            return inputStream;
        }
        catch (IOException ex) {
            try {
                cos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            IOHelper.close((Closeable)is, "Extracting response body", LOG);
        }
    }

    protected HttpHost createHost(HttpRequestBase httpRequest, Exchange exchange) {
        if (httpRequest.getURI() == this.defaultUri) {
            return this.defaultHttpHost;
        }
        return URIUtils.extractHost(httpRequest.getURI());
    }

    protected HttpRequestBase createMethod(Exchange exchange) throws Exception {
        HttpEntity requestEntity;
        if (this.defaultUri == null || this.defaultUrl == null) {
            throw new IllegalArgumentException("Producer must be started");
        }
        String url = this.defaultUrl;
        URI uri = this.defaultUri;
        boolean create = false;
        Message in = exchange.getIn();
        if (in.getHeader("CamelRestHttpUri") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpUri") != null && !this.getEndpoint().isBridgeEndpoint()) {
            create = true;
        } else if (in.getHeader("CamelHttpPath") != null) {
            create = true;
        } else if (in.getHeader("CamelRestHttpQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpRawQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpQuery") != null) {
            create = true;
        }
        if (create) {
            url = HttpHelper.createURL(exchange, this.getEndpoint());
            uri = HttpHelper.createURI(exchange, url, this.getEndpoint());
            url = uri.toASCIIString();
        }
        HttpMethods methodToUse = HttpMethodHelper.createMethod(exchange, this.getEndpoint());
        HttpRequestBase method = methodToUse.createMethod(uri);
        if (this.getEndpoint().isDeleteWithBody() && "DELETE".equals(method.getMethod())) {
            requestEntity = this.createRequestEntity(exchange);
            method = new HttpDeleteWithBodyMethod(uri, requestEntity);
        } else if (this.getEndpoint().isGetWithBody() && "GET".equals(method.getMethod())) {
            requestEntity = this.createRequestEntity(exchange);
            method = new HttpGetWithBodyMethod(uri, requestEntity);
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)method);
        if (methodToUse.isEntityEnclosing()) {
            requestEntity = this.createRequestEntity(exchange);
            ((HttpEntityEnclosingRequestBase)method).setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (method.getURI().getScheme() == null || method.getURI().getHost() == null) {
            throw new IllegalArgumentException("Invalid url: " + url + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + this.getEndpoint());
        }
        return method;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        HttpEntity answer = null;
        Message in = exchange.getIn();
        Object body = in.getBody();
        try {
            if (body == null) {
                return null;
            }
            if (body instanceof HttpEntity) {
                answer = (HttpEntity)body;
            } else if (body instanceof byte[]) {
                answer = HttpEntityConverter.toHttpEntity((byte[])body, exchange);
            } else if (body instanceof InputStream) {
                answer = HttpEntityConverter.toHttpEntity((InputStream)body, exchange);
            } else if (body instanceof String) {
                answer = HttpEntityConverter.toHttpEntity((String)body, exchange);
            }
        }
        catch (Exception e) {
            throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, e);
        }
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    AbstractHttpEntity entity;
                    String contentTypeString = ExchangeHelper.getContentType(exchange);
                    ContentType contentType = null;
                    if (contentTypeString != null) {
                        contentType = contentTypeString.indexOf("charset") > 0 || contentTypeString.indexOf(59) > 0 ? ContentType.parse(contentTypeString) : ContentType.create(contentTypeString);
                    }
                    if (contentTypeString != null && "application/x-java-serialized-object".equals(contentTypeString)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        HttpHelper.writeObjectToStream(bos, obj);
                        ByteArrayEntity entity2 = new ByteArrayEntity(bos.toByteArray());
                        entity2.setContentType("application/x-java-serialized-object");
                        IOHelper.close((Closeable)bos);
                        answer = entity2;
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = in.getBody(File.class);
                        if (file != null) {
                            answer = contentType != null ? new FileEntity(file, contentType) : new FileEntity(file);
                        }
                    } else if (data instanceof String) {
                        Charset cs;
                        String charset = ExchangeHelper.getCharsetName(exchange, false);
                        if (charset == null && contentType != null && (cs = contentType.getCharset()) != null) {
                            charset = cs.name();
                        }
                        entity = new StringEntity((String)data, charset);
                        entity.setContentType(contentType != null ? contentType.toString() : null);
                        answer = entity;
                    }
                    if (answer == null) {
                        InputStream is = in.getMandatoryBody(InputStream.class);
                        entity = new InputStreamEntity(is, -1L);
                        if (contentType != null) {
                            entity.setContentType(contentType.toString());
                        }
                        answer = entity;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

