/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.swagger;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class RestSwaggerProducer
extends DelegateAsyncProcessor
implements AsyncProducer {
    private final AsyncProducer delegate;
    private final boolean removeHostHeader;

    public RestSwaggerProducer(AsyncProducer delegate, boolean removeHostHeader) {
        super(delegate);
        this.delegate = delegate;
        this.removeHostHeader = removeHostHeader;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.removeHostHeader) {
            exchange.getMessage().removeHeader("Host");
        }
        return super.process(exchange, callback);
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        if (this.removeHostHeader) {
            exchange.getMessage().removeHeader("Host");
        }
        return super.processAsync(exchange);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.delegate.getEndpoint();
    }

    @Override
    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }
}

