/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.support.DefaultConsumer;

public class HttpConsumer
extends DefaultConsumer
implements Suspendable {
    protected volatile boolean canConnected;
    private volatile boolean suspended;
    private boolean traceEnabled;
    private boolean optionsEnabled;

    public HttpConsumer(HttpCommonEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        if (endpoint.isTraceEnabled()) {
            this.setTraceEnabled(true);
        }
        if (endpoint.isOptionsEnabled()) {
            this.setOptionsEnabled(true);
        }
    }

    @Override
    public HttpCommonEndpoint getEndpoint() {
        return (HttpCommonEndpoint)super.getEndpoint();
    }

    public HttpBinding getBinding() {
        return this.getEndpoint().getHttpBinding();
    }

    public String getPath() {
        return this.getEndpoint().getPath();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().canConnect(this)) {
            this.canConnected = true;
            this.getEndpoint().connect(this);
            this.suspended = false;
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.suspended = false;
        if (this.canConnected) {
            this.canConnected = false;
            this.getEndpoint().disconnect(this);
        }
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        this.suspended = true;
        super.doSuspend();
    }

    @Override
    protected void doResume() throws Exception {
        this.suspended = false;
        super.doResume();
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }
}

