/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PooledExchangeTask;
import org.apache.camel.processor.PooledExchangeTaskFactory;
import org.apache.camel.processor.PooledTaskFactory;
import org.apache.camel.processor.PrototypeTaskFactory;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapProcessor
extends AsyncProcessorSupport
implements Traceable,
ShutdownAware,
IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WireTapProcessor.class);
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final SendDynamicProcessor dynamicSendProcessor;
    private final String uri;
    private final boolean dynamicUri;
    private final Processor processor;
    private final AsyncProcessor asyncProcessor;
    private final ExchangePattern exchangePattern;
    private final boolean copy;
    private final ExecutorService executorService;
    private volatile boolean shutdownExecutorService;
    private final LongAdder taskCount = new LongAdder();
    private ProcessorExchangeFactory processorExchangeFactory;
    private PooledExchangeTaskFactory taskFactory;
    private Expression newExchangeExpression;
    private List<Processor> newExchangeProcessors;
    private Processor onPrepare;

    public WireTapProcessor(SendDynamicProcessor dynamicSendProcessor, Processor processor, String uri, ExchangePattern exchangePattern, boolean copy, ExecutorService executorService, boolean shutdownExecutorService, boolean dynamicUri) {
        this.dynamicSendProcessor = dynamicSendProcessor;
        this.uri = uri;
        this.processor = processor;
        this.asyncProcessor = AsyncProcessorConverterHelper.convert(processor);
        this.exchangePattern = exchangePattern;
        this.copy = copy;
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.dynamicUri = dynamicUri;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "wireTap(" + this.uri + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        return this.taskCount.intValue();
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        if (this.dynamicSendProcessor != null) {
            return this.dynamicSendProcessor.getEndpointUtilizationStatistics();
        }
        return null;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange target;
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + this);
        }
        try {
            target = this.configureExchange(exchange, this.exchangePattern);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        try {
            PooledExchangeTask task = this.taskFactory.acquire(target, null);
            this.executorService.submit(task);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) throws IOException {
        StreamCache cache;
        StreamCache copied;
        Message msg;
        Iterator<Processor> body;
        Exchange answer = this.copy ? this.configureCopyExchange(exchange) : this.configureNewExchange(exchange);
        if (this.newExchangeExpression != null && (body = this.newExchangeExpression.evaluate(answer, Object.class)) != null) {
            answer.getIn().setBody(body);
        }
        if (this.newExchangeProcessors != null) {
            for (Processor processor : this.newExchangeProcessors) {
                try {
                    processor.process(answer);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }
        }
        if ((msg = answer.getMessage()).getBody() instanceof StreamCache && (copied = (cache = (StreamCache)msg.getBody()).copy(answer)) != null) {
            msg.setBody(copied);
        }
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(answer);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = this.processorExchangeFactory.createCorrelatedCopy(exchange, false);
        copy.setPattern(ExchangePattern.InOnly);
        copy.removeProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK);
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        return this.processorExchangeFactory.create(exchange.getFromEndpoint(), ExchangePattern.InOnly);
    }

    public List<Processor> getNewExchangeProcessors() {
        return this.newExchangeProcessors;
    }

    public void setNewExchangeProcessors(List<Processor> newExchangeProcessors) {
        this.newExchangeProcessors = newExchangeProcessors;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public void addNewExchangeProcessor(Processor processor) {
        if (this.newExchangeProcessors == null) {
            this.newExchangeProcessors = new ArrayList<Processor>();
        }
        this.newExchangeProcessors.add(processor);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String getUri() {
        return this.uri;
    }

    public int getCacheSize() {
        if (this.dynamicSendProcessor != null) {
            return this.dynamicSendProcessor.getCacheSize();
        }
        return 0;
    }

    public boolean isIgnoreInvalidEndpoint() {
        if (this.dynamicSendProcessor != null) {
            return this.dynamicSendProcessor.isIgnoreInvalidEndpoint();
        }
        return false;
    }

    public boolean isDynamicUri() {
        return this.dynamicUri;
    }

    @Override
    protected void doBuild() throws Exception {
        this.processorExchangeFactory = this.getCamelContext().adapt(ExtendedCamelContext.class).getProcessorExchangeFactory().newProcessorExchangeFactory(this);
        this.processorExchangeFactory.setRouteId(this.getRouteId());
        this.processorExchangeFactory.setId(this.getId());
        boolean pooled = this.camelContext.adapt(ExtendedCamelContext.class).getExchangeFactory().isPooled();
        if (pooled) {
            this.taskFactory = new PooledTaskFactory(this.getId()){

                @Override
                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new WireTapTask();
                }
            };
            int capacity = this.camelContext.adapt(ExtendedCamelContext.class).getExchangeFactory().getCapacity();
            this.taskFactory.setCapacity(capacity);
        } else {
            this.taskFactory = new PrototypeTaskFactory(){

                @Override
                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new WireTapTask();
                }
            };
        }
        LOG.trace("Using TaskFactory: {}", (Object)this.taskFactory);
        ServiceHelper.buildService(this.processorExchangeFactory, this.taskFactory, this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService(this.processorExchangeFactory, this.taskFactory, this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processorExchangeFactory, this.taskFactory, this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processorExchangeFactory, this.taskFactory, this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.processorExchangeFactory, this.taskFactory, this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    private final class WireTapTask
    implements PooledExchangeTask,
    Runnable {
        private Exchange exchange;
        private final AsyncCallback callback = new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                WireTapProcessor.this.taskCount.decrement();
                if (WireTapProcessor.this.processorExchangeFactory != null) {
                    WireTapProcessor.this.processorExchangeFactory.release(WireTapTask.this.exchange);
                }
                WireTapProcessor.this.taskFactory.release(WireTapTask.this);
            }
        };

        private WireTapTask() {
        }

        @Override
        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
        }

        @Override
        public void reset() {
            this.exchange = null;
        }

        @Override
        public void run() {
            WireTapProcessor.this.taskCount.increment();
            LOG.debug(">>>> (wiretap) {} {}", (Object)WireTapProcessor.this.uri, (Object)this.exchange);
            WireTapProcessor.this.asyncProcessor.process(this.exchange, this.callback);
        }
    }
}

