/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.HttpClientBuilder;

public class ProxyHttpClientConfigurer
implements HttpClientConfigurer {
    private final String host;
    private final Integer port;
    private final String scheme;
    private final String username;
    private final String password;
    private final String domain;
    private final String ntHost;
    private final HttpCredentialsHelper credentialsHelper;

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme) {
        this(host, port, scheme, null, null, null, null, null);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme, String username, String password, String domain, String ntHost, HttpCredentialsHelper credentialsHelper) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.ntHost = ntHost;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        clientBuilder.setProxy(new HttpHost(this.host, (int)this.port, this.scheme));
        if (this.username != null && this.password != null) {
            Credentials defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.ntHost, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
            clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, this.port, defaultcreds));
        }
    }
}

