/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.net.URI;
import java.util.Map;
import org.apache.camel.cloud.DiscoverableService;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHeaderFilterStrategy;
import org.apache.camel.http.common.HttpMethods;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.CollectionHelper;

public abstract class HttpCommonEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
DiscoverableService {
    HttpCommonComponent component;
    @UriPath(label="common", description="The url of the HTTP endpoint to call.")
    @Metadata(required=true)
    URI httpUri;
    @UriParam(label="common", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    @UriParam(label="common,advanced", description="To use a custom HttpBinding to control the mapping between Camel message and HttpClient.")
    HttpBinding httpBinding;
    @UriParam(label="producer", defaultValue="true", description="Option to disable throwing the HttpOperationFailedException in case of failed responses from the remote server. This allows you to get all responses regardless of the HTTP status code.")
    boolean throwExceptionOnFailure = true;
    @UriParam(label="producer", description="If the option is true, HttpProducer will ignore the Exchange.HTTP_URI header, and use the endpoint's URI for request. You may also set the option throwExceptionOnFailure to be false to let the HttpProducer send all the fault response back.")
    boolean bridgeEndpoint;
    @UriParam(label="producer", description="If the option is true, HttpProducer will set the Host header to the value contained in the current exchange Host header, useful in reverse proxy applications where you want the Host header received by the downstream server to reflect the URL called by the upstream client, this allows applications which use the Host header to generate accurate URL's for a proxied service")
    boolean preserveHostHeader;
    @UriParam(label="consumer", description="Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.")
    boolean matchOnUriPrefix;
    @UriParam(defaultValue="true", description="If this option is false the Servlet will disable the HTTP streaming and set the content-length header on the response")
    boolean chunked = true;
    @UriParam(label="common", description="Determines whether or not the raw input stream from Servlet is cached or not (Camel will read the stream into a in memory/overflow to file, Stream caching) cache. By default Camel will cache the Servlet input stream to support reading it multiple times to ensure it Camel can retrieve all data from the stream. However you can set this option to true when you for example need to access the raw stream, such as streaming it directly to a file or other persistent store. DefaultHttpBinding will copy the request input stream into a stream cache and put it into message body if this option is false to support reading the stream multiple times. If you use Servlet to bridge/proxy an endpoint then consider enabling this option to improve performance, in case you do not need to read the message payload multiple times. The http producer will by default cache the response body stream. If setting this option to true, then the producers will not cache the response body stream but use the response stream as-is as the message body.")
    boolean disableStreamCache;
    @UriParam(description="If enabled and an Exchange failed processing on the consumer side, and if the caused Exception was send back serialized in the response as a application/x-java-serialized-object content type. On the producer side the exception will be deserialized and thrown as is, instead of the HttpOperationFailedException. The caused exception is required to be serialized. This is by default turned off. If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.")
    boolean transferException;
    @UriParam(label="consumer", description="If enabled and an Exchange failed processing on the consumer side the response's body won't contain the exception's stack trace.")
    boolean muteException;
    @UriParam(label="producer", defaultValue="false", description="Specifies whether a Connection Close header must be added to HTTP Request. By default connectionClose is false.")
    boolean connectionClose;
    @UriParam(label="consumer,advanced", description="Specifies whether to enable HTTP TRACE for this Servlet consumer. By default TRACE is turned off.")
    boolean traceEnabled;
    @UriParam(label="consumer,advanced", description="Specifies whether to enable HTTP OPTIONS for this Servlet consumer. By default OPTIONS is turned off.")
    boolean optionsEnabled;
    @UriParam(label="consumer", description="Used to only allow consuming if the HttpMethod matches, such as GET/POST/PUT etc. Multiple methods can be specified separated by comma.")
    String httpMethodRestrict;
    @UriParam(label="consumer", description="To use a custom buffer size on the javax.servlet.ServletResponse.")
    Integer responseBufferSize;
    @UriParam(label="producer", description="If this option is true, The http producer won't read response body and cache the input stream")
    boolean ignoreResponseBody;
    @UriParam(label="producer", defaultValue="true", description="If this option is true then IN exchange headers will be copied to OUT exchange headers according to copy strategy. Setting this to false, allows to only include the headers from the HTTP response (not propagating IN headers).")
    boolean copyHeaders = true;
    @UriParam(label="consumer,advanced", description="Whether to eager check whether the HTTP requests has content if the content-length header is 0 or not present. This can be turned on in case HTTP clients do not send streamed data.")
    boolean eagerCheckContentAvailable;
    @UriParam(label="consumer,advanced", defaultValue="true", description="If this option is true then IN exchange Body of the exchange will be mapped to HTTP body. Setting this to false will avoid the HTTP mapping.")
    boolean mapHttpMessageBody = true;
    @UriParam(label="consumer,advanced", defaultValue="true", description="If this option is true then IN exchange Headers of the exchange will be mapped to HTTP headers. Setting this to false will avoid the HTTP Headers mapping.")
    boolean mapHttpMessageHeaders = true;
    @UriParam(label="consumer,advanced", defaultValue="true", description="If this option is true then IN exchange Form Encoded body of the exchange will be mapped to HTTP. Setting this to false will avoid the HTTP Form Encoded body mapping.")
    boolean mapHttpMessageFormUrlEncodedBody = true;
    @UriParam(label="producer,advanced", defaultValue="200-299", description="The status codes which are considered a success response. The values are inclusive. Multiple ranges can be defined, separated by comma, e.g. 200-204,209,301-304. Each range must be a single number or from-to with the dash included.")
    private String okStatusCodeRange = "200-299";
    @UriParam(label="consumer", defaultValue="false", description="Configure the consumer to work in async mode")
    private boolean async;
    @UriParam(label="producer,advanced", description="Configure a cookie handler to maintain a HTTP session")
    private CookieHandler cookieHandler;
    @UriParam(label="producer", description="Configure the HTTP method to use. The HttpMethod header cannot override this option if set.")
    private HttpMethods httpMethod;
    @UriParam(label="producer,security", description="Authentication methods allowed to use as a comma separated list of values Basic, Digest or NTLM.")
    private String authMethod;
    @UriParam(label="producer,security", enums="Basic,Digest,NTLM", description="Which authentication method to prioritize to use, either as Basic, Digest or NTLM.")
    private String authMethodPriority;
    @UriParam(label="producer,security", secret=true, description="Authentication username")
    private String authUsername;
    @UriParam(label="producer,security", secret=true, description="Authentication password")
    private String authPassword;
    @UriParam(label="producer,security", description="Authentication domain to use with NTML")
    private String authDomain;
    @UriParam(label="producer,security", description="Authentication host to use with NTML")
    private String authHost;
    @UriParam(label="producer,proxy", description="Proxy hostname to use")
    private String proxyHost;
    @UriParam(label="producer,proxy", description="Proxy port to use")
    private int proxyPort;
    @UriParam(label="producer,proxy", enums="http,https", description="Proxy authentication scheme to use")
    private String proxyAuthScheme;
    @UriParam(label="producer,proxy", enums="Basic,Digest,NTLM", description="Proxy authentication method to use")
    private String proxyAuthMethod;
    @UriParam(label="producer,proxy", secret=true, description="Proxy authentication username")
    private String proxyAuthUsername;
    @UriParam(label="producer,proxy", secret=true, description="Proxy authentication password")
    private String proxyAuthPassword;
    @UriParam(label="producer,proxy", description="Proxy authentication host")
    private String proxyAuthHost;
    @UriParam(label="producer,proxy", description="Proxy authentication port")
    private int proxyAuthPort;
    @UriParam(label="producer,proxy", description="Proxy authentication domain to use with NTML")
    private String proxyAuthDomain;
    @UriParam(label="producer,proxy", description="Proxy authentication domain (workstation name) to use with NTML")
    private String proxyAuthNtHost;

    public HttpCommonEndpoint() {
    }

    public HttpCommonEndpoint(String endPointURI, HttpCommonComponent component, URI httpURI) {
        super(endPointURI, component);
        this.component = component;
        this.httpUri = httpURI;
    }

    public void connect(HttpConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public boolean canConnect(HttpConsumer consumer) throws Exception {
        return this.component.canConnect(consumer);
    }

    @Override
    public HttpCommonComponent getComponent() {
        return (HttpCommonComponent)super.getComponent();
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return CollectionHelper.immutableMapOf("service.port", Integer.toString(this.getPort()), "service.path", this.getPath(), "service.protocol", this.getProtocol());
    }

    @Deprecated
    public HttpBinding getBinding() {
        return this.httpBinding;
    }

    public HttpBinding getHttpBinding() {
        if (this.httpBinding == null) {
            this.httpBinding = new DefaultHttpBinding();
            this.httpBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.httpBinding.setTransferException(this.isTransferException());
            this.httpBinding.setMuteException(this.isMuteException());
            if (this.getComponent() != null) {
                this.httpBinding.setAllowJavaSerializedObject(this.getComponent().isAllowJavaSerializedObject());
            }
            this.httpBinding.setEagerCheckContentAvailable(this.isEagerCheckContentAvailable());
            this.httpBinding.setMapHttpMessageBody(this.isMapHttpMessageBody());
            this.httpBinding.setMapHttpMessageHeaders(this.isMapHttpMessageHeaders());
            this.httpBinding.setMapHttpMessageFormUrlEncodedBody(this.isMapHttpMessageFormUrlEncodedBody());
        }
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public String getPath() {
        return this.httpUri.getPath().length() == 0 ? "/" : this.httpUri.getPath();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridge) {
        this.bridgeEndpoint = bridge;
    }

    public boolean isPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    public void setPreserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean match) {
        this.matchOnUriPrefix = match;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disable) {
        this.disableStreamCache = disable;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public boolean isConnectionClose() {
        return this.connectionClose;
    }

    public void setConnectionClose(boolean connectionClose) {
        this.connectionClose = connectionClose;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public Integer getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(Integer responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public boolean isIgnoreResponseBody() {
        return this.ignoreResponseBody;
    }

    public void setIgnoreResponseBody(boolean ignoreResponseBody) {
        this.ignoreResponseBody = ignoreResponseBody;
    }

    public boolean isCopyHeaders() {
        return this.copyHeaders;
    }

    public void setCopyHeaders(boolean copyHeaders) {
        this.copyHeaders = copyHeaders;
    }

    public boolean isEagerCheckContentAvailable() {
        return this.eagerCheckContentAvailable;
    }

    public void setEagerCheckContentAvailable(boolean eagerCheckContentAvailable) {
        this.eagerCheckContentAvailable = eagerCheckContentAvailable;
    }

    public String getOkStatusCodeRange() {
        return this.okStatusCodeRange;
    }

    public void setOkStatusCodeRange(String okStatusCodeRange) {
        this.okStatusCodeRange = okStatusCodeRange;
    }

    public boolean isMapHttpMessageBody() {
        return this.mapHttpMessageBody;
    }

    public void setMapHttpMessageBody(boolean mapHttpMessageBody) {
        this.mapHttpMessageBody = mapHttpMessageBody;
    }

    public boolean isMapHttpMessageHeaders() {
        return this.mapHttpMessageHeaders;
    }

    public void setMapHttpMessageHeaders(boolean mapHttpMessageHeaders) {
        this.mapHttpMessageHeaders = mapHttpMessageHeaders;
    }

    public boolean isMapHttpMessageFormUrlEncodedBody() {
        return this.mapHttpMessageFormUrlEncodedBody;
    }

    public void setMapHttpMessageFormUrlEncodedBody(boolean mapHttpMessageFormUrlEncodedBody) {
        this.mapHttpMessageFormUrlEncodedBody = mapHttpMessageFormUrlEncodedBody;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public HttpMethods getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethods httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getAuthMethodPriority() {
        return this.authMethodPriority;
    }

    public void setAuthMethodPriority(String authMethodPriority) {
        this.authMethodPriority = authMethodPriority;
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = authDomain;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getProxyAuthScheme() {
        return this.proxyAuthScheme;
    }

    public void setProxyAuthScheme(String proxyAuthScheme) {
        this.proxyAuthScheme = proxyAuthScheme;
    }

    public String getProxyAuthMethod() {
        return this.proxyAuthMethod;
    }

    public void setProxyAuthMethod(String proxyAuthMethod) {
        this.proxyAuthMethod = proxyAuthMethod;
    }

    public String getProxyAuthUsername() {
        return this.proxyAuthUsername;
    }

    public void setProxyAuthUsername(String proxyAuthUsername) {
        this.proxyAuthUsername = proxyAuthUsername;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
    }

    public String getProxyAuthDomain() {
        return this.proxyAuthDomain;
    }

    public void setProxyAuthDomain(String proxyAuthDomain) {
        this.proxyAuthDomain = proxyAuthDomain;
    }

    public String getProxyAuthHost() {
        return this.proxyAuthHost;
    }

    public void setProxyAuthHost(String proxyAuthHost) {
        this.proxyAuthHost = proxyAuthHost;
    }

    public int getProxyAuthPort() {
        return this.proxyAuthPort;
    }

    public void setProxyAuthPort(int proxyAuthPort) {
        this.proxyAuthPort = proxyAuthPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyAuthNtHost() {
        return this.proxyAuthNtHost;
    }

    public void setProxyAuthNtHost(String proxyAuthNtHost) {
        this.proxyAuthNtHost = proxyAuthNtHost;
    }
}

