/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jnr.ffi.Library;
import jnr.ffi.LibraryLoader;
import jnr.ffi.LibraryOption;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.mapper.FunctionMapper;
import jnr.posix.AixLibC;
import jnr.posix.AixPOSIX;
import jnr.posix.CheckedPOSIX;
import jnr.posix.Crypt;
import jnr.posix.DragonFlyPOSIX;
import jnr.posix.FreeBSDPOSIX;
import jnr.posix.JavaPOSIX;
import jnr.posix.LazyPOSIX;
import jnr.posix.LibC;
import jnr.posix.LibCProvider;
import jnr.posix.LinuxLibC;
import jnr.posix.LinuxPOSIX;
import jnr.posix.MacOSPOSIX;
import jnr.posix.OpenBSDPOSIX;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.POSIXTypeMapper;
import jnr.posix.SimpleFunctionMapper;
import jnr.posix.SolarisLibC;
import jnr.posix.SolarisPOSIX;
import jnr.posix.UnixLibC;
import jnr.posix.WindowsLibC;
import jnr.posix.WindowsPOSIX;
import jnr.posix.util.DefaultPOSIXHandler;
import jnr.posix.util.Platform;

public class POSIXFactory {
    private static final Class<Struct> BOGUS_HACK = Struct.class;
    public static final jnr.ffi.Platform NATIVE_PLATFORM = jnr.ffi.Platform.getNativePlatform();
    public static final String STANDARD_C_LIBRARY_NAME = NATIVE_PLATFORM.getStandardCLibraryName();

    public static POSIX getPOSIX(POSIXHandler handler2, boolean useNativePOSIX) {
        return new LazyPOSIX(handler2, useNativePOSIX);
    }

    public static POSIX getPOSIX() {
        return POSIXFactory.getPOSIX(new DefaultPOSIXHandler(), true);
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler2) {
        return new JavaPOSIX(handler2);
    }

    public static POSIX getJavaPOSIX() {
        return POSIXFactory.getJavaPOSIX(new DefaultPOSIXHandler());
    }

    public static POSIX getNativePOSIX(POSIXHandler handler2) {
        return POSIXFactory.loadNativePOSIX(handler2);
    }

    public static POSIX getNativePOSIX() {
        return POSIXFactory.getNativePOSIX(new DefaultPOSIXHandler());
    }

    static POSIX loadPOSIX(POSIXHandler handler2, boolean useNativePOSIX) {
        POSIX posix2;
        block7: {
            posix2 = null;
            if (useNativePOSIX) {
                try {
                    posix2 = POSIXFactory.loadNativePOSIX(handler2);
                    POSIX pOSIX = posix2 = posix2 != null ? new CheckedPOSIX(posix2, handler2) : null;
                    if (handler2.isVerbose()) {
                        if (posix2 != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler2.isVerbose()) break block7;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix2 == null) {
            posix2 = POSIXFactory.getJavaPOSIX(handler2);
        }
        return posix2;
    }

    private static POSIX loadNativePOSIX(POSIXHandler handler2) {
        switch (NATIVE_PLATFORM.getOS()) {
            case DARWIN: {
                return POSIXFactory.loadMacOSPOSIX(handler2);
            }
            case LINUX: {
                return POSIXFactory.loadLinuxPOSIX(handler2);
            }
            case FREEBSD: {
                return POSIXFactory.loadFreeBSDPOSIX(handler2);
            }
            case DRAGONFLY: {
                return POSIXFactory.loadDragonFlyPOSIX(handler2);
            }
            case OPENBSD: {
                return POSIXFactory.loadOpenBSDPOSIX(handler2);
            }
            case SOLARIS: {
                return POSIXFactory.loadSolarisPOSIX(handler2);
            }
            case AIX: {
                return POSIXFactory.loadAixPOSIX(handler2);
            }
            case WINDOWS: {
                return POSIXFactory.loadWindowsPOSIX(handler2);
            }
        }
        return null;
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler2) {
        return new LinuxPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler2) {
        return new MacOSPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler2) {
        return new SolarisPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler handler2) {
        return new FreeBSDPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadDragonFlyPOSIX(POSIXHandler handler2) {
        return new DragonFlyPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler handler2) {
        return new OpenBSDPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler2) {
        return new WindowsPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadAixPOSIX(POSIXHandler handler2) {
        return new AixPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    private static String[] libraries() {
        switch (NATIVE_PLATFORM.getOS()) {
            case LINUX: {
                return new String[]{STANDARD_C_LIBRARY_NAME};
            }
            case SOLARIS: {
                return new String[]{"socket", "nsl", STANDARD_C_LIBRARY_NAME};
            }
            case FREEBSD: 
            case DRAGONFLY: 
            case NETBSD: {
                return new String[]{STANDARD_C_LIBRARY_NAME};
            }
            case AIX: {
                String[] stringArray;
                if (Runtime.getSystemRuntime().addressSize() == 4) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "libc.a(shr.o)";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "libc.a(shr_64.o)";
                }
                return stringArray;
            }
            case WINDOWS: {
                return new String[]{"msvcrt", "kernel32"};
            }
        }
        return new String[]{STANDARD_C_LIBRARY_NAME};
    }

    private static Class<? extends LibC> libraryInterface() {
        switch (NATIVE_PLATFORM.getOS()) {
            case LINUX: {
                return LinuxLibC.class;
            }
            case AIX: {
                return AixLibC.class;
            }
            case SOLARIS: {
                return SolarisLibC.class;
            }
            case WINDOWS: {
                return WindowsLibC.class;
            }
        }
        return UnixLibC.class;
    }

    private static FunctionMapper functionMapper() {
        switch (NATIVE_PLATFORM.getOS()) {
            case AIX: {
                return new SimpleFunctionMapper.Builder().map("stat", "stat64x").map("fstat", "fstat64x").map("lstat", "lstat64x").map("stat64", "stat64x").map("fstat64", "fstat64x").map("lstat64", "lstat64x").build();
            }
            case WINDOWS: {
                return new SimpleFunctionMapper.Builder().map("getpid", "_getpid").map("chmod", "_chmod").map("fstat", "_fstat64").map("stat", "_stat64").map("umask", "_umask").map("isatty", "_isatty").map("read", "_read").map("write", "_write").map("close", "_close").map("getcwd", "_getcwd").map("unlink", "_unlink").map("access", "_access").map("open", "_open").map("dup", "_dup").map("dup2", "_dup2").map("lseek", "_lseek").map("ftruncate", "_chsize").build();
            }
            case SOLARIS: {
                return Platform.IS_32_BIT ? new SimpleFunctionMapper.Builder().map("stat", "stat64").map("fstat", "fstat64").map("lstat", "lstat64").build() : null;
            }
        }
        return null;
    }

    private static Map<LibraryOption, Object> options() {
        HashMap<LibraryOption, Object> options = new HashMap<LibraryOption, Object>();
        FunctionMapper functionMapper = POSIXFactory.functionMapper();
        if (functionMapper != null) {
            options.put(LibraryOption.FunctionMapper, functionMapper);
        }
        options.put(LibraryOption.TypeMapper, POSIXTypeMapper.INSTANCE);
        options.put(LibraryOption.LoadNow, Boolean.TRUE);
        return Collections.unmodifiableMap(options);
    }

    static /* synthetic */ Class access$000() {
        return POSIXFactory.libraryInterface();
    }

    static /* synthetic */ Map access$100() {
        return POSIXFactory.options();
    }

    static /* synthetic */ String[] access$200() {
        return POSIXFactory.libraries();
    }

    private static final class DefaultLibCProvider
    implements LibCProvider {
        public static final LibCProvider INSTANCE = new DefaultLibCProvider();

        private DefaultLibCProvider() {
        }

        @Override
        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        @Override
        public final Crypt getCrypt() {
            return SingletonHolder.crypt;
        }

        private static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(POSIXFactory.access$000(), POSIXFactory.access$100(), POSIXFactory.access$200());
            public static Crypt crypt;

            private SingletonHolder() {
            }

            static {
                Crypt c = null;
                try {
                    LibraryLoader<Crypt> loader2 = LibraryLoader.create(Crypt.class).failImmediately();
                    c = loader2.load("libcrypt.so.1");
                }
                catch (UnsatisfiedLinkError ule) {
                    try {
                        LibraryLoader<Crypt> loader3 = LibraryLoader.create(Crypt.class).failImmediately();
                        c = loader3.load("crypt");
                    }
                    catch (UnsatisfiedLinkError ule2) {
                        try {
                            LibraryLoader<Crypt> loader4 = LibraryLoader.create(Crypt.class).failImmediately();
                            c = loader4.load(STANDARD_C_LIBRARY_NAME);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            // empty catch block
                        }
                    }
                }
                crypt = c;
            }
        }
    }
}

