/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;

public class CamelExchangeException
extends CamelException {
    private static final long serialVersionUID = -8721487431101572630L;
    private final transient Exchange exchange;

    public CamelExchangeException(String message2, Exchange exchange) {
        super(CamelExchangeException.createExceptionMessage(message2, exchange, null));
        this.exchange = exchange;
    }

    public CamelExchangeException(String message2, Exchange exchange, Throwable cause) {
        super(CamelExchangeException.createExceptionMessage(message2, exchange, cause), cause);
        this.exchange = exchange;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public static String createExceptionMessage(String message2, Exchange exchange, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        if (message2 != null) {
            sb.append(message2);
        }
        if (exchange != null) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append(exchange);
        }
        if (cause != null) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Caused by: [" + cause.getClass().getName() + " - " + cause.getMessage() + "]");
        }
        return sb.toString().trim();
    }
}

