/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ComponentVerifierExtension {

    static class GroupErrorAttribute
    extends ErrorAttribute
    implements VerificationError.GroupAttribute {
        GroupErrorAttribute(String name) {
            super(name);
        }
    }

    static class HttpErrorAttribute
    extends ErrorAttribute
    implements VerificationError.HttpAttribute {
        HttpErrorAttribute(String name) {
            super(name);
        }
    }

    static class ExceptionErrorAttribute
    extends ErrorAttribute
    implements VerificationError.ExceptionAttribute {
        ExceptionErrorAttribute(String name) {
            super(name);
        }
    }

    static class StandardErrorCode
    extends ErrorCode
    implements VerificationError.StandardCode {
        StandardErrorCode(String name) {
            super(name);
        }
    }

    static class ErrorAttribute
    implements VerificationError.Attribute {
        private final String name;

        ErrorAttribute(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of an error attribute must not be null");
            }
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VerificationError.Attribute)) {
                return false;
            }
            VerificationError.Attribute that = (VerificationError.Attribute)o;
            return this.name.equals(that.name());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name();
        }
    }

    static class ErrorCode
    implements VerificationError.Code {
        private final String name;

        ErrorCode(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of an error code must not be null");
            }
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VerificationError.Code)) {
                return false;
            }
            VerificationError.Code errorCode = (VerificationError.Code)o;
            return this.name.equals(errorCode.name());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name();
        }
    }

    public static interface VerificationError
    extends Serializable {
        public Code getCode();

        public String getDescription();

        public Set<String> getParameterKeys();

        public Map<Attribute, Object> getDetails();

        default public Object getDetail(Attribute attribute) {
            Map<Attribute, Object> details = this.getDetails();
            if (details != null) {
                return details.get(attribute);
            }
            return null;
        }

        default public Object getDetail(String attribute) {
            return this.getDetail(VerificationError.asAttribute(attribute));
        }

        public static Code asCode(String code2) {
            return new ErrorCode(code2);
        }

        public static Attribute asAttribute(String attribute) {
            return new ErrorAttribute(attribute);
        }

        public static interface GroupAttribute
        extends Attribute {
            public static final GroupAttribute GROUP_NAME = new GroupErrorAttribute("GROUP_NAME");
            public static final GroupAttribute GROUP_OPTIONS = new GroupErrorAttribute("GROUP_OPTIONS");
        }

        public static interface HttpAttribute
        extends Attribute {
            public static final HttpAttribute HTTP_CODE = new HttpErrorAttribute("HTTP_CODE");
            public static final HttpAttribute HTTP_TEXT = new HttpErrorAttribute("HTTP_TEXT");
            public static final HttpAttribute HTTP_REDIRECT = new HttpErrorAttribute("HTTP_REDIRECT");
        }

        public static interface ExceptionAttribute
        extends Attribute {
            public static final ExceptionAttribute EXCEPTION_INSTANCE = new ExceptionErrorAttribute("EXCEPTION_INSTANCE");
            public static final ExceptionAttribute EXCEPTION_CLASS = new ExceptionErrorAttribute("EXCEPTION_CLASS");
        }

        public static interface Attribute
        extends Serializable {
            public String name();

            default public String getName() {
                return this.name();
            }
        }

        public static interface StandardCode
        extends Code {
            public static final StandardCode AUTHENTICATION = new StandardErrorCode("AUTHENTICATION");
            public static final StandardCode EXCEPTION = new StandardErrorCode("EXCEPTION");
            public static final StandardCode INTERNAL = new StandardErrorCode("INTERNAL");
            public static final StandardCode MISSING_PARAMETER = new StandardErrorCode("MISSING_PARAMETER");
            public static final StandardCode UNKNOWN_PARAMETER = new StandardErrorCode("UNKNOWN_PARAMETER");
            public static final StandardCode ILLEGAL_PARAMETER = new StandardErrorCode("ILLEGAL_PARAMETER");
            public static final StandardCode ILLEGAL_PARAMETER_GROUP_COMBINATION = new StandardErrorCode("ILLEGAL_PARAMETER_GROUP_COMBINATION");
            public static final StandardCode ILLEGAL_PARAMETER_VALUE = new StandardErrorCode("ILLEGAL_PARAMETER_VALUE");
            public static final StandardCode INCOMPLETE_PARAMETER_GROUP = new StandardErrorCode("INCOMPLETE_PARAMETER_GROUP");
            public static final StandardCode UNSUPPORTED = new StandardErrorCode("UNSUPPORTED");
            public static final StandardCode UNSUPPORTED_SCOPE = new StandardErrorCode("UNSUPPORTED_SCOPE");
            public static final StandardCode UNSUPPORTED_COMPONENT = new StandardErrorCode("UNSUPPORTED_COMPONENT");
            public static final StandardCode GENERIC = new StandardErrorCode("GENERIC");
        }

        public static interface Code
        extends Serializable {
            public String name();

            default public String getName() {
                return this.name();
            }
        }
    }

    public static enum Scope {
        PARAMETERS,
        CONNECTIVITY;


        public static Scope fromString(String scope) {
            return Scope.valueOf(scope != null ? scope.toUpperCase() : null);
        }
    }

    public static interface Result
    extends Serializable {
        public Scope getScope();

        public Status getStatus();

        public List<VerificationError> getErrors();

        public static enum Status {
            OK,
            ERROR,
            UNSUPPORTED;

        }
    }
}

