/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultResultVerificationError;
import org.apache.camel.util.ObjectHelper;

public final class ResultErrorBuilder {
    private ComponentVerifierExtension.VerificationError.Code code;
    private String description;
    private Set<String> parameters;
    private Map<ComponentVerifierExtension.VerificationError.Attribute, Object> attributes;

    public ResultErrorBuilder code(ComponentVerifierExtension.VerificationError.Code code2) {
        this.code = code2;
        return this;
    }

    public ResultErrorBuilder code(String code2) {
        this.code(ComponentVerifierExtension.VerificationError.asCode(code2));
        return this;
    }

    public ResultErrorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ResultErrorBuilder parameterKey(String parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = new HashSet<String>();
            }
            this.parameters.add(parameter);
        }
        return this;
    }

    public ResultErrorBuilder parameterKeys(Collection<String> parameterList) {
        if (parameterList != null) {
            parameterList.forEach(this::parameterKey);
        }
        return this;
    }

    public ResultErrorBuilder detail(String key, Object value) {
        this.detail(ComponentVerifierExtension.VerificationError.asAttribute(key), value);
        return this;
    }

    public ResultErrorBuilder detail(ComponentVerifierExtension.VerificationError.Attribute key, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<ComponentVerifierExtension.VerificationError.Attribute, Object>();
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    public <T> ResultErrorBuilder detail(String key, Supplier<Optional<T>> supplier) {
        this.detail(ComponentVerifierExtension.VerificationError.asAttribute(key), supplier);
        return this;
    }

    public <T> ResultErrorBuilder detail(ComponentVerifierExtension.VerificationError.Attribute key, Supplier<Optional<T>> supplier) {
        supplier.get().ifPresent(value -> this.detail(key, value));
        return this;
    }

    public ResultErrorBuilder details(Map<ComponentVerifierExtension.VerificationError.Attribute, Object> details) {
        for (Map.Entry<ComponentVerifierExtension.VerificationError.Attribute, Object> entry : details.entrySet()) {
            this.detail(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ComponentVerifierExtension.VerificationError build() {
        return new DefaultResultVerificationError(this.code, this.description, this.parameters != null ? Collections.unmodifiableSet(this.parameters) : Collections.emptySet(), this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap());
    }

    public static ResultErrorBuilder fromError(ComponentVerifierExtension.VerificationError error2) {
        return new ResultErrorBuilder().code(error2.getCode()).description(error2.getDescription()).parameterKeys(error2.getParameterKeys()).details(error2.getDetails());
    }

    public static ResultErrorBuilder withCode(ComponentVerifierExtension.VerificationError.Code code2) {
        return new ResultErrorBuilder().code(code2);
    }

    public static ResultErrorBuilder withCode(String code2) {
        return new ResultErrorBuilder().code(code2);
    }

    public static ResultErrorBuilder withHttpCode(int code2) {
        return ResultErrorBuilder.withCode(ResultErrorBuilder.convertHttpCodeToErrorCode(code2)).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE, (Object)code2);
    }

    public static ResultErrorBuilder withHttpCodeAndText(int code2, String text2) {
        return ResultErrorBuilder.withCodeAndDescription(ResultErrorBuilder.convertHttpCodeToErrorCode(code2), text2).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE, (Object)code2).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_TEXT, (Object)text2);
    }

    private static ComponentVerifierExtension.VerificationError.StandardCode convertHttpCodeToErrorCode(int code2) {
        return code2 >= 400 && code2 < 500 ? ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION : ComponentVerifierExtension.VerificationError.StandardCode.GENERIC;
    }

    public static ResultErrorBuilder withCodeAndDescription(ComponentVerifierExtension.VerificationError.Code code2, String description) {
        return new ResultErrorBuilder().code(code2).description(description);
    }

    public static ResultErrorBuilder withUnsupportedScope(String scope) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_SCOPE).description("Unsupported scope: " + scope);
    }

    public static ResultErrorBuilder withUnsupportedComponent(String component) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_COMPONENT).description("Unsupported component: " + component);
    }

    public static ResultErrorBuilder withException(Exception exception) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.EXCEPTION).description(exception.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)exception).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)exception.getClass().getName());
    }

    public static ResultErrorBuilder withMissingOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.MISSING_PARAMETER).description(optionName + " should be set").parameterKey(optionName);
    }

    public static ResultErrorBuilder withUnknownOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.UNKNOWN_PARAMETER).description("Unknown option " + optionName).parameterKey(optionName);
    }

    public static ResultErrorBuilder withIllegalOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER).description("Illegal option " + optionName).parameterKey(optionName);
    }

    public static ResultErrorBuilder withIllegalOption(String optionName, String optionValue) {
        return ObjectHelper.isNotEmpty(optionValue) ? new ResultErrorBuilder().code(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE).description(optionName + " has wrong value (" + optionValue + ")").parameterKey(optionName) : ResultErrorBuilder.withIllegalOption(optionName);
    }
}

