/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Builder;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.util.ObjectHelper;

public final class HealthCheckResultBuilder
implements Builder<HealthCheck.Result> {
    private final HealthCheck check;
    private String message;
    private Throwable error;
    private Map<String, Object> details;
    private HealthCheck.State state;

    private HealthCheckResultBuilder(HealthCheck check2) {
        this.check = check2;
    }

    public String message() {
        return this.message;
    }

    public HealthCheckResultBuilder message(String message2) {
        this.message = message2;
        return this;
    }

    public Throwable error() {
        return this.error;
    }

    public HealthCheckResultBuilder error(Throwable error2) {
        this.error = error2;
        return this;
    }

    public Object detail(String key) {
        return this.details != null ? this.details.get(key) : null;
    }

    public HealthCheckResultBuilder detail(String key, Object value) {
        if (this.details == null) {
            this.details = new HashMap<String, Object>();
        }
        this.details.put(key, value);
        return this;
    }

    public HealthCheckResultBuilder details(Map<String, Object> details) {
        if (ObjectHelper.isNotEmpty(details)) {
            details.forEach(this::detail);
        }
        return this;
    }

    public HealthCheck.State state() {
        return this.state;
    }

    public HealthCheckResultBuilder state(HealthCheck.State state) {
        this.state = state;
        return this;
    }

    public HealthCheckResultBuilder up() {
        return this.state(HealthCheck.State.UP);
    }

    public HealthCheckResultBuilder down() {
        return this.state(HealthCheck.State.DOWN);
    }

    public HealthCheckResultBuilder unknown() {
        return this.state(HealthCheck.State.UNKNOWN);
    }

    @Override
    public HealthCheck.Result build() {
        ObjectHelper.notNull(this.state, "Response State");
        final HealthCheck.State responseState = this.state;
        final Optional<String> responseMessage = Optional.ofNullable(this.message);
        final Optional<Throwable> responseError = Optional.ofNullable(this.error);
        final Map responseDetails = ObjectHelper.isNotEmpty(this.details) ? Collections.unmodifiableMap(new HashMap<String, Object>(this.details)) : Collections.emptyMap();
        return new HealthCheck.Result(){

            @Override
            public HealthCheck getCheck() {
                return HealthCheckResultBuilder.this.check;
            }

            @Override
            public HealthCheck.State getState() {
                return responseState;
            }

            @Override
            public Optional<String> getMessage() {
                return responseMessage;
            }

            @Override
            public Optional<Throwable> getError() {
                return responseError;
            }

            @Override
            public Map<String, Object> getDetails() {
                return responseDetails;
            }
        };
    }

    public static HealthCheckResultBuilder on(HealthCheck check2) {
        return new HealthCheckResultBuilder(check2);
    }

    public String toString() {
        return "HealthCheck[" + this.check.getGroup() + "/" + this.check.getId() + "]";
    }
}

