/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChildServiceSupport
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ChildServiceSupport.class);
    protected volatile List<Service> childServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 5) {
                LOG.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 4) {
                LOG.trace("Service: {} already starting", (Object)this);
                return;
            }
            try {
                ServiceHelper.initService(this.childServices);
            }
            catch (Exception e) {
                this.status = (byte)12;
                LOG.trace("Error while initializing service: {}", (Object)this, (Object)e);
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
            try {
                this.status = (byte)4;
                LOG.trace("Starting service: {}", (Object)this);
                ServiceHelper.startService(this.childServices);
                this.doStart();
                this.status = (byte)5;
                LOG.trace("Service: {} started", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)12;
                LOG.trace("Error while starting service: {}", (Object)this, (Object)e);
                ServiceHelper.stopService(this.childServices);
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 9 || this.status == 10 || this.status == 11) {
                LOG.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 8) {
                LOG.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = (byte)8;
            LOG.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                ServiceHelper.stopService(this.childServices);
                this.status = (byte)9;
                LOG.trace("Service: {} stopped service", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)12;
                LOG.trace("Error while stopping service: {}", (Object)this, (Object)e);
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 11) {
                LOG.trace("Service: {} already shut down", (Object)this);
                return;
            }
            if (this.status == 10) {
                LOG.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = (byte)11;
            LOG.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                ServiceHelper.stopAndShutdownServices(this.childServices);
                LOG.trace("Service: {} shut down", (Object)this);
                this.status = (byte)11;
            }
            catch (Exception e) {
                this.status = (byte)12;
                LOG.trace("Error shutting down service: {}", (Object)this, (Object)e);
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        if (childService instanceof Service) {
            Object object = this.lock;
            synchronized (object) {
                if (this.childServices == null) {
                    this.childServices = new ArrayList<Service>();
                }
                this.childServices.add((Service)childService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeChildService(Object childService) {
        if (childService instanceof Service) {
            Object object = this.lock;
            synchronized (object) {
                if (this.childServices != null) {
                    return this.childServices.remove(childService);
                }
            }
        }
        return false;
    }
}

