/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public final class GZIPHelper {
    private GZIPHelper() {
    }

    public static InputStream uncompressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayOutputStream os2 = new ByteArrayOutputStream();
            GZIPOutputStream gzip2 = new GZIPOutputStream(os2);
            try {
                IOHelper.copy(in, gzip2);
                gzip2.finish();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os2.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                IOHelper.close((Closeable)gzip2, "gzip");
                IOHelper.close((Closeable)os2, "byte array output stream");
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, byte[] data) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream os2 = null;
            GZIPOutputStream gzip2 = null;
            try {
                os2 = new ByteArrayOutputStream();
                gzip2 = new GZIPOutputStream(os2);
                gzip2.write(data);
                gzip2.finish();
                byteArrayInputStream = new ByteArrayInputStream(os2.toByteArray());
            }
            catch (Throwable throwable) {
                IOHelper.close(gzip2, "gzip");
                IOHelper.close((Closeable)os2, "byte array output stream");
                throw throwable;
            }
            IOHelper.close((Closeable)gzip2, "gzip");
            IOHelper.close((Closeable)os2, "byte array output stream");
            return byteArrayInputStream;
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressGZIP(byte[] data) throws IOException {
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        GZIPOutputStream gzip2 = new GZIPOutputStream(os2);
        try {
            gzip2.write(data);
            gzip2.finish();
            byte[] byArray = os2.toByteArray();
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)gzip2, "gzip");
            IOHelper.close((Closeable)os2, "byte array output stream");
        }
    }

    public static boolean isGzip(Message message2) {
        return GZIPHelper.isGzip(message2.getHeader("Content-Encoding", String.class), message2.getExchange());
    }

    public static boolean isGzip(String header2, Exchange exchange) {
        if (exchange == null || !exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class).booleanValue()) {
            return GZIPHelper.isGzip(header2);
        }
        return false;
    }

    public static boolean isGzip(String header2) {
        return StringHelper.containsIgnoreCase(header2, "gzip");
    }
}

