/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExceptionHandler;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private final CamelLogger logger;
    private final CamelContext camelContext;

    public LoggingExceptionHandler(CamelContext camelContext, Class<?> ownerType) {
        this(camelContext, new CamelLogger(LoggerFactory.getLogger(ownerType), LoggingLevel.WARN));
    }

    public LoggingExceptionHandler(CamelContext camelContext, Class<?> ownerType, LoggingLevel level) {
        this(camelContext, new CamelLogger(LoggerFactory.getLogger(ownerType), level));
    }

    public LoggingExceptionHandler(CamelContext camelContext, CamelLogger logger2) {
        this.camelContext = camelContext;
        this.logger = logger2;
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    @Override
    public void handleException(String message2, Throwable exception) {
        this.handleException(message2, null, exception);
    }

    @Override
    public void handleException(String message2, Exchange exchange, Throwable exception) {
        try {
            if (!this.isSuppressLogging()) {
                String msg2 = CamelExchangeException.createExceptionMessage(message2, exchange, exception);
                if (this.isCausedByRollbackExchangeException(exception)) {
                    this.logger.log(msg2);
                } else if (exception != null) {
                    this.logger.log(msg2, exception);
                } else {
                    this.logger.log(msg2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isCausedByRollbackExchangeException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof RollbackExchangeException) {
            return true;
        }
        if (exception.getCause() != null) {
            return this.isCausedByRollbackExchangeException(exception.getCause());
        }
        return false;
    }

    protected boolean isSuppressLogging() {
        if (this.camelContext != null) {
            return (this.camelContext.getStatus().isStopping() || this.camelContext.getStatus().isStopped()) && this.camelContext.getShutdownStrategy().hasTimeoutOccurred() && this.camelContext.getShutdownStrategy().isSuppressLoggingOnTimeout();
        }
        return false;
    }
}

