/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.Route;
import org.apache.camel.StreamCache;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public final class MessageHelper {
    private static final String MESSAGE_HISTORY_HEADER = "%-40s %-30s %-50s %-12s";
    private static final String MESSAGE_HISTORY_OUTPUT = "%-40.40s %-30.30s %-50.50s %12.12s";

    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message2) {
        Object answer;
        if (message2 == null) {
            return null;
        }
        Object body2 = message2.getBody();
        if (body2 instanceof String) {
            return (String)body2;
        }
        StreamCache newBody = message2.getExchange().getContext().getTypeConverter().tryConvertTo(StreamCache.class, message2.getExchange(), body2);
        if (newBody != null) {
            message2.setBody(newBody);
        }
        if ((answer = message2.getBody(String.class)) == null) {
            answer = message2.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message2) {
        if (message2 == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message2.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message2) {
        if (message2 == null) {
            return;
        }
        Object body2 = null;
        try {
            body2 = message2.getBody();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (body2 instanceof StreamCache) {
            ((StreamCache)body2).reset();
        }
    }

    public static String getContentType(Message message2) {
        return message2.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message2) {
        return message2.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message2) {
        return MessageHelper.extractBodyForLogging(message2, "Message: ");
    }

    public static String extractValueForLogging(Object value, Message message2) {
        String property;
        String globalOption;
        boolean streams = false;
        if (message2.getExchange() != null && (globalOption = message2.getExchange().getContext().getGlobalOption("CamelLogDebugStreams")) != null) {
            streams = message2.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, message2.getExchange(), globalOption);
        }
        int maxChars = 1000;
        if (message2.getExchange() != null && (property = message2.getExchange().getContext().getGlobalOption("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = message2.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        return MessageHelper.extractValueForLogging(value, message2, streams, false, maxChars);
    }

    public static String extractBodyForLogging(Message message2, String prepend) {
        String globalOption;
        boolean streams = false;
        if (message2.getExchange() != null && (globalOption = message2.getExchange().getContext().getGlobalOption("CamelLogDebugStreams")) != null) {
            streams = message2.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, message2.getExchange(), globalOption);
        }
        return MessageHelper.extractBodyForLogging(message2, prepend, streams, false);
    }

    public static String extractBodyForLogging(Message message2, String prepend, boolean allowStreams, boolean allowFiles) {
        String globalOption;
        int maxChars = 1000;
        if (message2.getExchange() != null && (globalOption = message2.getExchange().getContext().getGlobalOption("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = message2.getExchange().getContext().getTypeConverter().convertTo(Integer.class, globalOption);
        }
        return MessageHelper.extractBodyForLogging(message2, prepend, allowStreams, allowFiles, maxChars);
    }

    public static String extractBodyForLogging(Message message2, String prepend, boolean allowStreams, boolean allowFiles, int maxChars) {
        String value = MessageHelper.extractValueForLogging(message2.getBody(), message2, allowStreams, allowFiles, maxChars);
        if (prepend != null) {
            return prepend + value;
        }
        return value;
    }

    public static String extractBodyForLogging(Message message2, String prepend, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        String value = MessageHelper.extractValueForLogging(message2.getBody(), message2, allowCachedStreams, allowStreams, allowFiles, maxChars);
        if (prepend != null) {
            return prepend + value;
        }
        return value;
    }

    public static String extractValueForLogging(Object obj, Message message2, boolean allowStreams, boolean allowFiles, int maxChars) {
        return MessageHelper.extractValueForLogging(obj, message2, allowStreams, allowStreams, allowFiles, maxChars);
    }

    public static String extractValueForLogging(Object obj, Message message2, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        if (maxChars < 0) {
            return "[Body is not logged]";
        }
        if (obj == null) {
            return "[Body is null]";
        }
        if (!allowFiles && (obj instanceof WrappedFile || obj instanceof File)) {
            return "[Body is file based: " + obj + "]";
        }
        if (!allowStreams) {
            boolean allow;
            boolean bl = allow = allowCachedStreams && obj instanceof StreamCache;
            if (!allow) {
                if (obj instanceof StreamCache) {
                    return "[Body is instance of org.apache.camel.StreamCache]";
                }
                if (obj instanceof InputStream) {
                    return "[Body is instance of java.io.InputStream]";
                }
                if (obj instanceof OutputStream) {
                    return "[Body is instance of java.io.OutputStream]";
                }
                if (obj instanceof Reader) {
                    return "[Body is instance of java.io.Reader]";
                }
                if (obj instanceof Writer) {
                    return "[Body is instance of java.io.Writer]";
                }
                if (obj.getClass().getName().equals("javax.xml.transform.stax.StAXSource")) {
                    return "[Body is instance of javax.xml.transform.Source]";
                }
            }
        }
        StreamCache cache = null;
        InputStream is = null;
        if (obj instanceof StreamCache) {
            cache = (StreamCache)obj;
            is = null;
        } else if (obj instanceof InputStream) {
            cache = null;
            is = (InputStream)obj;
        }
        Object body2 = null;
        if (message2.getExchange() != null) {
            try {
                body2 = message2.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message2.getExchange(), obj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (body2 == null) {
            try {
                body2 = obj.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (cache != null) {
            cache.reset();
        } else if (is != null && is.markSupported()) {
            try {
                is.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (body2 == null) {
            return "[Body is null]";
        }
        if (maxChars > 0 && ((String)body2).length() > maxChars) {
            body2 = ((String)body2).substring(0, maxChars) + "... [Body clipped after " + maxChars + " chars, total length is " + ((String)body2).length() + "]";
        }
        return body2;
    }

    public static String dumpAsXml(Message message2) {
        return MessageHelper.dumpAsXml(message2, true);
    }

    public static String dumpAsXml(Message message2, boolean includeBody) {
        return MessageHelper.dumpAsXml(message2, includeBody, 0);
    }

    public static String dumpAsXml(Message message2, boolean includeBody, int indent) {
        return MessageHelper.dumpAsXml(message2, includeBody, indent, false, true, 131072);
    }

    public static String dumpAsXml(Message message2, boolean includeBody, int indent, boolean allowStreams, boolean allowFiles, int maxChars) {
        StringBuilder sb = new StringBuilder();
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            prefix.append(" ");
        }
        sb.append((CharSequence)prefix);
        sb.append("<message exchangeId=\"").append(message2.getExchange().getExchangeId()).append("\">\n");
        if (message2.hasHeaders()) {
            sb.append((CharSequence)prefix);
            sb.append("  <headers>\n");
            TreeMap<String, Object> headers2 = new TreeMap<String, Object>(message2.getHeaders());
            for (Map.Entry entry : headers2.entrySet()) {
                Object value = entry.getValue();
                String type = ObjectHelper.classCanonicalName(value);
                sb.append((CharSequence)prefix);
                sb.append("    <header key=\"").append((String)entry.getKey()).append("\"");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                if (value != null) {
                    try {
                        String xml = message2.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message2.getExchange(), value);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode(xml));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append((CharSequence)prefix);
            sb.append("  </headers>\n");
        }
        if (includeBody) {
            sb.append((CharSequence)prefix);
            sb.append("  <body");
            String type = ObjectHelper.classCanonicalName(message2.getBody());
            if (type != null) {
                sb.append(" type=\"").append(type).append("\"");
            }
            sb.append(">");
            String xml = MessageHelper.extractBodyForLogging(message2, null, allowStreams, allowFiles, maxChars);
            if (xml != null) {
                sb.append(StringHelper.xmlEncode(xml));
            }
            sb.append("</body>\n");
        }
        sb.append((CharSequence)prefix);
        sb.append("</message>");
        return sb.toString();
    }

    public static void copyBody(Message source, Message target) {
        DataTypeAware dataTypeAwareSource;
        if (source instanceof DataTypeAware && target instanceof DataTypeAware && (dataTypeAwareSource = (DataTypeAware)((Object)source)).hasDataType()) {
            DataTypeAware dataTypeAwareTarget = (DataTypeAware)((Object)target);
            dataTypeAwareTarget.setBody(source.getBody(), dataTypeAwareSource.getDataType());
            return;
        }
        target.setBody(source.getBody());
    }

    public static void copyHeaders(Message source, Message target, boolean override) {
        MessageHelper.copyHeaders(source, target, null, override);
    }

    public static void copyHeaders(Message source, Message target, HeaderFilterStrategy strategy, boolean override) {
        if (!source.hasHeaders()) {
            return;
        }
        for (Map.Entry<String, Object> entry : source.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (target.getHeader(key) != null && !override) continue;
            if (strategy == null) {
                target.setHeader(key, value);
                continue;
            }
            if (strategy.applyFilterToExternalHeaders(key, value, target.getExchange())) continue;
            target.setHeader(key, value);
        }
    }

    public static String dumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        try {
            return MessageHelper.doDumpMessageHistoryStacktrace(exchange, exchangeFormatter, logStackTrace);
        }
        catch (Throwable e) {
            return "";
        }
    }

    private static String doDumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        String loc;
        String routeId = exchange.getFromRouteId();
        Route route = exchange.getContext().getRoute(routeId);
        String string2 = loc = route != null ? route.getSourceLocationShort() : null;
        if (loc == null) {
            loc = "";
        }
        String id = routeId;
        Object label = "";
        if (exchange.getFromEndpoint() != null) {
            label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(exchange.getFromEndpoint().getEndpointUri(), 100)) + "]";
        }
        long elapsed = new StopWatch(exchange.getCreated()).taken();
        List list = exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
        boolean enabled = list != null;
        boolean source = !loc.isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Message History");
        if (!source && !enabled) {
            sb.append(" (source location and message history is disabled)");
        } else if (!source) {
            sb.append(" (source location is disabled)");
        } else if (!enabled) {
            sb.append(" (complete message history is disabled)");
        }
        sb.append("\n");
        sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
        String goMessageHistoryHeader = exchange.getContext().getGlobalOption("CamelMessageHistoryHeaderFormat");
        sb.append(String.format(goMessageHistoryHeader == null ? MESSAGE_HISTORY_HEADER : goMessageHistoryHeader, "Source", "ID", "Processor", "Elapsed (ms)"));
        sb.append("\n");
        String goMessageHistoryOutput = exchange.getContext().getGlobalOption("CamelMessageHistoryOutputFormat");
        goMessageHistoryOutput = goMessageHistoryOutput == null ? MESSAGE_HISTORY_OUTPUT : goMessageHistoryOutput;
        sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, elapsed));
        sb.append("\n");
        if (list == null || list.isEmpty()) {
            id = exchange.adapt(ExtendedExchange.class).getHistoryNodeId();
            if (id != null) {
                String rid;
                loc = exchange.adapt(ExtendedExchange.class).getHistoryNodeSource();
                if (loc == null) {
                    loc = "";
                }
                if ((rid = ExchangeHelper.getAtRouteId(exchange)) != null) {
                    routeId = rid;
                }
                label = exchange.adapt(ExtendedExchange.class).getHistoryNodeLabel();
                label = URISupport.sanitizeUri(StringHelper.limitLength((String)label, 100));
                elapsed = 0L;
                sb.append("\t...\n");
                sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, elapsed));
                sb.append("\n");
            }
        } else {
            for (MessageHistory history : list) {
                loc = LoggerHelper.getLineNumberLoggerName(history.getNode());
                if (loc == null) {
                    loc = "";
                }
                routeId = history.getRouteId() != null ? history.getRouteId() : "";
                id = history.getNode().getId();
                label = URISupport.sanitizeUri(StringHelper.limitLength(history.getNode().getLabel(), 100));
                elapsed = history.getElapsed();
                sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, elapsed));
                sb.append("\n");
            }
        }
        if (exchangeFormatter != null) {
            sb.append("\nExchange\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append(exchangeFormatter.format(exchange));
            sb.append("\n");
        }
        if (logStackTrace) {
            sb.append("\nStacktrace\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------");
        }
        return sb.toString();
    }
}

