/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;

public class ScheduledPollConsumerHealthCheck
implements HealthCheck {
    private final HealthCheckRegistry registry;
    private HealthCheck.State initialState;
    private final ScheduledPollConsumer consumer;
    private final String id;
    private final String sanitizedBaseUri;
    private final String sanitizedUri;
    private boolean enabled = true;

    public ScheduledPollConsumerHealthCheck(ScheduledPollConsumer consumer, String id) {
        this.registry = HealthCheckRegistry.get(consumer.getEndpoint().getCamelContext());
        this.initialState = this.registry != null ? this.registry.getInitialState() : HealthCheck.State.DOWN;
        this.consumer = consumer;
        this.id = id;
        this.sanitizedBaseUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointBaseUri());
        this.sanitizedUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointUri());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public HealthCheck.Result call(Map<String, Object> options) {
        HealthCheckResultBuilder builder2 = HealthCheckResultBuilder.on(this);
        builder2.state(this.registry.getInitialState());
        builder2.detail("endpoint.uri", this.sanitizedUri);
        builder2.detail("failure.endpoint.uri", this.sanitizedUri);
        HealthCheck.Kind kind = this.isLiveness() && this.isReadiness() ? (HealthCheck.Kind)((Object)options.getOrDefault("check.kind", (Object)HealthCheck.Kind.ALL)) : (this.isLiveness() ? HealthCheck.Kind.LIVENESS : HealthCheck.Kind.READINESS);
        builder2.detail("check.kind", (Object)kind);
        if (!this.isEnabled()) {
            builder2.message("Disabled");
            builder2.detail("check.enabled", false);
            return builder2.unknown().build();
        }
        long ec = this.consumer.getErrorCounter();
        boolean first = this.consumer.isFirstPollDone();
        Throwable cause = this.consumer.getLastError();
        boolean healthy = ec == 0L;
        boolean readiness = kind.equals((Object)HealthCheck.Kind.READINESS);
        if (readiness && !first) {
            boolean down = builder2.state().equals((Object)HealthCheck.State.DOWN);
            if (!down) {
                return builder2.build();
            }
            healthy = false;
        }
        if (healthy) {
            builder2.up();
        } else {
            builder2.down();
            builder2.detail("failure.error.count", ec);
            String rid = this.consumer.getRouteId();
            if (ec > 0L) {
                String msg2 = "Consumer failed polling %s times route: %s (%s)";
                builder2.message(String.format(msg2, ec, rid, this.sanitizedBaseUri));
            } else {
                String msg3 = "Consumer has not yet polled route: %s (%s)";
                builder2.message(String.format(msg3, rid, this.sanitizedBaseUri));
            }
            builder2.error(cause);
            if (this.consumer.getLastErrorDetails() != null) {
                builder2.details(this.consumer.getLastErrorDetails());
            }
        }
        return builder2.build();
    }

    public HealthCheck.State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(HealthCheck.State initialState) {
        this.initialState = initialState;
    }

    @Override
    public String getGroup() {
        return "camel";
    }

    @Override
    public String getId() {
        return this.id;
    }
}

