/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.camel.support.jsse.BaseSSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextClientParameters
extends BaseSSLContextParameters {
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextClientParameters.class);
    private List<SNIServerName> sniHostNames = new ArrayList<SNIServerName>();

    public void addAllSniHostNames(List<String> sniHostNames) {
        for (String sniHostName : sniHostNames) {
            this.sniHostNames.add(new SNIHostName(sniHostName));
        }
    }

    public void setSniHostName(String sniHostName) {
        this.sniHostNames.add(new SNIHostName(sniHostName));
    }

    @Override
    protected List<SNIServerName> getSNIHostNames() {
        return this.sniHostNames;
    }

    @Override
    protected boolean getAllowPassthrough() {
        return true;
    }

    @Override
    protected void configureSSLContext(SSLContext context2) throws GeneralSecurityException {
        LOG.trace("Configuring client-side SSLContext parameters on SSLContext [{}]...", (Object)context2);
        if (this.getSessionTimeout() != null) {
            LOG.info("Configuring client-side SSLContext session timeout on SSLContext [{}] to [{}].", (Object)context2, (Object)this.getSessionTimeout());
            this.configureSessionContext(context2.getClientSessionContext(), this.getSessionTimeout());
        }
        LOG.trace("Configured client-side SSLContext parameters on SSLContext [{}].", (Object)context2);
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context2) {
        return Collections.emptyList();
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> getSSLServerSocketFactoryConfigurers(SSLContext context2) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("SSLContextClientParameters[getCipherSuites()=");
        builder2.append(this.getCipherSuites());
        builder2.append(", getCipherSuitesFilter()=");
        builder2.append(this.getCipherSuitesFilter());
        builder2.append(", getSecureSocketProtocols()=");
        builder2.append(this.getSecureSocketProtocols());
        builder2.append(", getSecureSocketProtocolsFilter()=");
        builder2.append(this.getSecureSocketProtocolsFilter());
        builder2.append(", getSessionTimeout()=");
        builder2.append(this.getSessionTimeout());
        builder2.append("]");
        return builder2.toString();
    }
}

