/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.jsse.BaseSSLContextParameters;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextServerParameters
extends BaseSSLContextParameters {
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextServerParameters.class);
    protected String clientAuthentication;

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String value) {
        this.clientAuthentication = value;
    }

    @Override
    protected boolean getAllowPassthrough() {
        return true;
    }

    @Override
    protected void configureSSLContext(SSLContext context2) throws GeneralSecurityException {
        LOG.trace("Configuring server-side SSLContext parameters on SSLContext [{}]...", (Object)context2);
        if (this.getSessionTimeout() != null) {
            LOG.debug("Configuring server-side SSLContext session timeout on SSLContext [{}] to [{}].", (Object)context2, (Object)this.getSessionTimeout());
            this.configureSessionContext(context2.getServerSessionContext(), this.getSessionTimeout());
        }
        LOG.trace("Configured server-side SSLContext parameters on SSLContext [{}].", (Object)context2);
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context2) {
        LinkedList<BaseSSLContextParameters.Configurer<SSLEngine>> sslEngineConfigurers = new LinkedList<BaseSSLContextParameters.Configurer<SSLEngine>>();
        if (this.getClientAuthentication() != null) {
            final ClientAuthentication clientAuthValue = ClientAuthentication.valueOf(this.parsePropertyValue(this.getClientAuthentication()));
            BaseSSLContextParameters.Configurer<SSLEngine> sslEngineConfigurer = new BaseSSLContextParameters.Configurer<SSLEngine>(){

                @Override
                public SSLEngine configure(SSLEngine engine) {
                    LOG.trace("Configuring client-auth on SSLEngine [{}] to [{}].", (Object)engine, (Object)clientAuthValue);
                    switch (clientAuthValue) {
                        case NONE: {
                            engine.setWantClientAuth(false);
                            engine.setNeedClientAuth(false);
                            break;
                        }
                        case WANT: {
                            engine.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRE: {
                            engine.setNeedClientAuth(true);
                            break;
                        }
                        default: {
                            throw new RuntimeCamelException("Unknown ClientAuthentication value: " + clientAuthValue);
                        }
                    }
                    return engine;
                }
            };
            sslEngineConfigurers.add(sslEngineConfigurer);
        }
        return sslEngineConfigurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocket>> getSSLServerSocketFactorySSLServerSocketConfigurers(SSLContext context2) {
        List<BaseSSLContextParameters.Configurer<SSLServerSocket>> sslServerSocketConfigurers = super.getSSLServerSocketFactorySSLServerSocketConfigurers(context2);
        if (this.getClientAuthentication() != null) {
            final ClientAuthentication clientAuthValue = ClientAuthentication.valueOf(this.parsePropertyValue(this.getClientAuthentication()));
            BaseSSLContextParameters.Configurer<SSLServerSocket> sslServerSocketConfigurer = new BaseSSLContextParameters.Configurer<SSLServerSocket>(){

                @Override
                public SSLServerSocket configure(SSLServerSocket socket2) {
                    LOG.trace("Configuring client-auth on SSLServerSocket [{}] to [{}].", (Object)socket2, (Object)clientAuthValue);
                    switch (clientAuthValue) {
                        case NONE: {
                            socket2.setWantClientAuth(false);
                            socket2.setNeedClientAuth(false);
                            break;
                        }
                        case WANT: {
                            socket2.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRE: {
                            socket2.setNeedClientAuth(true);
                            break;
                        }
                        default: {
                            throw new RuntimeCamelException("Unknown ClientAuthentication value: " + clientAuthValue);
                        }
                    }
                    return socket2;
                }
            };
            sslServerSocketConfigurers.add(sslServerSocketConfigurer);
        }
        return sslServerSocketConfigurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> getSSLSocketFactoryConfigurers(SSLContext context2) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("SSLContextServerParameters[clientAuthentication=");
        builder2.append(this.clientAuthentication);
        builder2.append(", getCipherSuites()=");
        builder2.append(this.getCipherSuites());
        builder2.append(", getCipherSuitesFilter()=");
        builder2.append(this.getCipherSuitesFilter());
        builder2.append(", getSecureSocketProtocols()=");
        builder2.append(this.getSecureSocketProtocols());
        builder2.append(", getSecureSocketProtocolsFilter()=");
        builder2.append(this.getSecureSocketProtocolsFilter());
        builder2.append(", getSessionTimeout()=");
        builder2.append(this.getSessionTimeout());
        builder2.append("]");
        return builder2.toString();
    }
}

