/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.support.jsse.JsseParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagersParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(TrustManagersParameters.class);
    protected KeyStoreParameters keyStore;
    protected String provider;
    protected String algorithm;
    protected TrustManager trustManager;

    public TrustManager[] createTrustManagers() throws GeneralSecurityException, IOException {
        if (this.trustManager != null) {
            return new TrustManager[]{this.trustManager};
        }
        LOG.trace("Creating TrustManager[] from TrustManagersParameters [{}]", (Object)this);
        TrustManager[] trustManagers = null;
        if (this.getKeyStore() != null) {
            String tmfAlgorithm = this.parsePropertyValue(this.getAlgorithm());
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            TrustManagerFactory tmf = this.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, this.parsePropertyValue(this.getProvider()));
            LOG.debug("TrustManagerFactory [{}] is using provider [{}] and algorithm [{}].", new Object[]{tmf, tmf.getProvider(), tmf.getAlgorithm()});
            KeyStore ks = this.getKeyStore() == null ? null : this.getKeyStore().createKeyStore();
            tmf.init(ks);
            trustManagers = tmf.getTrustManagers();
            LOG.debug("TrustManager[] [{}], initialized from TrustManagerFactory [{}].", (Object)trustManagers, (Object)tmf);
        }
        return trustManagers;
    }

    public KeyStoreParameters getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStoreParameters value) {
        this.keyStore = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        if (this.trustManager != null) {
            builder2.append("TrustManagerType[trustManager=");
            builder2.append(this.trustManager);
            builder2.append("]");
        } else {
            builder2.append("TrustManagerType[keyStore=");
            builder2.append(this.keyStore);
            builder2.append(", provider=");
            builder2.append(this.provider);
            builder2.append(", algorithm=");
            builder2.append(this.algorithm);
            builder2.append("]");
        }
        return builder2.toString();
    }
}

