/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.camel.util.IOHelper;

public class FilterIterator<T>
implements Iterator<T>,
Closeable {
    private Iterator<T> it;
    private Predicate<T> filter;
    private T next;
    private boolean closed;

    public FilterIterator(Iterator<T> it) {
        this(it, null);
    }

    public FilterIterator(Iterator<T> it, Predicate<T> filter2) {
        this.it = it;
        this.filter = filter2;
    }

    @Override
    public void close() throws IOException {
        try {
            IOHelper.closeIterator(this.it);
        }
        finally {
            this.closed = true;
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.checkNext();
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            this.next = this.checkNext();
        }
        if (this.next != null) {
            T ep = this.next;
            this.next = null;
            return ep;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    protected T checkNext() {
        while (!this.closed && this.it.hasNext()) {
            T ep = this.it.next();
            if (ep == null || this.filter != null && !this.filter.test(ep)) continue;
            return ep;
        }
        return null;
    }
}

