/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Scanner;
import java.util.function.Supplier;
import org.apache.camel.util.BufferCaster;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    public static Supplier<Charset> defaultCharset = Charset::defaultCharset;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final long INITIAL_OFFSET = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(IOHelper.class);
    private static final boolean ZERO_BYTE_EOL_ENABLED = "true".equalsIgnoreCase(System.getProperty("camel.zeroByteEOLEnabled", "true"));

    private IOHelper() {
    }

    public static BufferedInputStream buffered(InputStream in) {
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream buffered(OutputStream out) {
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedReader buffered(Reader reader2) {
        return reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2);
    }

    public static BufferedWriter buffered(Writer writer2) {
        return writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter(writer2);
    }

    public static String toString(Reader reader2) throws IOException {
        return IOHelper.toString(reader2, 0L);
    }

    public static String toString(Reader reader2, long offset) throws IOException {
        return IOHelper.toString(IOHelper.buffered(reader2), offset);
    }

    public static String toString(BufferedReader reader2) throws IOException {
        return IOHelper.toString(reader2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(BufferedReader reader2, long offset) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        reader2.skip(offset);
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader2.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close((Closeable)reader2, "reader", LOG);
        }
        return sb.toString();
    }

    public static int copy(InputStream input, OutputStream output2) throws IOException {
        return IOHelper.copy(input, output2, 4096);
    }

    public static int copy(InputStream input, OutputStream output2, int bufferSize) throws IOException {
        return IOHelper.copy(input, output2, bufferSize, false);
    }

    public static int copy(InputStream input, OutputStream output2, int bufferSize, boolean flushOnEachWrite) throws IOException {
        return IOHelper.copy(input, output2, bufferSize, flushOnEachWrite, -1L);
    }

    public static int copy(InputStream input, OutputStream output2, int bufferSize, boolean flushOnEachWrite, long maxSize) throws IOException {
        boolean hasData;
        if (input instanceof ByteArrayInputStream) {
            input.mark(0);
            input.reset();
            bufferSize = input.available();
        } else {
            int avail = input.available();
            if (avail > bufferSize) {
                bufferSize = avail;
            }
        }
        if (bufferSize > 262144) {
            bufferSize = 262144;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copying InputStream: {} -> OutputStream: {} with buffer: {} and flush on each write {}", new Object[]{input, output2, bufferSize, flushOnEachWrite});
        }
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        if (ZERO_BYTE_EOL_ENABLED) {
            hasData = n > 0;
        } else {
            boolean bl = hasData = n > -1;
        }
        if (hasData) {
            while (-1 != n) {
                output2.write(buffer, 0, n);
                if (flushOnEachWrite) {
                    output2.flush();
                }
                if (maxSize > 0L && (long)(total += n) > maxSize) {
                    throw new IOException("The InputStream entry being copied exceeds the maximum allowed size");
                }
                n = input.read(buffer);
            }
        }
        if (!flushOnEachWrite) {
            output2.flush();
        }
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output2) throws IOException {
        IOHelper.copyAndCloseInput(input, output2, 4096);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output2, int bufferSize) throws IOException {
        IOHelper.copy(input, output2, bufferSize);
        IOHelper.close((Closeable)input, null, LOG);
    }

    public static int copy(Reader input, Writer output2, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output2.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output2.flush();
        return total;
    }

    public static void transfer(ReadableByteChannel input, WritableByteChannel output2) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        while (input.read(buffer) >= 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                output2.write(buffer);
            }
            buffer.clear();
        }
    }

    public static void force(FileChannel channel, String name, Logger log2) {
        try {
            if (channel != null) {
                channel.force(true);
            }
        }
        catch (Exception e) {
            if (log2 == null) {
                log2 = LOG;
            }
            if (name != null) {
                log2.warn("Cannot force FileChannel: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
            }
            log2.warn("Cannot force FileChannel. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void force(FileOutputStream os2, String name, Logger log2) {
        try {
            if (os2 != null) {
                os2.getFD().sync();
            }
        }
        catch (Exception e) {
            if (log2 == null) {
                log2 = LOG;
            }
            if (name != null) {
                log2.warn("Cannot sync FileDescriptor: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
            }
            log2.warn("Cannot sync FileDescriptor. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void close(Writer writer2, FileOutputStream os2, String name, Logger log2, boolean force) {
        if (writer2 != null && force) {
            try {
                writer2.flush();
            }
            catch (Exception e) {
                if (log2 == null) {
                    log2 = LOG;
                }
                if (name != null) {
                    log2.warn("Cannot flush Writer: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
                }
                log2.warn("Cannot flush Writer. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
            IOHelper.force(os2, name, log2);
        }
        IOHelper.close((Closeable)writer2, name, log2);
    }

    public static void close(Closeable closeable, String name, Logger log2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (log2 == null) {
                    log2 = LOG;
                }
                if (name != null) {
                    log2.warn("Cannot close: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
                }
                log2.warn("Cannot close. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void closeWithException(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(FileChannel channel, String name, Logger log2, boolean force) {
        if (force) {
            IOHelper.force(channel, name, log2);
        }
        IOHelper.close((Closeable)channel, name, log2);
    }

    public static void close(Closeable closeable, String name) {
        IOHelper.close(closeable, name, LOG);
    }

    public static void close(Closeable closeable) {
        IOHelper.close(closeable, null, LOG);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOHelper.close(closeable);
        }
    }

    public static void closeIterator(Object it) throws IOException {
        IOException ioException;
        if (it instanceof Closeable) {
            IOHelper.closeWithException((Closeable)it);
        }
        if (it instanceof Scanner && (ioException = ((Scanner)it).ioException()) != null) {
            throw ioException;
        }
    }

    public static void validateCharset(String charset2) throws UnsupportedCharsetException {
        if (charset2 != null && Charset.isSupported(charset2)) {
            Charset.forName(charset2);
            return;
        }
        throw new UnsupportedCharsetException(charset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        String string2;
        StringBuilder builder2 = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader2 = IOHelper.buffered(isr);
            while ((line = reader2.readLine()) != null) {
                builder2.append(line);
                builder2.append("\n");
            }
            string2 = builder2.toString();
        }
        catch (Throwable throwable) {
            IOHelper.close(isr, in);
            throw throwable;
        }
        IOHelper.close(isr, in);
        return string2;
    }

    public static void writeText(String text2, File file) throws IOException {
        String path;
        if (!file.exists() && (path = FileUtil.onlyPath(file.getPath())) != null) {
            new File(path).mkdirs();
        }
        IOHelper.writeText(text2, new FileOutputStream(file, false));
    }

    public static void writeText(String text2, OutputStream os2) throws IOException {
        try {
            os2.write(text2.getBytes());
        }
        finally {
            IOHelper.close((Closeable)os2);
        }
    }

    public static String getCharsetNameFromContentType(String contentType) {
        String[] values;
        int pos = contentType.indexOf("charset=");
        if (pos != -1) {
            if (contentType.regionMatches(true, pos + 8, "utf-8", 0, 5)) {
                return "UTF-8";
            }
            int end = contentType.indexOf(59, pos);
            String charset2 = end > pos ? contentType.substring(pos + 8, end) : contentType.substring(pos + 8);
            return IOHelper.normalizeCharset(charset2);
        }
        for (String value : values = contentType.split(";")) {
            String prefix;
            if (!(value = value.trim()).regionMatches(true, 0, prefix = "charset=", 0, prefix.length())) continue;
            String charset3 = value.substring(8);
            return IOHelper.normalizeCharset(charset3);
        }
        return "UTF-8";
    }

    public static String normalizeCharset(String charset2) {
        if (charset2 != null) {
            boolean trim = false;
            String answer = charset2.trim();
            if (answer.startsWith("'") || answer.startsWith("\"")) {
                answer = answer.substring(1);
                trim = true;
            }
            if (answer.endsWith("'") || answer.endsWith("\"")) {
                answer = answer.substring(0, answer.length() - 1);
                trim = true;
            }
            return trim ? answer.trim() : answer;
        }
        return null;
    }

    public static String lookupEnvironmentVariable(String key) {
        String upperKey = key.toUpperCase();
        String value = System.getenv(upperKey);
        if (value == null) {
            String normalizedKey = upperKey.replace('-', '_');
            normalizedKey = normalizedKey.replace('.', '_');
            value = System.getenv(normalizedKey);
        }
        return value;
    }

    public static InputStream toInputStream(File file, String charset2) throws IOException {
        if (charset2 != null) {
            return new EncodingInputStream(file, charset2);
        }
        return IOHelper.buffered(new FileInputStream(file));
    }

    public static BufferedReader toReader(File file, String charset2) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return IOHelper.buffered(new EncodingFileReader(in, charset2));
    }

    public static BufferedReader toReader(File file, Charset charset2) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return IOHelper.buffered(new EncodingFileReader(in, charset2));
    }

    public static BufferedWriter toWriter(FileOutputStream os2, String charset2) throws IOException {
        return IOHelper.buffered(new EncodingFileWriter(os2, charset2));
    }

    public static BufferedWriter toWriter(FileOutputStream os2, Charset charset2) {
        return IOHelper.buffered(new EncodingFileWriter(os2, charset2));
    }

    public static class EncodingFileWriter
    extends OutputStreamWriter {
        private final FileOutputStream out;

        public EncodingFileWriter(FileOutputStream out, String charset2) throws UnsupportedEncodingException {
            super((OutputStream)out, charset2);
            this.out = out;
        }

        public EncodingFileWriter(FileOutputStream out, Charset charset2) {
            super((OutputStream)out, charset2);
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.out.close();
            }
        }
    }

    public static class EncodingFileReader
    extends InputStreamReader {
        private final FileInputStream in;

        public EncodingFileReader(FileInputStream in, String charset2) throws UnsupportedEncodingException {
            super((InputStream)in, charset2);
            this.in = in;
        }

        public EncodingFileReader(FileInputStream in, Charset charset2) {
            super((InputStream)in, charset2);
            this.in = in;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.in.close();
            }
        }
    }

    public static class EncodingInputStream
    extends InputStream {
        private final File file;
        private final BufferedReader reader;
        private final Charset defaultStreamCharset;
        private ByteBuffer bufferBytes;
        private CharBuffer bufferedChars = CharBuffer.allocate(4096);

        public EncodingInputStream(File file, String charset2) throws IOException {
            this.file = file;
            this.reader = IOHelper.toReader(file, charset2);
            this.defaultStreamCharset = defaultCharset.get();
        }

        @Override
        public int read() throws IOException {
            if (this.bufferBytes == null || this.bufferBytes.remaining() <= 0) {
                BufferCaster.cast(this.bufferedChars).clear();
                int len = this.reader.read(this.bufferedChars);
                this.bufferedChars.flip();
                if (len == -1) {
                    return -1;
                }
                this.bufferBytes = this.defaultStreamCharset.encode(this.bufferedChars);
            }
            return this.bufferBytes.get() & 0xFF;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.reader.reset();
        }

        public InputStream toOriginalInputStream() throws FileNotFoundException {
            return new FileInputStream(this.file);
        }
    }
}

