/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.text.DecimalFormatSymbols;

public final class UnitUtils {
    private UnitUtils() {
    }

    public static String printUnitFromBytes(long bytes) {
        if (bytes < 0L) {
            return "";
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String printUnitFromBytesDot(long bytes) {
        return UnitUtils.printUnitFromBytes(bytes, '.');
    }

    public static String printUnitFromBytes(long bytes, char decimal2) {
        if (bytes < 0L) {
            return "";
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "kMGTPE".charAt(exp - 1);
        String answer = String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        char sep = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        if (decimal2 != sep) {
            answer = answer.replace(sep, decimal2);
        }
        return answer;
    }
}

