/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.python.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.python.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.python.bouncycastle.its.ITSCertificate;
import org.python.bouncycastle.its.ITSCertificateBuilder;
import org.python.bouncycastle.its.ITSPublicEncryptionKey;
import org.python.bouncycastle.its.ITSPublicVerificationKey;
import org.python.bouncycastle.its.operator.ECDSAEncoder;
import org.python.bouncycastle.its.operator.ITSContentSigner;
import org.python.bouncycastle.oer.Element;
import org.python.bouncycastle.oer.OEREncoder;
import org.python.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import org.python.bouncycastle.oer.its.ieee1609dot2.CertificateId;
import org.python.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import org.python.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import org.python.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import org.python.bouncycastle.oer.its.ieee1609dot2.VerificationKeyIndicator;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.HashAlgorithm;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId8;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicVerificationKey;
import org.python.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import org.python.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import org.python.bouncycastle.util.Arrays;

public class ITSExplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final ITSContentSigner signer;

    public ITSExplicitCertificateBuilder(ITSContentSigner iTSContentSigner, ToBeSignedCertificate.Builder builder2) {
        super(builder2);
        this.signer = iTSContentSigner;
    }

    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey) {
        return this.build(certificateId, iTSPublicVerificationKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey, ITSPublicEncryptionKey iTSPublicEncryptionKey) {
        IssuerIdentifier issuerIdentifier;
        VerificationKeyIndicator verificationKeyIndicator;
        ToBeSignedCertificate.Builder builder2 = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        builder2.setId(certificateId);
        if (iTSPublicEncryptionKey != null) {
            builder2.setEncryptionKey(iTSPublicEncryptionKey.toASN1Structure());
        }
        builder2.setVerifyKeyIndicator(VerificationKeyIndicator.verificationKey((PublicVerificationKey)iTSPublicVerificationKey.toASN1Structure()));
        ToBeSignedCertificate toBeSignedCertificate = builder2.createToBeSignedCertificate();
        ToBeSignedCertificate toBeSignedCertificate2 = null;
        if (this.signer.isForSelfSigning()) {
            verificationKeyIndicator = toBeSignedCertificate.getVerifyKeyIndicator();
        } else {
            toBeSignedCertificate2 = this.signer.getAssociatedCertificate().toASN1Structure().getToBeSigned();
            verificationKeyIndicator = toBeSignedCertificate2.getVerifyKeyIndicator();
        }
        OutputStream outputStream = this.signer.getOutputStream();
        try {
            outputStream.write(OEREncoder.toByteArray((ASN1Encodable)toBeSignedCertificate, (Element)IEEE1609dot2.ToBeSignedCertificate.build()));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
        Signature signature = null;
        switch (verificationKeyIndicator.getChoice()) {
            case 0: {
                signature = ECDSAEncoder.toITS(SECObjectIdentifiers.secp256r1, this.signer.getSignature());
                break;
            }
            case 1: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP256r1, this.signer.getSignature());
                break;
            }
            case 2: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP384r1, this.signer.getSignature());
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        CertificateBase.Builder builder3 = new CertificateBase.Builder();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signer.getDigestAlgorithm().getAlgorithm();
        if (this.signer.isForSelfSigning()) {
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifier = IssuerIdentifier.self((HashAlgorithm)HashAlgorithm.sha256);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifier = IssuerIdentifier.self((HashAlgorithm)HashAlgorithm.sha384);
            }
        } else {
            byte[] byArray = this.signer.getAssociatedCertificateDigest();
            HashedId8 hashedId8 = new HashedId8(Arrays.copyOfRange(byArray, byArray.length - 8, byArray.length));
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifier = IssuerIdentifier.sha256AndDigest((HashedId8)hashedId8);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifier = IssuerIdentifier.sha384AndDigest((HashedId8)hashedId8);
            }
        }
        builder3.setVersion(this.version);
        builder3.setType(CertificateType.explicit);
        builder3.setIssuer(issuerIdentifier);
        builder3.setToBeSigned(toBeSignedCertificate);
        builder3.setSignature(signature);
        return new ITSCertificate(builder3.createCertificateBase());
    }
}

