/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.its.jcajce;

import java.security.Provider;
import java.security.interfaces.ECPublicKey;
import org.python.bouncycastle.its.ITSCertificate;
import org.python.bouncycastle.its.ITSExplicitCertificateBuilder;
import org.python.bouncycastle.its.jcajce.JcaITSPublicVerificationKey;
import org.python.bouncycastle.its.jcajce.JceITSPublicEncryptionKey;
import org.python.bouncycastle.its.operator.ITSContentSigner;
import org.python.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.python.bouncycastle.jcajce.util.JcaJceHelper;
import org.python.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.python.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.python.bouncycastle.oer.its.ieee1609dot2.CertificateId;
import org.python.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;

public class JcaITSExplicitCertificateBuilder
extends ITSExplicitCertificateBuilder {
    private JcaJceHelper helper;

    public JcaITSExplicitCertificateBuilder(ITSContentSigner iTSContentSigner, ToBeSignedCertificate.Builder builder2) {
        this(iTSContentSigner, builder2, new DefaultJcaJceHelper());
    }

    private JcaITSExplicitCertificateBuilder(ITSContentSigner iTSContentSigner, ToBeSignedCertificate.Builder builder2, JcaJceHelper jcaJceHelper) {
        super(iTSContentSigner, builder2);
        this.helper = jcaJceHelper;
    }

    public JcaITSExplicitCertificateBuilder setProvider(Provider provider2) {
        this.helper = new ProviderJcaJceHelper(provider2);
        return this;
    }

    public JcaITSExplicitCertificateBuilder setProvider(String string2) {
        this.helper = new NamedJcaJceHelper(string2);
        return this;
    }

    public ITSCertificate build(CertificateId certificateId, ECPublicKey eCPublicKey) {
        return this.build(certificateId, eCPublicKey, null);
    }

    public ITSCertificate build(CertificateId certificateId, ECPublicKey eCPublicKey, ECPublicKey eCPublicKey2) {
        JceITSPublicEncryptionKey jceITSPublicEncryptionKey = null;
        if (eCPublicKey2 != null) {
            jceITSPublicEncryptionKey = new JceITSPublicEncryptionKey(eCPublicKey2, this.helper);
        }
        return super.build(certificateId, new JcaITSPublicVerificationKey(eCPublicKey, this.helper), jceITSPublicEncryptionKey);
    }
}

