/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jce.provider;

import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.python.bouncycastle.jcajce.PKIXCertRevocationChecker;
import org.python.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import org.python.bouncycastle.jcajce.PKIXExtendedParameters;
import org.python.bouncycastle.jcajce.util.JcaJceHelper;
import org.python.bouncycastle.jce.provider.AnnotatedException;
import org.python.bouncycastle.jce.provider.RFC3280CertPathUtilities;

class ProvCrlRevocationChecker
implements PKIXCertRevocationChecker {
    private final JcaJceHelper helper;
    private PKIXCertRevocationCheckerParameters params;
    private Date currentDate = null;

    public ProvCrlRevocationChecker(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    @Override
    public void setParameter(String string2, Object object) {
    }

    @Override
    public void initialize(PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters) {
        this.params = pKIXCertRevocationCheckerParameters;
        this.currentDate = new Date();
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.params = null;
        this.currentDate = new Date();
    }

    @Override
    public void check(Certificate certificate) throws CertPathValidatorException {
        try {
            RFC3280CertPathUtilities.checkCRLs((PKIXCertRevocationCheckerParameters)this.params, (PKIXExtendedParameters)this.params.getParamsPKIX(), (Date)this.currentDate, (Date)this.params.getValidDate(), (X509Certificate)((X509Certificate)certificate), (X509Certificate)this.params.getSigningCert(), (PublicKey)this.params.getWorkingPublicKey(), this.params.getCertPath().getCertificates(), (JcaJceHelper)this.helper);
        }
        catch (AnnotatedException annotatedException) {
            Throwable throwable = annotatedException;
            if (null != annotatedException.getCause()) {
                throwable = annotatedException.getCause();
            }
            throw new CertPathValidatorException(annotatedException.getMessage(), throwable, this.params.getCertPath(), this.params.getIndex());
        }
    }
}

