/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString$str___add___exposer;
import org.python.core.PyString$str___eq___exposer;
import org.python.core.PyString$str___getitem___exposer;
import org.python.core.PyString$str___len___exposer;
import org.python.core.PyString$str___repr___exposer;
import org.python.core.PyString$str___rmul___exposer;
import org.python.core.PyString$str___str___exposer;
import org.python.core.PyString$str__formatter_field_name_split_exposer;
import org.python.core.PyString$str__formatter_parser_exposer;
import org.python.core.PyString$str_encode_exposer;
import org.python.core.PyString$str_isdecimal_exposer;
import org.python.core.PyString$str_isdigit_exposer;
import org.python.core.PyString$str_islower_exposer;
import org.python.core.PyString$str_lower_exposer;
import org.python.core.PyString$str_rsplit_exposer;
import org.python.core.PyString$str_swapcase_exposer;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.Untraversable;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.InternalFormat;
import org.python.core.stringlib.MarkupIterator;
import org.python.core.stringlib.TextFormatter;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="str", base=PyBaseString.class, doc="str(object) -> string\n\nReturn a nice string representation of the object.\nIf the argument is a string, the return value is the same object.")
public class PyString
extends PyBaseString
implements BufferProtocol {
    public static final PyType TYPE;
    protected String string;
    protected transient boolean interned = false;
    private Reference<BaseBuffer> export;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;
    private static final int SWAP_CASE = 32;
    private static final String UF_RE = "(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)";
    private static Pattern floatPattern;
    private static Pattern complexPattern;

    public String getString() {
        return this.string;
    }

    public PyString() {
        this("", true);
    }

    protected PyString(PyType subType, String string2, boolean isBytes) {
        super(subType);
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot create PyString from null");
        }
        if (!isBytes && !PyString.isBytes(string2)) {
            throw new IllegalArgumentException("Cannot create PyString with non-byte value");
        }
        this.string = string2;
    }

    public PyString(PyType subType, String string2) {
        this(subType, string2, false);
    }

    public PyString(String string2) {
        this(TYPE, string2);
    }

    public PyString(char c) {
        this(TYPE, String.valueOf(c));
    }

    PyString(StringBuilder buffer) {
        this(TYPE, buffer.toString());
    }

    PyString(PyBuffer buffer) {
        this(TYPE, buffer.toString());
    }

    private PyString(String string2, boolean isBytes) {
        super(TYPE);
        if (!isBytes && !PyString.isBytes(string2)) {
            throw new IllegalArgumentException("Cannot create PyString with non-byte value");
        }
        this.string = string2;
    }

    private static boolean isBytes(String s) {
        int k = s.length();
        if (k == 0) {
            return true;
        }
        int c = 0;
        while (k > 8) {
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
            c = (char)(c | s.charAt(--k));
        }
        while (k > 0) {
            c = (char)(c | s.charAt(--k));
        }
        return c < 256;
    }

    public static PyString fromInterned(String interned) {
        PyString str = new PyString(TYPE, interned);
        str.interned = true;
        return str;
    }

    public boolean isBasicPlane() {
        return true;
    }

    @ExposedNew
    static PyObject str_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("str", args, keywords, new String[]{"object"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String str = S == null ? "" : ((S = S.__str__()) instanceof PyUnicode ? codecs.encode((PyUnicode)S, null, null) : S.toString());
        if (new_.for_type == subtype) {
            return new PyString(str);
        }
        return new PyStringDerived(subtype, str);
    }

    public int[] toCodePoints() {
        int n = this.getString().length();
        int[] codePoints = new int[n];
        for (int i = 0; i < n; ++i) {
            codePoints[i] = this.getString().charAt(i);
        }
        return codePoints;
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            pybuf = new SimpleStringBuffer(flags, (BufferProtocol)this, this.getString());
            this.export = new SoftReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    public String substring(int start, int end) {
        return this.getString().substring(start, end);
    }

    @Override
    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        if (this.getClass() == PyString.class) {
            return this;
        }
        return new PyString(this.getString(), true);
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this);
    }

    @Override
    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.getString().length();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public String internedString() {
        if (this.interned) {
            return this.getString();
        }
        this.string = this.getString().intern();
        this.interned = true;
        return this.getString();
    }

    @Override
    public PyString __repr__() {
        return this.str___repr__();
    }

    final PyString str___repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.getString(), true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        char quote = use_quotes ? (char)'?' : '\u0000';
        return PyString.encode_UnicodeEscape(str, quote);
    }

    static String encode_UnicodeEscape(String str, char quote) {
        boolean use_quotes;
        switch (quote) {
            case '?': {
                use_quotes = true;
                quote = (char)(str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? 34 : 39);
                break;
            }
            case '\"': 
            case '\'': {
                use_quotes = true;
                break;
            }
            default: {
                use_quotes = false;
            }
        }
        int size = str.length();
        StringBuilder v = new StringBuilder(size + (size >> 2) + 2);
        if (use_quotes) {
            v.append(quote);
        }
        int i = 0;
        while (size-- > 0) {
            char ch = str.charAt(i++);
            if (use_quotes && ch == quote || ch == '\\') {
                v.append('\\');
                v.append(ch);
                continue;
            }
            if (size > 0 && ch >= '\ud800' && ch < '\udc00') {
                char ch2 = str.charAt(i++);
                --size;
                if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                    int ucs = ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
                    v.append('\\');
                    v.append('U');
                    v.append(hexdigit[ucs >> 28 & 0xF]);
                    v.append(hexdigit[ucs >> 24 & 0xF]);
                    v.append(hexdigit[ucs >> 20 & 0xF]);
                    v.append(hexdigit[ucs >> 16 & 0xF]);
                    v.append(hexdigit[ucs >> 12 & 0xF]);
                    v.append(hexdigit[ucs >> 8 & 0xF]);
                    v.append(hexdigit[ucs >> 4 & 0xF]);
                    v.append(hexdigit[ucs & 0xF]);
                    continue;
                }
                --i;
                ++size;
            }
            if (ch >= '\u0100') {
                v.append('\\');
                v.append('u');
                v.append(hexdigit[ch >> 12 & 0xF]);
                v.append(hexdigit[ch >> 8 & 0xF]);
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            if (ch == '\t') {
                v.append("\\t");
                continue;
            }
            if (ch == '\n') {
                v.append("\\n");
                continue;
            }
            if (ch == '\r') {
                v.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                v.append('\\');
                v.append('x');
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            v.append(ch);
        }
        if (use_quotes) {
            v.append(quote);
        }
        return v.length() > size ? v.toString() : str;
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors2, boolean unicode) {
        StringBuilder v = new StringBuilder(end - start);
        int s = start;
        while (s < end) {
            char ch = str.charAt(s);
            if (ch != '\\') {
                v.append(ch);
                ++s;
                continue;
            }
            int loopStart = s++;
            if (s == end) {
                s = codecs.insertReplacementAndGetResume(v, errors2, "unicodeescape", str, loopStart, s + 1, "\\ at end of string");
                continue;
            }
            ch = str.charAt(s++);
            switch (ch) {
                case '\n': {
                    break;
                }
                case '\\': {
                    v.append('\\');
                    break;
                }
                case '\'': {
                    v.append('\'');
                    break;
                }
                case '\"': {
                    v.append('\"');
                    break;
                }
                case 'b': {
                    v.append('\b');
                    break;
                }
                case 'f': {
                    v.append('\f');
                    break;
                }
                case 't': {
                    v.append('\t');
                    break;
                }
                case 'n': {
                    v.append('\n');
                    break;
                }
                case 'r': {
                    v.append('\r');
                    break;
                }
                case 'v': {
                    v.append('\u000b');
                    break;
                }
                case 'a': {
                    v.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x = Character.digit(ch, 8);
                    for (int j = 0; j < 2 && s < end && (ch = str.charAt(s)) >= '0' && ch <= '7'; ++j, ++s) {
                        x = (x << 3) + Character.digit(ch, 8);
                    }
                    v.append((char)x);
                    break;
                }
                case 'x': {
                    s = PyString.hexescape(v, errors2, 2, s, str, end, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('u');
                        break;
                    }
                    s = PyString.hexescape(v, errors2, 4, s, str, end, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('U');
                        break;
                    }
                    s = PyString.hexescape(v, errors2, 8, s, str, end, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject mod2 = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod2 = mod2.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (PyString.storeUnicodeCharacter(value, v)) {
                                s = endBrace + 1;
                                break;
                            }
                            s = codecs.insertReplacementAndGetResume(v, errors2, "unicodeescape", str, loopStart, endBrace + 1, "illegal Unicode character");
                            break;
                        }
                        s = codecs.insertReplacementAndGetResume(v, errors2, "unicodeescape", str, loopStart, endBrace, "malformed \\N character escape");
                        break;
                    }
                    s = codecs.insertReplacementAndGetResume(v, errors2, "unicodeescape", str, loopStart, s + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    v.append('\\');
                    v.append(str.charAt(s - 1));
                }
            }
        }
        return v.toString();
    }

    private static int hexescape(StringBuilder partialDecode, String errors2, int digits, int hexDigitStart, String str, int size, String errorMessage) {
        int i;
        if (hexDigitStart + digits > size) {
            return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, size, errorMessage);
        }
        int x = 0;
        for (i = 0; i < digits; ++i) {
            char c = str.charAt(hexDigitStart + i);
            int d = Character.digit(c, 16);
            if (d == -1) {
                return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i + 1, errorMessage);
            }
            x = x << 4 & 0xFFFFFFF0;
            if (c >= '0' && c <= '9') {
                x += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                x += 10 + c - 97;
                continue;
            }
            x += 10 + c - 65;
        }
        if (PyString.storeUnicodeCharacter(x, partialDecode)) {
            return hexDigitStart + i;
        }
        return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int value, StringBuilder partialDecode) {
        if (value < 0 || value >= 55296 && value <= 57343) {
            return false;
        }
        if (value <= 0x10FFFF) {
            partialDecode.appendCodePoint(value);
            return true;
        }
        return false;
    }

    final PyObject str___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("string index out of range");
        }
        return ret;
    }

    final PyObject str___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final int str___cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c = this.getString().compareTo(((PyString)other).getString());
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject str___eq__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().equals(s) ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final PyObject str___ne__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().equals(s) ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.str___lt__(other);
    }

    final PyObject str___lt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.str___le__(other);
    }

    final PyObject str___le__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.str___gt__(other);
    }

    final PyObject str___gt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.str___ge__(other);
    }

    final PyObject str___ge__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject o) {
        if (o instanceof PyString && !(o instanceof PyUnicode)) {
            return o.toString();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        return this.getString().hashCode();
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.getString());
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c.isAssignableFrom(String.class)) {
            return c == CharSequence.class ? this : this.getString();
        }
        if ((c == Character.TYPE || c == Character.class) && this.getString().length() == 1) {
            return Character.valueOf(this.getString().charAt(0));
        }
        if (c.isArray()) {
            if (c.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (c.getComponentType() == Character.TYPE) {
                return this.getString().toCharArray();
            }
        }
        if (c.isAssignableFrom(Collection.class)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < this.__len__(); ++i) {
                list.add(this.pyget(i).__tojava__(String.class));
            }
            return list;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    protected PyObject pyget(int i) {
        return Py.makeCharacter(this.string.charAt(i));
    }

    public int getInt(int i) {
        return this.string.charAt(i);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            return this.fromSubstring(start, stop);
        }
        int n = PyString.sliceLength(start, stop, step);
        char[] new_chars = new char[n];
        int j = 0;
        int i = start;
        while (j < n) {
            new_chars[j++] = this.getString().charAt(i);
            i += step;
        }
        return this.createInstance(new String(new_chars), true);
    }

    public PyString createInstance(String str) {
        return new PyString(str);
    }

    protected PyString createInstance(String str, boolean isBasic) {
        return new PyString(str);
    }

    private static String asU16BytesOrNull(PyObject obj) {
        if (obj instanceof PyString) {
            if (obj instanceof PyUnicode) {
                return null;
            }
            return ((PyString)obj).getString();
        }
        if (obj instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)obj)).getBuffer(284);){
                String string2 = buf.toString();
                return string2;
            }
        }
        return null;
    }

    protected static String asU16BytesOrError(PyObject obj) throws PyException {
        String ret = PyString.asU16BytesOrNull(obj);
        if (ret != null) {
            return ret;
        }
        throw Py.TypeError("expected str, bytearray or other buffer compatible object");
    }

    private static String asU16BytesNullOrError(PyObject obj, String name) throws PyException {
        if (obj == null || obj == Py.None) {
            return null;
        }
        String ret = PyString.asU16BytesOrNull(obj);
        if (ret != null) {
            return ret;
        }
        if (name == null) {
            throw Py.TypeError("expected None, str or buffer compatible object");
        }
        throw Py.TypeError(name + " arg must be None, str or buffer compatible object");
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final boolean str___contains__(PyObject o) {
        String other = PyString.asU16BytesOrNull(o);
        if (other != null) {
            return this.getString().indexOf(other) >= 0;
        }
        if (o instanceof PyUnicode) {
            return this.decode().__contains__(o);
        }
        throw Py.TypeError("'in <string>' requires string as left operand, not " + (o == null ? Py.None : o).getType().fastGetName());
    }

    @Override
    protected PyObject repeat(int count2) {
        int s;
        if (count2 < 0) {
            count2 = 0;
        }
        if ((long)(s = this.getString().length()) * (long)count2 > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] new_chars = new char[s * count2];
        for (int i = 0; i < count2; ++i) {
            this.getString().getChars(0, s, new_chars, i * s);
        }
        return this.createInstance(new String(new_chars));
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject str___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    final PyObject str___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.str___add__(other);
    }

    final PyObject str___add__(PyObject other) {
        String otherStr = PyString.asU16BytesOrNull(other);
        if (otherStr != null) {
            return new PyString(this.getString().concat(otherStr), true);
        }
        if (other instanceof PyUnicode) {
            return this.decode().__add__(other);
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.getString()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.str___mod__(other);
    }

    public PyObject str___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), false);
        return fmt.format(other);
    }

    @Override
    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException e) {
            if (e.match(Py.OverflowError)) {
                return this.atol(10);
            }
            throw e;
        }
    }

    @Override
    public PyObject __long__() {
        return this.atol(10);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    @Override
    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    @Override
    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyComplex __complex__() {
        return this.atocx();
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            char c = s.charAt(0);
            return this._isupper(c) ? String.valueOf((char)(c ^ 0x20)) : s;
        }
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            buf[i] = this._isupper(c) ? (char)(c ^ 0x20) : c;
        }
        return new String(buf);
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            char c = s.charAt(0);
            return this._islower(c) ? String.valueOf((char)(c ^ 0x20)) : s;
        }
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            buf[i] = this._islower(c) ? (char)(c ^ 0x20) : c;
        }
        return new String(buf);
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = chars[i];
            if (this._isalpha(ch)) {
                if (previous_is_cased) {
                    if (this._isupper(ch)) {
                        chars[i] = (char)(ch ^ 0x20);
                    }
                } else if (this._islower(ch)) {
                    chars[i] = (char)(ch ^ 0x20);
                }
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new String(chars);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            char c = s.charAt(0);
            return this._isalpha(c) ? String.valueOf((char)(c ^ 0x20)) : s;
        }
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            buf[i] = this._isalpha(c) ? (char)(c ^ 0x20) : c;
        }
        return new String(buf);
    }

    public String strip() {
        return this._strip();
    }

    public String strip(String stripChars) {
        return this._strip(stripChars);
    }

    public PyObject strip(PyObject stripChars) {
        return this.str_strip(stripChars);
    }

    final PyObject str_strip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_strip(chars);
        }
        String stripChars = PyString.asU16BytesNullOrError(chars, "strip");
        return new PyString(this._strip(stripChars), true);
    }

    protected final String _strip() {
        int right = this._findRight();
        if (right < 0) {
            return "";
        }
        int left = this._findLeft(right);
        return this.getString().substring(left, right + 1);
    }

    protected final String _strip(String stripChars) {
        if (stripChars == null) {
            return this._strip();
        }
        int right = this._findRight(stripChars);
        if (right < 0) {
            return "";
        }
        int left = this._findLeft(stripChars, right);
        return this.getString().substring(left, right + 1);
    }

    protected int _findLeft(int right) {
        String s = this.getString();
        for (int left = 0; left < right; ++left) {
            if (BaseBytes.isspace((byte)s.charAt(left))) continue;
            return left;
        }
        return right;
    }

    private int _findLeft(String stripChars, int right) {
        String s = this.getString();
        for (int left = 0; left < right; ++left) {
            if (stripChars.indexOf(s.charAt(left)) >= 0) continue;
            return left;
        }
        return right;
    }

    protected int _findRight() {
        String s = this.getString();
        int right = s.length();
        while (--right >= 0) {
            if (BaseBytes.isspace((byte)s.charAt(right))) continue;
            return right;
        }
        return -1;
    }

    private int _findRight(String stripChars) {
        String s = this.getString();
        int right = s.length();
        while (--right >= 0) {
            if (stripChars.indexOf(s.charAt(right)) >= 0) continue;
            return right;
        }
        return -1;
    }

    public String lstrip() {
        return this._lstrip();
    }

    public String lstrip(String stripChars) {
        return this._lstrip(stripChars);
    }

    public PyObject lstrip(PyObject stripChars) {
        return this.str_lstrip(stripChars);
    }

    final PyObject str_lstrip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_lstrip(chars);
        }
        String stripChars = PyString.asU16BytesNullOrError(chars, "lstrip");
        return new PyString(this._lstrip(stripChars), true);
    }

    protected final String _lstrip() {
        String s = this.getString();
        int left = this._findLeft(s.length());
        return s.substring(left);
    }

    protected final String _lstrip(String stripChars) {
        if (stripChars == null) {
            return this._lstrip();
        }
        String s = this.getString();
        int left = this._findLeft(stripChars, s.length());
        return s.substring(left);
    }

    public String rstrip() {
        return this._rstrip();
    }

    public String rstrip(String stripChars) {
        return this._rstrip(stripChars);
    }

    public PyObject rstrip(PyObject stripChars) {
        return this.str_rstrip(stripChars);
    }

    final PyObject str_rstrip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rstrip(chars);
        }
        String stripChars = PyString.asU16BytesNullOrError(chars, "rstrip");
        return new PyString(this._rstrip(stripChars), true);
    }

    protected final String _rstrip() {
        int right = this._findRight();
        if (right < 0) {
            return "";
        }
        return this.getString().substring(0, right + 1);
    }

    protected final String _rstrip(String stripChars) {
        if (stripChars == null) {
            return this._rstrip();
        }
        int right = this._findRight(stripChars);
        return this.getString().substring(0, right + 1);
    }

    public PyList split() {
        return this._split(null, -1);
    }

    public PyList split(String sep) {
        return this._split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        return this._split(sep, maxsplit);
    }

    public PyList split(PyObject sep) {
        return this.str_split(sep, -1);
    }

    public PyList split(PyObject sep, int maxsplit) {
        return this.str_split(sep, maxsplit);
    }

    final PyList str_split(PyObject sepObj, int maxsplit) {
        if (sepObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_split(sepObj, maxsplit);
        }
        String sep = PyString.asU16BytesNullOrError(sepObj, "split");
        return this._split(sep, maxsplit);
    }

    protected final PyList _split(String sep, int maxsplit) {
        if (sep == null) {
            return this.splitfields(maxsplit);
        }
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        return this.splitfields(sep, maxsplit);
    }

    protected PyList splitfields(int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int start = 0;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (start < length) {
            int index;
            while (start < length && BaseBytes.isspace((byte)s.charAt(start))) {
                ++start;
            }
            if (start >= length) break;
            if (splits >= maxsplit) {
                index = length;
            } else {
                for (index = start; index < length && !BaseBytes.isspace((byte)s.charAt(index)); ++index) {
                }
            }
            list.append(this.fromSubstring(start, index));
            ++splits;
            start = index;
        }
        return list;
    }

    private PyList splitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int sepLength = sep.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        if (maxsplit == 0) {
            list.append(this);
        } else if (sepLength == 0) {
            int index;
            int m = maxsplit > length ? length + 1 : maxsplit;
            list.append(this.createInstance(""));
            for (index = 0; index < m - 1; ++index) {
                list.append(this.fromSubstring(index, index + 1));
            }
            list.append(this.fromSubstring(index, length));
        } else {
            int index;
            int start = 0;
            for (int splits = 0; splits < maxsplit && (index = s.indexOf(sep, start)) >= 0; ++splits) {
                list.append(this.fromSubstring(start, index));
                start = index + sepLength;
            }
            list.append(this.fromSubstring(start, length));
        }
        return list;
    }

    public PyList rsplit() {
        return this._rsplit(null, -1);
    }

    public PyList rsplit(String sep) {
        return this._rsplit(sep, -1);
    }

    public PyList rsplit(String sep, int maxsplit) {
        return this._rsplit(sep, maxsplit);
    }

    public PyList rsplit(PyObject sep) {
        return this.str_rsplit(sep, -1);
    }

    public PyList rsplit(PyObject sep, int maxsplit) {
        return this.str_rsplit(sep, maxsplit);
    }

    final PyList str_rsplit(PyObject sepObj, int maxsplit) {
        if (sepObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rsplit(sepObj, maxsplit);
        }
        String sep = PyString.asU16BytesNullOrError(sepObj, "rsplit");
        return this._rsplit(sep, maxsplit);
    }

    protected final PyList _rsplit(String sep, int maxsplit) {
        if (sep == null) {
            return this.rsplitfields(maxsplit);
        }
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        return this.rsplitfields(sep, maxsplit);
    }

    protected PyList rsplitfields(int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int end = length - 1;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (end >= 0) {
            int index;
            while (end >= 0 && BaseBytes.isspace((byte)s.charAt(end))) {
                --end;
            }
            if (end < 0) break;
            if (splits >= maxsplit) {
                index = -1;
            } else {
                for (index = end; index >= 0 && !BaseBytes.isspace((byte)s.charAt(index)); --index) {
                }
            }
            list.append(this.fromSubstring(index + 1, end + 1));
            ++splits;
            end = index;
        }
        list.reverse();
        return list;
    }

    private PyList rsplitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        String s = this.getString();
        int length = s.length();
        int sepLength = sep.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        if (maxsplit == 0) {
            list.append(this);
        } else {
            int index;
            if (sepLength == 0) {
                throw Py.ValueError("empty separator");
            }
            int end = length;
            for (int splits = 0; splits < maxsplit && (index = s.lastIndexOf(sep, end - sepLength)) >= 0; ++splits) {
                list.append(this.fromSubstring(index + sepLength, end));
                end = index;
            }
            list.append(this.fromSubstring(0, end));
        }
        list.reverse();
        return list;
    }

    public PyTuple partition(PyObject sepObj) {
        return this.str_partition(sepObj);
    }

    final PyTuple str_partition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        String sep = PyString.asU16BytesOrError(sepObj);
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().indexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(this, Py.EmptyString, Py.EmptyString);
    }

    final PyTuple unicodePartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.indexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(this, emptyUnicode, emptyUnicode);
    }

    public PyTuple rpartition(PyObject sepObj) {
        return this.str_rpartition(sepObj);
    }

    final PyTuple str_rpartition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodeRpartition(sepObj);
        }
        String sep = PyString.asU16BytesOrError(sepObj);
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(Py.EmptyString, Py.EmptyString, this);
    }

    final PyTuple unicodeRpartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(emptyUnicode, emptyUnicode, this);
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.str_splitlines(keepends);
    }

    final PyList str_splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        int j = 0;
        int i = 0;
        while (i < n) {
            while (i < n && chars[i] != '\n' && chars[i] != '\r' && Character.getType(chars[i]) != 13) {
                ++i;
            }
            int eol = i;
            if (i < n) {
                i = chars[i] == '\r' && i + 1 < n && chars[i + 1] == '\n' ? (i += 2) : ++i;
                if (keepends) {
                    eol = i;
                }
            }
            list.append(this.fromSubstring(j, eol));
            j = i;
        }
        if (j < n) {
            list.append(this.fromSubstring(j, n));
        }
        return list;
    }

    protected PyString fromSubstring(int begin, int end) {
        return new PyString(this.getString().substring(begin, end), true);
    }

    public int index(PyObject sub) {
        return this.str_index(sub, null, null);
    }

    public int index(PyObject sub, PyObject start) throws PyException {
        return this.str_index(sub, start, null);
    }

    public int index(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.checkIndex(this.str_index(sub, start, end));
    }

    public int index(String sub) {
        return this.index(sub, null, null);
    }

    public int index(String sub, PyObject start) {
        return this.index(sub, start, null);
    }

    public int index(String sub, PyObject start, PyObject end) {
        return this.checkIndex(this._find(sub, start, end));
    }

    final int str_index(PyObject subObj, PyObject start, PyObject end) {
        return this.checkIndex(this.str_find(subObj, start, end));
    }

    public int rindex(PyObject sub) {
        return this.str_rindex(sub, null, null);
    }

    public int rindex(PyObject sub, PyObject start) throws PyException {
        return this.str_rindex(sub, start, null);
    }

    public int rindex(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.checkIndex(this.str_rindex(sub, start, end));
    }

    public int rindex(String sub) {
        return this.rindex(sub, null, null);
    }

    public int rindex(String sub, PyObject start) {
        return this.rindex(sub, start, null);
    }

    public int rindex(String sub, PyObject start, PyObject end) {
        return this.checkIndex(this._rfind(sub, start, end));
    }

    final int str_rindex(PyObject subObj, PyObject start, PyObject end) {
        return this.checkIndex(this.str_rfind(subObj, start, end));
    }

    protected final int checkIndex(int index) throws PyException {
        if (index >= 0) {
            return index;
        }
        throw Py.ValueError("substring not found");
    }

    public int count(PyObject sub) {
        return this.count(sub, null, null);
    }

    public int count(PyObject sub, PyObject start) {
        return this.count(sub, start, null);
    }

    public int count(PyObject sub, PyObject start, PyObject end) {
        return this.str_count(sub, start, end);
    }

    public int count(String sub) {
        return this.count(sub, null, null);
    }

    public int count(String sub, PyObject start) {
        return this.count(sub, start, null);
    }

    public int count(String sub, PyObject start, PyObject end) {
        return this._count(sub, start, end);
    }

    final int str_count(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return this.asUnicode(start, end).unicode_count(subObj, null, null);
        }
        String sub = PyString.asU16BytesOrError(subObj);
        return this._count(sub, start, end);
    }

    protected final int _count(String sub, PyObject startObj, PyObject endObj) {
        int index;
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            int n = this.__len__();
            if (end < 0 || end < start || start > n) {
                return 0;
            }
            return Math.min(end, n) - Math.max(start, 0) + 1;
        }
        int start = indices[0];
        int end = indices[1];
        int limit = end - subLen;
        int count2 = 0;
        while (start <= limit && (index = this.getString().indexOf(sub, start)) >= 0 && index <= limit) {
            ++count2;
            start = index + subLen;
        }
        return count2;
    }

    public int find(PyObject sub) {
        return this.find(sub, null, null);
    }

    public int find(PyObject sub, PyObject start) {
        return this.find(sub, start, null);
    }

    public int find(PyObject sub, PyObject start, PyObject end) {
        return this.str_find(sub, start, end);
    }

    public int find(String sub) {
        return this.find(sub, null, null);
    }

    public int find(String sub, PyObject start) {
        return this.find(sub, start, null);
    }

    public int find(String sub, PyObject start, PyObject end) {
        return this._find(sub, start, end);
    }

    final int str_find(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_find(subObj, start, end);
        }
        String sub = PyString.asU16BytesOrError(subObj);
        return this._find(sub, start, end);
    }

    protected final int _find(String sub, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            if (end < 0 || end < start || start > this.__len__()) {
                return -1;
            }
            return indices[0];
        }
        int start = indices[0];
        int end = indices[1];
        int found = this.getString().indexOf(sub, start);
        if (found >= 0 && found + subLen <= end) {
            return found;
        }
        return -1;
    }

    public int rfind(PyObject sub) {
        return this.rfind(sub, null, null);
    }

    public int rfind(PyObject sub, PyObject start) {
        return this.rfind(sub, start, null);
    }

    public int rfind(PyObject sub, PyObject start, PyObject end) {
        return this.str_rfind(sub, start, end);
    }

    public int rfind(String sub) {
        return this.rfind(sub, null, null);
    }

    public int rfind(String sub, PyObject start) {
        return this.rfind(sub, start, null);
    }

    public int rfind(String sub, PyObject start, PyObject end) {
        return this._rfind(sub, start, end);
    }

    final int str_rfind(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rfind(subObj, start, end);
        }
        String sub = PyString.asU16BytesOrError(subObj);
        return this._rfind(sub, start, end);
    }

    protected final int _rfind(String sub, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            if (end < 0 || end < start || start > this.__len__()) {
                return -1;
            }
            return indices[1];
        }
        int start = indices[0];
        int end = indices[1];
        int found = this.getString().lastIndexOf(sub, end - subLen);
        if (found >= start) {
            return found;
        }
        return -1;
    }

    public double atof() {
        double x = 0.0;
        Matcher m = PyString.getFloatPattern().matcher(this.getString());
        boolean valid = m.matches();
        if (valid) {
            String number = m.group(1);
            try {
                char lastChar = number.charAt(number.length() - 1);
                x = Character.isLetter(lastChar) ? PyString.atofSpecials(m.group(1)) : Double.parseDouble(m.group(1));
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        }
        if (valid) {
            return x;
        }
        String fmt = "invalid literal for float: %s";
        throw Py.ValueError(String.format(fmt, this.getString().trim()));
    }

    private static synchronized Pattern getFloatPattern() {
        if (floatPattern == null) {
            floatPattern = Pattern.compile("\\s*([+-]?(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+))\\s*");
        }
        return floatPattern;
    }

    private static synchronized Pattern getComplexPattern() {
        if (complexPattern == null) {
            complexPattern = Pattern.compile("\\s*(?<a>\\(\\s*)?(?<x>[+-]?(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)?)(?<y>[+-](?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)?)?(?<j>[jJ])?\\s*(?<b>\\)\\s*)?");
        }
        return complexPattern;
    }

    private static double atofSpecials(String s) throws NumberFormatException {
        switch (s.toLowerCase()) {
            case "nan": 
            case "+nan": 
            case "-nan": {
                return Double.NaN;
            }
            case "inf": 
            case "+inf": 
            case "infinity": 
            case "+infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "-inf": 
            case "-infinity": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        throw new NumberFormatException();
    }

    private PyComplex atocx() {
        double x = 0.0;
        double y = 0.0;
        Matcher m = PyString.getComplexPattern().matcher(this.getString());
        boolean valid = m.matches();
        if (valid) {
            if (m.group("a") != null != (m.group("b") != null)) {
                valid = false;
            } else {
                try {
                    String xs = m.group("x");
                    String ys = m.group("y");
                    if (m.group("j") != null) {
                        if (ys != null) {
                            y = PyString.toComplexPart(ys);
                            x = PyString.toComplexPart(xs);
                        } else {
                            y = xs != null ? PyString.toComplexPart(xs) : 1.0;
                        }
                    } else {
                        x = Double.parseDouble(xs);
                        if (ys != null) {
                            throw new NumberFormatException();
                        }
                    }
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
            }
        }
        if (valid) {
            return new PyComplex(x, y);
        }
        String fmt = "complex() arg is a malformed string: %s";
        throw Py.ValueError(String.format(fmt, this.getString().trim()));
    }

    private static double toComplexPart(String s) throws NumberFormatException {
        if (s.length() == 0) {
            return 1.0;
        }
        char lastChar = s.charAt(s.length() - 1);
        if (Character.isLetter(lastChar)) {
            return PyString.atofSpecials(s);
        }
        if (lastChar == '+') {
            return 1.0;
        }
        if (lastChar == '-') {
            return -1.0;
        }
        return Double.parseDouble(s);
    }

    private BigInteger asciiToBigInteger(int base2, boolean isLong) {
        int b;
        String str = this.getString();
        int e = str.length();
        for (b = 0; b < e && Character.isWhitespace(str.charAt(b)); ++b) {
        }
        while (e > b && Character.isWhitespace(str.charAt(e - 1))) {
            --e;
        }
        char sign = '\u0000';
        if (b < e) {
            sign = str.charAt(b);
            if (sign == '-' || sign == '+') {
                ++b;
                while (b < e && Character.isWhitespace(str.charAt(b))) {
                    ++b;
                }
            }
            if (base2 == 16) {
                if (str.charAt(b) == '0' && b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'X') {
                    b += 2;
                }
            } else if (base2 == 0) {
                if (str.charAt(b) == '0') {
                    if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'X') {
                        base2 = 16;
                        b += 2;
                    } else if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'O') {
                        base2 = 8;
                        b += 2;
                    } else if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'B') {
                        base2 = 2;
                        b += 2;
                    } else {
                        base2 = 8;
                    }
                }
            } else if (base2 == 8) {
                if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'O') {
                    b += 2;
                }
            } else if (base2 == 2 && b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'B') {
                b += 2;
            }
        }
        if (base2 == 0) {
            base2 = 10;
        }
        if (isLong && base2 < 22 && e > b && (str.charAt(e - 1) == 'L' || str.charAt(e - 1) == 'l')) {
            --e;
        }
        String s = str;
        if (b > 0 || e < str.length()) {
            s = str.substring(b, e);
        }
        BigInteger bi = sign == '-' ? new BigInteger("-" + s, base2) : new BigInteger(s, base2);
        return bi;
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base2) {
        if (base2 != 0 && base2 < 2 || base2 > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        try {
            BigInteger bi = this.asciiToBigInteger(base2, false);
            if (bi.compareTo(PyInteger.MAX_INT) > 0 || bi.compareTo(PyInteger.MIN_INT) < 0) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return bi.intValue();
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base2 + ": '" + this.getString() + "'");
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base2 + ": '" + this.getString() + "'");
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base2) {
        if (base2 != 0 && base2 < 2 || base2 > 36) {
            throw Py.ValueError("invalid base for long literal:" + base2);
        }
        try {
            BigInteger bi = this.asciiToBigInteger(base2, true);
            return new PyLong(bi);
        }
        catch (NumberFormatException exc) {
            if (this instanceof PyUnicode) {
                throw Py.UnicodeEncodeError("decimal", "codec can't encode character", 0, 0, "invalid decimal Unicode string");
            }
            throw Py.ValueError("invalid literal for long() with base " + base2 + ": '" + this.getString() + "'");
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for long() with base " + base2 + ": '" + this.getString() + "'");
        }
    }

    private static String padding(int n, char pad) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = pad;
        }
        return new String(chars);
    }

    private static char parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return ' ';
        }
        if (fillchar.length() != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.charAt(0);
    }

    public String ljust(int width) {
        return this.str_ljust(width, null);
    }

    public String ljust(int width, String padding) {
        return this.str_ljust(width, padding);
    }

    final String str_ljust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("ljust", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        return this.getString() + PyString.padding(n, pad);
    }

    public String rjust(int width) {
        return this.str_rjust(width, null);
    }

    final String str_rjust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("rjust", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        return PyString.padding(n, pad) + this.getString();
    }

    public String center(int width) {
        return this.str_center(width, null);
    }

    final String str_center(int width, String fillchar) {
        char pad = PyString.parse_fillchar("center", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.padding(half, pad) + this.getString() + PyString.padding(n - half, pad);
    }

    public String zfill(int width) {
        return this.str_zfill(width);
    }

    final String str_zfill(int width) {
        char start;
        String s = this.getString();
        int n = s.length();
        if (n >= width) {
            return s;
        }
        char[] chars = new char[width];
        int nzeros = width - n;
        int i = 0;
        int sStart = 0;
        if (n > 0 && ((start = s.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i;
            ++nzeros;
            sStart = 1;
        }
        while (i < nzeros) {
            chars[i] = 48;
            ++i;
        }
        s.getChars(sStart, s.length(), chars, i);
        return new String(chars);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        return this.str_expandtabs(tabsize);
    }

    final String str_expandtabs(int tabsize) {
        String s = this.getString();
        StringBuilder buf = new StringBuilder((int)((double)s.length() * 1.5));
        char[] chars = s.toCharArray();
        int n = chars.length;
        int position = 0;
        for (int i = 0; i < n; ++i) {
            char c = chars[i];
            if (c == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c == '\n' || c == '\r') {
                position = -1;
            }
            buf.append(c);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        String s = this.getString();
        int n = s.length();
        if (n == 0) {
            return s;
        }
        char[] buf = new char[n];
        char c = s.charAt(0);
        buf[0] = this._islower(c) ? (char)(c ^ 0x20) : c;
        for (int i = 1; i < n; ++i) {
            c = s.charAt(i);
            buf[i] = this._isupper(c) ? (char)(c ^ 0x20) : c;
        }
        return new String(buf);
    }

    public PyString replace(PyObject oldPiece, PyObject newPiece) {
        return this.str_replace(oldPiece, newPiece, -1);
    }

    public PyString replace(PyObject oldPiece, PyObject newPiece, int count2) {
        return this.str_replace(oldPiece, newPiece, count2);
    }

    final PyString str_replace(PyObject oldPieceObj, PyObject newPieceObj, int count2) {
        if (oldPieceObj instanceof PyUnicode || newPieceObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_replace(oldPieceObj, newPieceObj, count2);
        }
        String oldPiece = PyString.asU16BytesOrError(oldPieceObj);
        String newPiece = PyString.asU16BytesOrError(newPieceObj);
        return this._replace(oldPiece, newPiece, count2);
    }

    protected final PyString _replace(String oldPiece, String newPiece, int count2) {
        String s = this.getString();
        int len = s.length();
        int oldLen = oldPiece.length();
        int newLen = newPiece.length();
        if (len == 0) {
            if (count2 < 0 && oldLen == 0) {
                return this.createInstance(newPiece, true);
            }
            return this.createInstance(s, true);
        }
        if (oldLen == 0 && newLen != 0 && count2 != 0) {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append(newPiece);
            for (i = 0; i < len && (count2 < 0 || i < count2 - 1); ++i) {
                buffer.append(s.charAt(i)).append(newPiece);
            }
            buffer.append(s.substring(i));
            return this.createInstance(buffer.toString(), true);
        }
        if (count2 < 0) {
            count2 = oldLen == 0 ? len + 1 : len;
        }
        return this.createInstance(newPiece).join(this.splitfields(oldPiece, count2));
    }

    public PyString join(PyObject seq) {
        return this.str_join(seq);
    }

    final PyString str_join(PyObject obj) {
        int i;
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return Py.EmptyString;
        }
        if (seqLen == 1 && ((item = seq.pyget(0)).getType() == TYPE || item.getType() == PyUnicode.TYPE)) {
            return (PyString)item;
        }
        long size = 0L;
        int sepLen = this.getString().length();
        for (i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string, %.80s found", i, item.getType().fastGetName()));
            }
            if (item instanceof PyUnicode) {
                return this.unicodeJoin(seq);
            }
            if (i != 0) {
                size += (long)sepLen;
            }
            if ((size += (long)((PyString)item).getString().length()) <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("join() result is too long for a Python string");
        }
        StringBuilder buf = new StringBuilder((int)size);
        for (i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (i != 0) {
                buf.append(this.getString());
            }
            buf.append(((PyString)item).getString());
        }
        return new PyString(buf.toString(), true);
    }

    final PyUnicode unicodeJoin(PyObject obj) {
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return new PyUnicode();
        }
        if (seqLen == 1 && (item = seq.pyget(0)).getType() == PyUnicode.TYPE) {
            return (PyUnicode)item;
        }
        String sep = null;
        if (seqLen > 1) {
            if (this instanceof PyUnicode) {
                sep = this.getString();
            } else {
                sep = ((PyUnicode)this.decode()).getString();
                seqLen = seq.__len__();
            }
        }
        long size = 0L;
        int sepLen = this.getString().length();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string or Unicode, %.80s found", i, item.getType().fastGetName()));
            }
            if (!(item instanceof PyUnicode)) {
                item = ((PyString)item).decode();
                seqLen = seq.__len__();
            }
            String itemString = ((PyUnicode)item).getString();
            if (i != 0) {
                size += (long)sepLen;
                buf.append(sep);
            }
            if ((size += (long)itemString.length()) > Integer.MAX_VALUE) {
                throw Py.OverflowError("join() result is too long for a Python string");
            }
            buf.append(itemString);
        }
        return new PyUnicode(buf.toString());
    }

    public boolean startswith(PyObject prefix) {
        return this.startswith(prefix, null, null);
    }

    public boolean startswith(PyObject prefix, PyObject start) {
        return this.startswith(prefix, start, null);
    }

    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean str_startswith(PyObject prefix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int start = indices[0];
        int sliceLen = indices[1] - start;
        if (!(prefix instanceof PyTuple)) {
            if (prefix instanceof PyUnicode) {
                return this.asUnicode(startObj, endObj).unicode_startswith(prefix, null, null);
            }
            String s = PyString.asU16BytesOrError(prefix);
            return sliceLen >= s.length() && this.getString().startsWith(s, start);
        }
        PyObject[] prefixes = ((PyTuple)prefix).getArray();
        String string2 = this.getString();
        int unicodeCount = 0;
        for (PyObject o : prefixes) {
            if (o instanceof PyUnicode) {
                prefixes[unicodeCount++] = o;
                continue;
            }
            String s = PyString.asU16BytesOrError(o);
            if (sliceLen < s.length() || !string2.startsWith(s, start)) continue;
            return true;
        }
        if (unicodeCount == 0) {
            return false;
        }
        PyTuple t = new PyTuple(Arrays.copyOf(prefixes, unicodeCount));
        return this.asUnicode(startObj, endObj).unicode_startswith(t, null, null);
    }

    public boolean endswith(PyObject suffix) {
        return this.endswith(suffix, null, null);
    }

    public boolean endswith(PyObject suffix, PyObject start) {
        return this.endswith(suffix, start, null);
    }

    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final boolean str_endswith(PyObject suffix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        if (!(suffix instanceof PyTuple)) {
            if (suffix instanceof PyUnicode) {
                return this.asUnicode(startObj, endObj).unicode_endswith(suffix, null, null);
            }
            String s = PyString.asU16BytesOrError(suffix);
            return this.getString().substring(indices[0], indices[1]).endsWith(s);
        }
        PyObject[] suffixes = ((PyTuple)suffix).getArray();
        String string2 = this.getString().substring(indices[0], indices[1]);
        int unicodeCount = 0;
        for (PyObject o : suffixes) {
            if (o instanceof PyUnicode) {
                suffixes[unicodeCount++] = o;
                continue;
            }
            String s = PyString.asU16BytesOrError(o);
            if (!string2.endsWith(s)) continue;
            return true;
        }
        if (unicodeCount == 0) {
            return false;
        }
        PyTuple t = new PyTuple(Arrays.copyOf(suffixes, unicodeCount));
        return this.asUnicode(startObj, endObj).unicode_endswith(t, null, null);
    }

    protected int[] translateIndices(PyObject startObj, PyObject endObj) {
        int end;
        int start;
        int n = this.__len__();
        int[] result2 = new int[4];
        if (startObj == null || startObj == Py.None) {
            start = 0;
        } else {
            start = startObj.asIndex(null);
            if (start < 0) {
                start = n + start;
            }
            result2[2] = start;
        }
        if (endObj == null || endObj == Py.None) {
            result2[3] = end = n;
            result2[1] = end;
        } else {
            end = endObj.asIndex(null);
            if (end < 0) {
                result2[3] = end += n;
                if (end < 0) {
                    end = 0;
                } else {
                    result2[1] = end;
                }
            } else {
                result2[3] = end;
                result2[1] = end > n ? (end = n) : end;
            }
        }
        if (start < 0) {
            start = 0;
        } else {
            result2[0] = start > end ? (start = end) : start;
        }
        return result2;
    }

    public String translate(PyObject table) {
        return this.translate(table, null);
    }

    public String translate(PyObject table, PyObject deletechars) {
        return this.str_translate(table, deletechars);
    }

    public String translate(String table) {
        return this._translate(table, null);
    }

    public String translate(String table, String deletechars) {
        return this._translate(table, deletechars);
    }

    final String str_translate(PyObject tableObj, PyObject deletecharsObj) {
        String table = PyString.asU16BytesNullOrError(tableObj, null);
        String deletechars = PyString.asU16BytesNullOrError(deletecharsObj, null);
        return this._translate(table, deletechars);
    }

    private final String _translate(String table, String deletechars) {
        if (table != null && table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuilder buf = new StringBuilder(this.getString().length());
        for (int i = 0; i < this.getString().length(); ++i) {
            char c = this.getString().charAt(i);
            if (deletechars != null && deletechars.indexOf(c) >= 0) continue;
            if (table == null) {
                buf.append(c);
                continue;
            }
            try {
                buf.append(table.charAt(c));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._islower(s.charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (this._isupper(ch)) {
                return false;
            }
            if (cased || !this._islower(ch)) continue;
            cased = true;
        }
        return cased;
    }

    private boolean _islower(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.islower((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isupper(s.charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (this._islower(ch)) {
                return false;
            }
            if (cased || !this._isupper(ch)) continue;
            cased = true;
        }
        return cased;
    }

    private boolean _isupper(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isupper((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isalpha(s.charAt(0));
        }
        for (int i = 0; i < n; ++i) {
            if (this._isalpha(s.charAt(i))) continue;
            return false;
        }
        return n > 0;
    }

    private boolean _isalpha(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isalpha((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isalnum(s.charAt(0));
        }
        for (int i = 0; i < n; ++i) {
            if (this._isalnum(s.charAt(i))) continue;
            return false;
        }
        return n > 0;
    }

    private boolean _isalnum(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isalnum((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        return this.str_isdigit();
    }

    private boolean _isdecimal(char ch) {
        return Character.getType(ch) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isdigit(s.charAt(0));
        }
        for (int i = 0; i < n; ++i) {
            if (this._isdigit(s.charAt(i))) continue;
            return false;
        }
        return n > 0;
    }

    private boolean _isdigit(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isdigit((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        return this.str_isdigit();
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isupper(s.charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (this._isupper(ch)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (this._islower(ch)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        String s = this.getString();
        int n = s.length();
        if (n == 1) {
            return this._isspace(s.charAt(0));
        }
        for (int i = 0; i < n; ++i) {
            if (this._isspace(s.charAt(i))) continue;
            return false;
        }
        return n > 0;
    }

    private boolean _isspace(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isspace((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        int n = this.getString().length();
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (ch <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.encode(null, null);
    }

    public String encode(String encoding2) {
        return this.encode(encoding2, null);
    }

    public String encode(String encoding2, String errors2) {
        return codecs.encode(this, encoding2, errors2);
    }

    final String str_encode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("encode", args, keywords, "encoding", "errors");
        String encoding2 = ap.getString(0, null);
        String errors2 = ap.getString(1, null);
        return this.encode(encoding2, errors2);
    }

    public PyObject decode() {
        return this.decode(null, null);
    }

    public PyObject decode(String encoding2) {
        return this.decode(encoding2, null);
    }

    public PyObject decode(String encoding2, String errors2) {
        return codecs.decode(this, encoding2, errors2);
    }

    final PyObject str_decode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("decode", args, keywords, "encoding", "errors");
        String encoding2 = ap.getString(0, null);
        String errors2 = ap.getString(1, null);
        return this.decode(encoding2, errors2);
    }

    final PyObject str__formatter_parser() {
        return new MarkupIterator(this);
    }

    final PyObject str__formatter_field_name_split() {
        FieldNameIterator iterator = new FieldNameIterator(this);
        return new PyTuple(iterator.pyHead(), iterator);
    }

    final PyObject str_format(PyObject[] args, String[] keywords) {
        try {
            return new PyString(this.buildFormattedString(args, keywords, null, null));
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
    }

    protected String buildFormattedString(PyObject[] args, String[] keywords, MarkupIterator enclosingIterator, String value) {
        MarkupIterator.Chunk chunk2;
        MarkupIterator it = enclosingIterator == null ? new MarkupIterator(this) : new MarkupIterator(enclosingIterator, value);
        StringBuilder result2 = new StringBuilder();
        while ((chunk2 = it.nextChunk()) != null) {
            PyObject fieldObj;
            result2.append(chunk2.literalText);
            if (chunk2.fieldName == null || (fieldObj = this.getFieldObject(chunk2.fieldName, it.isBytes(), args, keywords)) == null) continue;
            if ("r".equals(chunk2.conversion)) {
                fieldObj = fieldObj.__repr__();
            } else if ("s".equals(chunk2.conversion)) {
                fieldObj = fieldObj.__str__();
            } else if (chunk2.conversion != null) {
                throw Py.ValueError("Unknown conversion specifier " + chunk2.conversion);
            }
            if (fieldObj instanceof PyUnicode && !(this instanceof PyUnicode)) {
                fieldObj = ((PyUnicode)fieldObj).__str__();
            }
            String formatSpec = chunk2.formatSpec;
            if (chunk2.formatSpecNeedsExpanding) {
                if (enclosingIterator != null) {
                    throw Py.ValueError("Max string recursion exceeded");
                }
                formatSpec = this.buildFormattedString(args, keywords, it, formatSpec);
            }
            this.renderField(fieldObj, formatSpec, result2);
        }
        return result2.toString();
    }

    private PyObject getFieldObject(String fieldName, boolean bytes, PyObject[] args, String[] keywords) {
        FieldNameIterator.Chunk chunk2;
        FieldNameIterator iterator = new FieldNameIterator(fieldName, bytes);
        PyObject head = iterator.pyHead();
        PyObject obj = null;
        int positionalCount = args.length - keywords.length;
        if (head.isIndex()) {
            int index = head.asIndex();
            if (index >= positionalCount) {
                throw Py.IndexError("tuple index out of range");
            }
            obj = args[index];
        } else {
            for (int i = 0; i < keywords.length; ++i) {
                if (!keywords[i].equals(head.asString())) continue;
                obj = args[positionalCount + i];
                break;
            }
            if (obj == null) {
                throw Py.KeyError(head);
            }
        }
        while (obj != null && (chunk2 = iterator.nextChunk()) != null) {
            Object key = chunk2.value;
            if (chunk2.is_attr) {
                obj = obj.__getattr__((String)key);
                continue;
            }
            if (key instanceof Integer) {
                obj = obj.__getitem__((Integer)key);
                continue;
            }
            obj = obj.__getitem__(new PyString(key.toString()));
        }
        return obj;
    }

    private void renderField(PyObject fieldObj, String formatSpec, StringBuilder result2) {
        PyString formatSpecStr = formatSpec == null ? Py.EmptyString : new PyString(formatSpec);
        result2.append(fieldObj.__format__(formatSpecStr).asString());
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.str___format__(formatSpec);
    }

    final PyObject str___format__(PyObject formatSpec) {
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        TextFormatter f = PyString.prepareFormatter(spec);
        if (f == null) {
            throw InternalFormat.Formatter.unknownFormat(spec.type, "string");
        }
        boolean unicode = this instanceof PyUnicode || formatSpec instanceof PyUnicode;
        f.setBytes(!unicode);
        f.format(this.getString());
        return f.pad().getPyResult();
    }

    static TextFormatter prepareFormatter(InternalFormat.Spec spec) throws PyException {
        switch (spec.type) {
            case 's': 
            case '\uffff': {
                if (spec.grouping) {
                    throw InternalFormat.Formatter.notAllowed("Grouping", "string", spec.type);
                }
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw InternalFormat.Formatter.signNotAllowed("string", '\u0000');
                }
                if (spec.alternate) {
                    throw InternalFormat.Formatter.alternateFormNotAllowed("string");
                }
                if (spec.align == '=') {
                    throw InternalFormat.Formatter.alignmentNotAllowed('=', "string");
                }
                spec = spec.withDefaults(InternalFormat.Spec.STRING);
                return new TextFormatter(spec);
            }
        }
        return null;
    }

    @Override
    public String asString(int index) throws PyObject.ConversionException {
        return this.getString();
    }

    @Override
    public String asString() {
        return this.getString();
    }

    @Override
    public int asInt() {
        this.asNumberCheck("__int__", "an integer");
        return super.asInt();
    }

    @Override
    public long asLong() {
        this.asNumberCheck("__long__", "an integer");
        return super.asLong();
    }

    @Override
    public double asDouble() {
        this.asNumberCheck("__float__", "a float");
        return super.asDouble();
    }

    private void asNumberCheck(String methodName, String description) {
        PyType type = this.getType();
        if (type == TYPE || type == PyUnicode.TYPE || type.lookup(methodName) == null) {
            throw Py.TypeError(description + " is required");
        }
    }

    @Override
    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.subSequence(start, end);
    }

    private PyUnicode asUnicode() {
        return new PyUnicode(this);
    }

    private PyUnicode asUnicode(PyObject startObj, PyObject endObj) {
        if (startObj == null && endObj == null) {
            return this.asUnicode();
        }
        int[] indices = this.translateIndices(startObj, endObj);
        return new PyUnicode(this.fromSubstring(indices[0], indices[1]));
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
        floatPattern = null;
        complexPattern = null;
    }

    public class PyString$str___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___getslice___exposer(String string2) {
            super(string2, 3, 4);
            this.doc = "";
        }

        public PyString$str___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyString)this.self).str___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyString$str___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___cmp___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyString$str___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyString)this.self).str___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("str.__cmp__(x,y) requires y to be 'str', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyString$str___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyString$str___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___lt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyString$str___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___le___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyString$str___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___gt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyString$str___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___ge___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyString$str___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyString$str___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyString)this.self).str___hash__());
        }
    }

    public class PyString$str___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___contains___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyString$str___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str___contains__(pyObject));
        }
    }

    public class PyString$str___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___mul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mul__(n) <==> x*n";
        }

        public PyString$str___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mul__(n) <==> x*n";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyString)this.self).str___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyString$str___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___getnewargs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyString$str___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str___getnewargs__();
        }
    }

    public class PyString$str___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___mod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyString$str___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str___mod__(pyObject);
        }
    }

    public class PyString$str_upper_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_upper_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.upper() -> string\n\nReturn a copy of the string S converted to uppercase.";
        }

        public PyString$str_upper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.upper() -> string\n\nReturn a copy of the string S converted to uppercase.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_upper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyString)this.self).str_upper();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_title_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_title_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.title() -> string\n\nReturn a titlecased version of S, i.e. words start with uppercase\ncharacters, all remaining cased characters have lowercase.";
        }

        public PyString$str_title_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.title() -> string\n\nReturn a titlecased version of S, i.e. words start with uppercase\ncharacters, all remaining cased characters have lowercase.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_title_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyString)this.self).str_title();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_strip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_strip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.strip([chars]) -> string or unicode\n\nReturn a copy of the string S with leading and trailing\nwhitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyString$str_strip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.strip([chars]) -> string or unicode\n\nReturn a copy of the string S with leading and trailing\nwhitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_strip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_strip(pyObject);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_strip(null);
        }
    }

    public class PyString$str_lstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_lstrip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.lstrip([chars]) -> string or unicode\n\nReturn a copy of the string S with leading whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyString$str_lstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.lstrip([chars]) -> string or unicode\n\nReturn a copy of the string S with leading whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_lstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_lstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_lstrip(null);
        }
    }

    public class PyString$str_rstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rstrip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.rstrip([chars]) -> string or unicode\n\nReturn a copy of the string S with trailing whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyString$str_rstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rstrip([chars]) -> string or unicode\n\nReturn a copy of the string S with trailing whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is unicode, S will be converted to unicode before stripping";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_rstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_rstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_rstrip(null);
        }
    }

    public class PyString$str_split_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_split_exposer(String string2) {
            super(string2, 1, 3);
            this.doc = "S.split([sep [,maxsplit]]) -> list of strings\n\nReturn a list of the words in the string S, using sep as the\ndelimiter string.  If maxsplit is given, at most maxsplit\nsplits are done. If sep is not specified or is None, any\nwhitespace string is a separator and empty strings are removed\nfrom the result.";
        }

        public PyString$str_split_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.split([sep [,maxsplit]]) -> list of strings\n\nReturn a list of the words in the string S, using sep as the\ndelimiter string.  If maxsplit is given, at most maxsplit\nsplits are done. If sep is not specified or is None, any\nwhitespace string is a separator and empty strings are removed\nfrom the result.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_split_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str_split(pyObject, Py.py2int(pyObject2));
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_split(pyObject, -1);
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_split(null, -1);
        }
    }

    public class PyString$str_partition_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_partition_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, and return the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, return S and two empty strings.";
        }

        public PyString$str_partition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, and return the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, return S and two empty strings.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_partition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_partition(pyObject);
        }
    }

    public class PyString$str_rpartition_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rpartition_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.rpartition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, starting at the end of S, and return\nthe part before it, the separator itself, and the part after it.  If the\nseparator is not found, return two empty strings and S.";
        }

        public PyString$str_rpartition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rpartition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, starting at the end of S, and return\nthe part before it, the separator itself, and the part after it.  If the\nseparator is not found, return two empty strings and S.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_rpartition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_rpartition(pyObject);
        }
    }

    public class PyString$str_splitlines_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_splitlines_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.splitlines([keepends]) -> list of strings\n\nReturn a list of the lines in S, breaking at line boundaries.\nLine breaks are not included in the resulting list unless keepends\nis given and true.";
        }

        public PyString$str_splitlines_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.splitlines([keepends]) -> list of strings\n\nReturn a list of the lines in S, breaking at line boundaries.\nLine breaks are not included in the resulting list unless keepends\nis given and true.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_splitlines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_splitlines(Py.py2boolean(pyObject));
        }

        public PyObject __call__() {
            return ((PyString)this.self).str_splitlines(false);
        }
    }

    public class PyString$str_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_index_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.index(sub [,start [,end]]) -> int\n\nLike S.find() but raise ValueError when the substring is not found.";
        }

        public PyString$str_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.index(sub [,start [,end]]) -> int\n\nLike S.find() but raise ValueError when the substring is not found.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_index(pyObject, null, null));
        }
    }

    public class PyString$str_rindex_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rindex_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.rindex(sub [,start [,end]]) -> int\n\nLike S.rfind() but raise ValueError when the substring is not found.";
        }

        public PyString$str_rindex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rindex(sub [,start [,end]]) -> int\n\nLike S.rfind() but raise ValueError when the substring is not found.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_rindex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_rindex(pyObject, null, null));
        }
    }

    public class PyString$str_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_count_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.count(sub[, start[, end]]) -> int\n\nReturn the number of non-overlapping occurrences of substring sub in\nstring S[start:end].  Optional arguments start and end are interpreted\nas in slice notation.";
        }

        public PyString$str_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.count(sub[, start[, end]]) -> int\n\nReturn the number of non-overlapping occurrences of substring sub in\nstring S[start:end].  Optional arguments start and end are interpreted\nas in slice notation.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_count(pyObject, null, null));
        }
    }

    public class PyString$str_find_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_find_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyString$str_find_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_find_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_find(pyObject, null, null));
        }
    }

    public class PyString$str_rfind_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rfind_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.rfind(sub [,start [,end]]) -> int\n\nReturn the highest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyString$str_rfind_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rfind(sub [,start [,end]]) -> int\n\nReturn the highest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_rfind_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyString)this.self).str_rfind(pyObject, null, null));
        }
    }

    public class PyString$str_ljust_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_ljust_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "S.ljust(width[, fillchar]) -> string\n\nReturn S left-justified in a string of length width. Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyString$str_ljust_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.ljust(width[, fillchar]) -> string\n\nReturn S left-justified in a string of length width. Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_ljust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            String string2 = ((PyString)this.self).str_ljust(Py.py2int(pyObject), pyObject2.asStringOrNull());
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_ljust(Py.py2int(pyObject), null);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_rjust_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_rjust_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "S.rjust(width[, fillchar]) -> string\n\nReturn S right-justified in a string of length width. Padding is\ndone using the specified fill character (default is a space)";
        }

        public PyString$str_rjust_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rjust(width[, fillchar]) -> string\n\nReturn S right-justified in a string of length width. Padding is\ndone using the specified fill character (default is a space)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_rjust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            String string2 = ((PyString)this.self).str_rjust(Py.py2int(pyObject), pyObject2.asStringOrNull());
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_rjust(Py.py2int(pyObject), null);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_center_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_center_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "S.center(width[, fillchar]) -> string\n\nReturn S centered in a string of length width. Padding is\ndone using the specified fill character (default is a space)";
        }

        public PyString$str_center_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.center(width[, fillchar]) -> string\n\nReturn S centered in a string of length width. Padding is\ndone using the specified fill character (default is a space)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_center_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            String string2 = ((PyString)this.self).str_center(Py.py2int(pyObject), pyObject2.asStringOrNull());
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_center(Py.py2int(pyObject), null);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_zfill_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_zfill_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.zfill(width) -> string\n\nPad a numeric string S with zeros on the left, to fill a field\nof the specified width.  The string S is never truncated.";
        }

        public PyString$str_zfill_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.zfill(width) -> string\n\nPad a numeric string S with zeros on the left, to fill a field\nof the specified width.  The string S is never truncated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_zfill_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_zfill(Py.py2int(pyObject));
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_expandtabs_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_expandtabs_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.expandtabs([tabsize]) -> string\n\nReturn a copy of S where all tab characters are expanded using spaces.\nIf tabsize is not given, a tab size of 8 characters is assumed.";
        }

        public PyString$str_expandtabs_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.expandtabs([tabsize]) -> string\n\nReturn a copy of S where all tab characters are expanded using spaces.\nIf tabsize is not given, a tab size of 8 characters is assumed.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_expandtabs_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_expandtabs(Py.py2int(pyObject));
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__() {
            String string2 = ((PyString)this.self).str_expandtabs(8);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_capitalize_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_capitalize_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.capitalize() -> string\n\nReturn a copy of the string S with only its first character\ncapitalized.";
        }

        public PyString$str_capitalize_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.capitalize() -> string\n\nReturn a copy of the string S with only its first character\ncapitalized.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_capitalize_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyString)this.self).str_capitalize();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_replace_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_replace_exposer(String string2) {
            super(string2, 3, 4);
            this.doc = "S.replace(old, new[, count]) -> string\n\nReturn a copy of string S with all occurrences of substring\nold replaced by new.  If the optional argument count is\ngiven, only the first count occurrences are replaced.";
        }

        public PyString$str_replace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.replace(old, new[, count]) -> string\n\nReturn a copy of string S with all occurrences of substring\nold replaced by new.  If the optional argument count is\ngiven, only the first count occurrences are replaced.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_replace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyString)this.self).str_replace(pyObject, pyObject2, Py.py2int(pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyString)this.self).str_replace(pyObject, pyObject2, -1);
        }
    }

    public class PyString$str_join_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_join_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.join(iterable) -> string\n\nReturn a string which is the concatenation of the strings in the\niterable.  The separator between elements is S.";
        }

        public PyString$str_join_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.join(iterable) -> string\n\nReturn a string which is the concatenation of the strings in the\niterable.  The separator between elements is S.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_join_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str_join(pyObject);
        }
    }

    public class PyString$str_startswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_startswith_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.startswith(prefix[, start[, end]]) -> bool\n\nReturn True if S starts with the specified prefix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nprefix can also be a tuple of strings to try.";
        }

        public PyString$str_startswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.startswith(prefix[, start[, end]]) -> bool\n\nReturn True if S starts with the specified prefix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nprefix can also be a tuple of strings to try.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_startswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str_startswith(pyObject, null, null));
        }
    }

    public class PyString$str_endswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_endswith_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.endswith(suffix[, start[, end]]) -> bool\n\nReturn True if S ends with the specified suffix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyString$str_endswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.endswith(suffix[, start[, end]]) -> bool\n\nReturn True if S ends with the specified suffix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_endswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyString)this.self).str_endswith(pyObject, null, null));
        }
    }

    public class PyString$str_translate_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_translate_exposer(String string2) {
            super(string2, 1, 3);
            this.doc = "S.translate(table [,deletechars]) -> string\n\nReturn a copy of the string S, where all characters occurring\nin the optional argument deletechars are removed, and the\nremaining characters have been mapped through the given\ntranslation table, which must be a string of length 256.";
        }

        public PyString$str_translate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.translate(table [,deletechars]) -> string\n\nReturn a copy of the string S, where all characters occurring\nin the optional argument deletechars are removed, and the\nremaining characters have been mapped through the given\ntranslation table, which must be a string of length 256.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_translate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            String string2 = ((PyString)this.self).str_translate(pyObject, pyObject2);
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((PyString)this.self).str_translate(pyObject, null);
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public PyObject __call__() {
            String string2 = ((PyString)this.self).str_translate(null, null);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyString$str_isupper_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isupper_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyString$str_isupper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isupper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isupper());
        }
    }

    public class PyString$str_isalpha_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isalpha_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isalpha() -> bool\n\nReturn True if all characters in S are alphabetic\nand there is at least one character in S, False otherwise.";
        }

        public PyString$str_isalpha_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isalpha() -> bool\n\nReturn True if all characters in S are alphabetic\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isalpha_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isalpha());
        }
    }

    public class PyString$str_isalnum_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isalnum_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyString$str_isalnum_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isalnum_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isalnum());
        }
    }

    public class PyString$str_isnumeric_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isnumeric_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isnumeric() -> bool\n\nReturn True if there are only numeric characters in S,\nFalse otherwise.";
        }

        public PyString$str_isnumeric_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isnumeric() -> bool\n\nReturn True if there are only numeric characters in S,\nFalse otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isnumeric_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isnumeric());
        }
    }

    public class PyString$str_istitle_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_istitle_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.istitle() -> bool\n\nReturn True if S is a titlecased string and there is at least one\ncharacter in S, i.e. uppercase characters may only follow uncased\ncharacters and lowercase characters only cased ones. Return False\notherwise.";
        }

        public PyString$str_istitle_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.istitle() -> bool\n\nReturn True if S is a titlecased string and there is at least one\ncharacter in S, i.e. uppercase characters may only follow uncased\ncharacters and lowercase characters only cased ones. Return False\notherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_istitle_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_istitle());
        }
    }

    public class PyString$str_isspace_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isspace_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isspace() -> bool\n\nReturn True if all characters in S are whitespace\nand there is at least one character in S, False otherwise.";
        }

        public PyString$str_isspace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isspace() -> bool\n\nReturn True if all characters in S are whitespace\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isspace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isspace());
        }
    }

    public class PyString$str_isunicode_exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str_isunicode_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "isunicode is deprecated.";
        }

        public PyString$str_isunicode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "isunicode is deprecated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_isunicode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyString)this.self).str_isunicode());
        }
    }

    public class PyString$str_decode_exposer
    extends PyBuiltinMethod {
        public PyString$str_decode_exposer(String string2) {
            super(string2);
            this.doc = "S.decode([encoding[,errors]]) -> object\n\nDecodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\nas well as any other name registered with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyString$str_decode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.decode([encoding[,errors]]) -> object\n\nDecodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\nas well as any other name registered with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_decode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyString)this.self).str_decode(pyObjectArray, stringArray);
        }
    }

    public class PyString$str_format_exposer
    extends PyBuiltinMethod {
        public PyString$str_format_exposer(String string2) {
            super(string2);
            this.doc = "S.format(*args, **kwargs) -> string\n\nReturn a formatted version of S, using substitutions from args and kwargs.\nThe substitutions are identified by braces ('{' and '}').";
        }

        public PyString$str_format_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.format(*args, **kwargs) -> string\n\nReturn a formatted version of S, using substitutions from args and kwargs.\nThe substitutions are identified by braces ('{' and '}').";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str_format_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyString)this.self).str_format(pyObjectArray, stringArray);
        }
    }

    public class PyString$str___format___exposer
    extends PyBuiltinMethodNarrow {
        public PyString$str___format___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.__format__(format_spec) -> string\n\nReturn a formatted version of S as described by format_spec.";
        }

        public PyString$str___format___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.__format__(format_spec) -> string\n\nReturn a formatted version of S as described by format_spec.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyString$str___format___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyString)this.self).str___format__(pyObject);
        }
    }

    public class PyString$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyString.str_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyString$PyExposer
    extends BaseTypeBuilder {
        public PyString$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyString$str___str___exposer("__str__"), new PyString$str___len___exposer("__len__"), new PyString$str___repr___exposer("__repr__"), new PyString$str___getitem___exposer("__getitem__"), new PyString$str___getslice___exposer("__getslice__"), new PyString$str___cmp___exposer("__cmp__"), new PyString$str___eq___exposer("__eq__"), new PyString$str___ne___exposer("__ne__"), new PyString$str___lt___exposer("__lt__"), new PyString$str___le___exposer("__le__"), new PyString$str___gt___exposer("__gt__"), new PyString$str___ge___exposer("__ge__"), new PyString$str___hash___exposer("__hash__"), new PyString$str___contains___exposer("__contains__"), new PyString$str___mul___exposer("__mul__"), new PyString$str___rmul___exposer("__rmul__"), new PyString$str___add___exposer("__add__"), new PyString$str___getnewargs___exposer("__getnewargs__"), new PyString$str___mod___exposer("__mod__"), new PyString$str_lower_exposer("lower"), new PyString$str_upper_exposer("upper"), new PyString$str_title_exposer("title"), new PyString$str_swapcase_exposer("swapcase"), new PyString$str_strip_exposer("strip"), new PyString$str_lstrip_exposer("lstrip"), new PyString$str_rstrip_exposer("rstrip"), new PyString$str_split_exposer("split"), new PyString$str_rsplit_exposer("rsplit"), new PyString$str_partition_exposer("partition"), new PyString$str_rpartition_exposer("rpartition"), new PyString$str_splitlines_exposer("splitlines"), new PyString$str_index_exposer("index"), new PyString$str_rindex_exposer("rindex"), new PyString$str_count_exposer("count"), new PyString$str_find_exposer("find"), new PyString$str_rfind_exposer("rfind"), new PyString$str_ljust_exposer("ljust"), new PyString$str_rjust_exposer("rjust"), new PyString$str_center_exposer("center"), new PyString$str_zfill_exposer("zfill"), new PyString$str_expandtabs_exposer("expandtabs"), new PyString$str_capitalize_exposer("capitalize"), new PyString$str_replace_exposer("replace"), new PyString$str_join_exposer("join"), new PyString$str_startswith_exposer("startswith"), new PyString$str_endswith_exposer("endswith"), new PyString$str_translate_exposer("translate"), new PyString$str_islower_exposer("islower"), new PyString$str_isupper_exposer("isupper"), new PyString$str_isalpha_exposer("isalpha"), new PyString$str_isalnum_exposer("isalnum"), new PyString$str_isdecimal_exposer("isdecimal"), new PyString$str_isdigit_exposer("isdigit"), new PyString$str_isnumeric_exposer("isnumeric"), new PyString$str_istitle_exposer("istitle"), new PyString$str_isspace_exposer("isspace"), new PyString$str_isunicode_exposer("isunicode"), new PyString$str_encode_exposer("encode"), new PyString$str_decode_exposer("decode"), new PyString$str__formatter_parser_exposer("_formatter_parser"), new PyString$str__formatter_field_name_split_exposer("_formatter_field_name_split"), new PyString$str_format_exposer("format"), new PyString$str___format___exposer("__format__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("str", PyString.class, PyBaseString.class, true, "str(object) -> string\n\nReturn a nice string representation of the object.\nIf the argument is a string, the return value is the same object.", pyBuiltinMethodArray, pyDataDescrArray, new PyString$exposed___new__());
        }
    }
}

