/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.number;

import java.math.RoundingMode;
import org.python.icu.impl.FormattedStringBuilder;
import org.python.icu.impl.IllegalIcuArgumentException;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.number.AffixPatternProvider;
import org.python.icu.impl.number.CompactData;
import org.python.icu.impl.number.ConstantAffixModifier;
import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.DecimalQuantity_DualStorageBCD;
import org.python.icu.impl.number.Grouper;
import org.python.icu.impl.number.LongNameHandler;
import org.python.icu.impl.number.LongNameMultiplexer;
import org.python.icu.impl.number.MacroProps;
import org.python.icu.impl.number.MicroProps;
import org.python.icu.impl.number.MicroPropsGenerator;
import org.python.icu.impl.number.MixedUnitLongNameHandler;
import org.python.icu.impl.number.MultiplierFormatHandler;
import org.python.icu.impl.number.MutablePatternModifier;
import org.python.icu.impl.number.Padder;
import org.python.icu.impl.number.PatternStringParser;
import org.python.icu.impl.number.RoundingUtils;
import org.python.icu.impl.number.UnitConversionHandler;
import org.python.icu.impl.number.UsagePrefsHandler;
import org.python.icu.number.CompactNotation;
import org.python.icu.number.IntegerWidth;
import org.python.icu.number.NumberFormatter;
import org.python.icu.number.Precision;
import org.python.icu.number.ScientificNotation;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.NumberingSystem;
import org.python.icu.text.PluralRules;
import org.python.icu.util.Currency;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;

class NumberFormatterImpl {
    private static final Currency DEFAULT_CURRENCY = Currency.getInstance("XXX");
    final MicroProps micros = new MicroProps(true);
    final MicroPropsGenerator microPropsGenerator;

    public NumberFormatterImpl(MacroProps macros) {
        this.microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macros, this.micros, true);
    }

    public static MicroProps formatStatic(MacroProps macros, DecimalQuantity inValue, FormattedStringBuilder outString) {
        MicroProps result2 = NumberFormatterImpl.preProcessUnsafe(macros, inValue);
        int length = NumberFormatterImpl.writeNumber(result2, inValue, outString, 0);
        NumberFormatterImpl.writeAffixes(result2, outString, 0, length);
        return result2;
    }

    public static int getPrefixSuffixStatic(MacroProps macros, byte signum, StandardPlural plural, FormattedStringBuilder output2) {
        MicroProps micros = new MicroProps(false);
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macros, micros, false);
        return NumberFormatterImpl.getPrefixSuffixImpl(microPropsGenerator, signum, output2);
    }

    public MicroProps format(DecimalQuantity inValue, FormattedStringBuilder outString) {
        MicroProps result2 = this.preProcess(inValue);
        int length = NumberFormatterImpl.writeNumber(result2, inValue, outString, 0);
        NumberFormatterImpl.writeAffixes(result2, outString, 0, length);
        return result2;
    }

    public MicroProps preProcess(DecimalQuantity inValue) {
        MicroProps micros = this.microPropsGenerator.processQuantity(inValue);
        if (micros.integerWidth.maxInt == -1) {
            inValue.setMinInteger(micros.integerWidth.minInt);
        } else {
            inValue.setMinInteger(micros.integerWidth.minInt);
            inValue.applyMaxInteger(micros.integerWidth.maxInt);
        }
        return micros;
    }

    private static MicroProps preProcessUnsafe(MacroProps macros, DecimalQuantity inValue) {
        MicroProps micros = new MicroProps(false);
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macros, micros, false);
        micros = microPropsGenerator.processQuantity(inValue);
        if (micros.integerWidth.maxInt == -1) {
            inValue.setMinInteger(micros.integerWidth.minInt);
        } else {
            inValue.setMinInteger(micros.integerWidth.minInt);
            inValue.applyMaxInteger(micros.integerWidth.maxInt);
        }
        return micros;
    }

    public int getPrefixSuffix(byte signum, StandardPlural plural, FormattedStringBuilder output2) {
        return NumberFormatterImpl.getPrefixSuffixImpl(this.microPropsGenerator, signum, output2);
    }

    private static int getPrefixSuffixImpl(MicroPropsGenerator generator2, byte signum, FormattedStringBuilder output2) {
        DecimalQuantity_DualStorageBCD quantity = new DecimalQuantity_DualStorageBCD(0);
        if (signum < 0) {
            quantity.negate();
        }
        MicroProps micros = generator2.processQuantity(quantity);
        micros.modMiddle.apply(output2, 0, 0);
        return micros.modMiddle.getPrefixLength();
    }

    public MicroProps getRawMicroProps() {
        return this.micros;
    }

    private static boolean unitIsCurrency(MeasureUnit unit) {
        return unit != null && "currency".equals(unit.getType());
    }

    private static boolean unitIsBaseUnit(MeasureUnit unit) {
        return unit == null;
    }

    private static boolean unitIsPercent(MeasureUnit unit) {
        return unit != null && "percent".equals(unit.getSubtype());
    }

    private static boolean unitIsPermille(MeasureUnit unit) {
        return unit != null && "permille".equals(unit.getSubtype());
    }

    private static MicroPropsGenerator macrosToMicroGenerator(MacroProps macros, MicroProps micros, boolean safe) {
        MicroPropsGenerator chain2 = micros;
        boolean isCurrency = NumberFormatterImpl.unitIsCurrency(macros.unit);
        boolean isBaseUnit = NumberFormatterImpl.unitIsBaseUnit(macros.unit);
        boolean isPercent = NumberFormatterImpl.unitIsPercent(macros.unit);
        boolean isPermille = NumberFormatterImpl.unitIsPermille(macros.unit);
        boolean isCompactNotation = macros.notation instanceof CompactNotation;
        boolean isAccounting = macros.sign == NumberFormatter.SignDisplay.ACCOUNTING || macros.sign == NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS || macros.sign == NumberFormatter.SignDisplay.ACCOUNTING_EXCEPT_ZERO || macros.sign == NumberFormatter.SignDisplay.ACCOUNTING_NEGATIVE;
        Currency currency = isCurrency ? (Currency)macros.unit : DEFAULT_CURRENCY;
        NumberFormatter.UnitWidth unitWidth = NumberFormatter.UnitWidth.SHORT;
        if (macros.unitWidth != null) {
            unitWidth = macros.unitWidth;
        }
        boolean isCldrUnit = !isCurrency && !isBaseUnit && (unitWidth == NumberFormatter.UnitWidth.FULL_NAME || !isPercent && !isPermille || isCompactNotation);
        boolean isMixedUnit = isCldrUnit && macros.unit.getType() == null && macros.unit.getComplexity() == MeasureUnit.Complexity.MIXED;
        PluralRules rules = macros.rules;
        NumberingSystem ns = macros.symbols instanceof NumberingSystem ? (NumberingSystem)macros.symbols : NumberingSystem.getInstance(macros.loc);
        micros.nsName = ns.getName();
        micros.gender = "";
        if (macros.symbols instanceof DecimalFormatSymbols) {
            micros.symbols = (DecimalFormatSymbols)macros.symbols;
        } else {
            micros.symbols = DecimalFormatSymbols.forNumberingSystem((ULocale)macros.loc, (NumberingSystem)ns);
            if (isCurrency) {
                micros.symbols.setCurrency(currency);
            }
        }
        String pattern = null;
        if (isCurrency && micros.symbols.getCurrencyPattern() != null) {
            pattern = micros.symbols.getCurrencyPattern();
        }
        if (pattern == null) {
            int patternStyle = isCldrUnit ? 0 : (isPercent || isPermille ? 2 : (!isCurrency || unitWidth == NumberFormatter.UnitWidth.FULL_NAME ? 0 : (isAccounting ? 7 : 1)));
            pattern = NumberFormat.getPatternForStyleAndNumberingSystem((ULocale)macros.loc, (String)micros.nsName, (int)patternStyle);
        }
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        UsagePrefsHandler usagePrefsHandler = null;
        if (macros.usage != null) {
            if (!isCldrUnit) {
                throw new IllegalIcuArgumentException("We only support \"usage\" when the input unit is specified, and is a CLDR Unit.");
            }
            usagePrefsHandler = new UsagePrefsHandler(macros.loc, macros.unit, macros.usage, chain2);
            chain2 = usagePrefsHandler;
        } else if (isMixedUnit) {
            chain2 = new UnitConversionHandler(macros.unit, chain2);
        }
        if (macros.scale != null) {
            chain2 = new MultiplierFormatHandler(macros.scale, chain2);
        }
        micros.rounder = macros.precision != null ? macros.precision : (isCompactNotation ? Precision.COMPACT_STRATEGY : (isCurrency ? Precision.MONETARY_STANDARD : (macros.usage != null ? Precision.BOGUS_PRECISION : Precision.DEFAULT_MAX_FRAC_6)));
        if (macros.roundingMode != null) {
            micros.rounder = micros.rounder.withMode(RoundingUtils.mathContextUnlimited((RoundingMode)macros.roundingMode));
        }
        micros.rounder = micros.rounder.withLocaleData(currency);
        micros.grouping = macros.grouping instanceof Grouper ? (Grouper)macros.grouping : (macros.grouping instanceof NumberFormatter.GroupingStrategy ? Grouper.forStrategy((NumberFormatter.GroupingStrategy)((Object)macros.grouping)) : (isCompactNotation ? Grouper.forStrategy(NumberFormatter.GroupingStrategy.MIN2) : Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO)));
        micros.grouping = micros.grouping.withLocaleData(macros.loc, patternInfo);
        micros.padding = macros.padder != null ? macros.padder : Padder.NONE;
        micros.integerWidth = macros.integerWidth != null ? macros.integerWidth : IntegerWidth.DEFAULT;
        micros.sign = macros.sign != null ? macros.sign : NumberFormatter.SignDisplay.AUTO;
        micros.decimal = macros.decimal != null ? macros.decimal : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        micros.useCurrency = isCurrency;
        if (macros.notation instanceof ScientificNotation) {
            chain2 = ((ScientificNotation)macros.notation).withLocaleData(micros.symbols, safe, chain2);
        } else {
            micros.modInner = ConstantAffixModifier.EMPTY;
        }
        MutablePatternModifier patternMod = new MutablePatternModifier(false);
        AffixPatternProvider affixProvider = macros.affixProvider != null ? macros.affixProvider : patternInfo;
        patternMod.setPatternInfo(affixProvider, null);
        boolean approximately = macros.approximately != null ? macros.approximately : false;
        patternMod.setPatternAttributes(micros.sign, isPermille, approximately);
        if (patternMod.needsPlurals()) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            patternMod.setSymbols(micros.symbols, currency, unitWidth, rules);
        } else {
            patternMod.setSymbols(micros.symbols, currency, unitWidth, null);
        }
        MutablePatternModifier.ImmutablePatternModifier immPatternMod = null;
        if (safe) {
            immPatternMod = patternMod.createImmutable();
        }
        if (affixProvider.currencyAsDecimal()) {
            micros.currencyAsDecimal = patternMod.getCurrencySymbolForUnitWidth();
        }
        if (isCldrUnit) {
            PluralRules pluralRules;
            String unitDisplayCase = null;
            if (macros.unitDisplayCase != null) {
                unitDisplayCase = macros.unitDisplayCase;
            }
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            PluralRules pluralRules2 = pluralRules = macros.rules != null ? macros.rules : PluralRules.forLocale(macros.loc);
            if (macros.usage != null) {
                assert (usagePrefsHandler != null);
                chain2 = LongNameMultiplexer.forMeasureUnits(macros.loc, usagePrefsHandler.getOutputUnits(), unitWidth, unitDisplayCase, pluralRules, chain2);
            } else if (isMixedUnit) {
                chain2 = MixedUnitLongNameHandler.forMeasureUnit(macros.loc, macros.unit, unitWidth, unitDisplayCase, pluralRules, chain2);
            } else {
                MeasureUnit unit = macros.unit;
                if (macros.perUnit != null && (unit = unit.product(macros.perUnit.reciprocal())).getType() == null && (macros.unit.getType() == null || macros.perUnit.getType() == null)) {
                    throw new UnsupportedOperationException("perUnit() can only be used if unit and perUnit are both built-ins, or the combination is a built-in");
                }
                chain2 = LongNameHandler.forMeasureUnit(macros.loc, unit, unitWidth, unitDisplayCase, pluralRules, chain2);
            }
        } else if (isCurrency && unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            chain2 = LongNameHandler.forCurrencyLongNames(macros.loc, currency, rules, chain2);
        } else {
            micros.modOuter = ConstantAffixModifier.EMPTY;
        }
        if (isCompactNotation) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            CompactData.CompactType compactType = macros.unit instanceof Currency && macros.unitWidth != NumberFormatter.UnitWidth.FULL_NAME ? CompactData.CompactType.CURRENCY : CompactData.CompactType.DECIMAL;
            chain2 = ((CompactNotation)macros.notation).withLocaleData(macros.loc, micros.nsName, compactType, rules, patternMod, safe, chain2);
        }
        chain2 = safe ? immPatternMod.addToChain(chain2) : patternMod.addToChain(chain2);
        return chain2;
    }

    public static int writeAffixes(MicroProps micros, FormattedStringBuilder string2, int start, int end) {
        int length = micros.modInner.apply(string2, start, end);
        if (micros.padding.isValid()) {
            micros.padding.padAndApply(micros.modMiddle, micros.modOuter, string2, start, end + length);
        } else {
            length += micros.modMiddle.apply(string2, start, end + length);
            length += micros.modOuter.apply(string2, start, end + length);
        }
        return length;
    }

    public static int writeNumber(MicroProps micros, DecimalQuantity quantity, FormattedStringBuilder string2, int index) {
        int length = 0;
        if (quantity.isInfinite()) {
            length += string2.insert(length + index, micros.symbols.getInfinity(), NumberFormat.Field.INTEGER);
        } else if (quantity.isNaN()) {
            length += string2.insert(length + index, micros.symbols.getNaN(), NumberFormat.Field.INTEGER);
        } else {
            length += NumberFormatterImpl.writeIntegerDigits(micros, quantity, string2, length + index);
            if (quantity.getLowerDisplayMagnitude() < 0 || micros.decimal == NumberFormatter.DecimalSeparatorDisplay.ALWAYS) {
                length = micros.currencyAsDecimal != null ? (length += string2.insert(length + index, micros.currencyAsDecimal, NumberFormat.Field.CURRENCY)) : (micros.useCurrency ? (length += string2.insert(length + index, micros.symbols.getMonetaryDecimalSeparatorString(), NumberFormat.Field.DECIMAL_SEPARATOR)) : (length += string2.insert(length + index, micros.symbols.getDecimalSeparatorString(), NumberFormat.Field.DECIMAL_SEPARATOR)));
            }
            if ((length += NumberFormatterImpl.writeFractionDigits(micros, quantity, string2, length + index)) == 0) {
                length = micros.symbols.getCodePointZero() != -1 ? (length += string2.insertCodePoint(index, micros.symbols.getCodePointZero(), NumberFormat.Field.INTEGER)) : (length += string2.insert(index, micros.symbols.getDigitStringsLocal()[0], NumberFormat.Field.INTEGER));
            }
        }
        return length;
    }

    private static int writeIntegerDigits(MicroProps micros, DecimalQuantity quantity, FormattedStringBuilder string2, int index) {
        int length = 0;
        int integerCount = quantity.getUpperDisplayMagnitude() + 1;
        for (int i = 0; i < integerCount; ++i) {
            if (micros.grouping.groupAtPosition(i, quantity)) {
                length += string2.insert(index, micros.useCurrency ? micros.symbols.getMonetaryGroupingSeparatorString() : micros.symbols.getGroupingSeparatorString(), NumberFormat.Field.GROUPING_SEPARATOR);
            }
            byte nextDigit = quantity.getDigit(i);
            if (micros.symbols.getCodePointZero() != -1) {
                length += string2.insertCodePoint(index, micros.symbols.getCodePointZero() + nextDigit, NumberFormat.Field.INTEGER);
                continue;
            }
            length += string2.insert(index, micros.symbols.getDigitStringsLocal()[nextDigit], NumberFormat.Field.INTEGER);
        }
        return length;
    }

    private static int writeFractionDigits(MicroProps micros, DecimalQuantity quantity, FormattedStringBuilder string2, int index) {
        int length = 0;
        int fractionCount = -quantity.getLowerDisplayMagnitude();
        for (int i = 0; i < fractionCount; ++i) {
            byte nextDigit = quantity.getDigit(-i - 1);
            if (micros.symbols.getCodePointZero() != -1) {
                length += string2.insertCodePoint(length + index, micros.symbols.getCodePointZero() + nextDigit, NumberFormat.Field.FRACTION);
                continue;
            }
            length += string2.insert(length + index, micros.symbols.getDigitStringsLocal()[nextDigit], NumberFormat.Field.FRACTION);
        }
        return length;
    }
}

