/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._locale;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.modules._locale.CEmulationLocale;
import org.python.modules._locale.DateSymbolJyLocale;
import org.python.modules._locale.DateSymbolLocale;
import org.python.modules._locale.JyLocale;
import org.python.modules._locale.PyLocale;

public class _locale
implements ClassDictInit {
    public static PyObject Error;
    public static final PyString __doc__;
    public static final String LOCALE_CONTROL_SETTABLE = "settable";
    public static final String LOCALE_CONTROL_JYTHON2_LEGACY = "jython2_legacy";
    private static final int __LC_CTYPE = 0;
    private static final int __LC_NUMERIC = 1;
    private static final int __LC_TIME = 2;
    private static final int __LC_COLLATE = 3;
    private static final int __LC_MONETARY = 4;
    private static final int __LC_MESSAGES = 5;
    private static final int __LC_ALL = 6;
    private static final int __LC_PAPER = 7;
    private static final int __LC_NAME = 8;
    private static final int __LC_ADDRESS = 9;
    private static final int __LC_TELEPHONE = 10;
    private static final int __LC_MEASUREMENT = 11;
    private static final int __LC_IDENTIFICATION = 12;
    public static final PyInteger LC_CTYPE;
    public static final PyInteger LC_NUMERIC;
    public static final PyInteger LC_TIME;
    public static final PyInteger LC_COLLATE;
    public static final PyInteger LC_MONETARY;
    public static final PyInteger LC_MESSAGES;
    public static final PyInteger LC_ALL;
    public static final int CHAR_MAX = 127;
    public static final PyInteger CHAR_MAX_PY_INT;
    public static final PyString C_LOCALE_PY_STRING;
    private static final Set<Locale> AVAILABLE_LOCALES;
    private static final DateSymbolLocale DEFAULT_LOCALE;
    private static volatile PyLocale currentLocale;
    public static PyString __doc___localeconv;
    public static PyString __doc___strcoll;
    public static PyString __doc___strxfrm;
    public static PyString __doc___setlocale;

    public static PyException LocaleException(String message2) {
        return new PyException(Error, message2);
    }

    public static void initClassExceptions(PyObject exceptions2) {
        PyObject baseException = exceptions2.__finditem__("BaseException");
        Error = Py.makeClass("locale.Error", baseException, (PyObject)new PyStringMap(){
            {
                this.__setitem__("__module__", (PyObject)Py.newString("locale"));
            }
        });
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("Error", Error);
        try {
            _locale.changeCurrentLocaleToDefault();
        }
        catch (Throwable t) {
            throw Py.ImportError("Jython failed to load default Java locale, falling back. " + t.getMessage());
        }
        String localeControl = PySystemState.registry.getProperty("python.locale.control", "");
        if ("".equals(localeControl) || LOCALE_CONTROL_JYTHON2_LEGACY.equals(localeControl)) {
            throw Py.ImportError("Jython locale support not enabled with python.locale.control, falling back");
        }
        if (!LOCALE_CONTROL_SETTABLE.equals(localeControl)) {
            throw Py.ImportError("Jython locale support python.locale.control unrecognized value, falling back");
        }
        _locale.changeCurrentLocaleToC();
    }

    private static void changeCurrentLocaleToDefault() {
        currentLocale = new JyLocale(Locale.getDefault(), Charset.defaultCharset().name());
    }

    protected static void putConvEntry(PyDictionary result2, String key, String value) {
        try {
            result2.put(new PyString(key), new PyString(value));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage() + " for key " + key);
        }
    }

    protected static void putConvEntry(PyDictionary result2, String key, char value) {
        try {
            result2.put(new PyString(key), new PyString(value));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage() + " for key " + key);
        }
    }

    protected static void putConvEntry(PyDictionary result2, String key, PyObject value) {
        try {
            result2.put(new PyString(key), value);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage() + " for key " + key);
        }
    }

    public static PyDictionary localeconv() {
        return currentLocale.localeconv();
    }

    public static int strcoll(PyString str1, PyString str2) {
        return currentLocale.strcoll(str1, str2);
    }

    public static PyString strxfrm(PyString str1) {
        return currentLocale.strxfrm(str1);
    }

    public static PyString setlocale(PyInteger category) {
        return currentLocale.getLocaleString();
    }

    public static PyString setlocale(PyInteger category, PyString locale2) {
        Py.writeDebug("_locale", "setlocale(category,locale==" + locale2 + ")");
        if (locale2 == null || locale2.equals(Py.None) || locale2.equals(currentLocale.getLocaleString())) {
            return _locale.setlocale(category);
        }
        if (!category.equals(LC_ALL)) {
            throw _locale.LocaleException("Only LC_ALL is supported in this version of Jython");
        }
        if (locale2.equals(C_LOCALE_PY_STRING)) {
            _locale.changeCurrentLocaleToC();
            return C_LOCALE_PY_STRING;
        }
        if (locale2.equals(new PyString(""))) {
            _locale.changeCurrentLocaleToDefault();
        } else {
            _locale.changeLocaleFromLocaleString(locale2);
        }
        return currentLocale.getLocaleString();
    }

    private static void changeLocaleFromLocaleString(PyString locale2) {
        String underscoreAlias;
        String language;
        String localeStr = locale2.toString();
        String[] localeParts = localeStr.split("\\.");
        String encoding2 = "UTF-8";
        if (localeParts.length >= 3) {
            throw _locale.LocaleException("Does not conform to [language]_[locality].[encoding] format: " + locale2.toString());
        }
        if (localeParts.length == 1) {
            language = localeStr;
        } else {
            language = localeParts[0];
            encoding2 = localeParts[1];
        }
        Locale newLocale = _locale.loadLocale(language);
        if (!_locale.isAvailableLocale(newLocale) && !_locale.isAvailableLocale(newLocale = _locale.loadLocale(underscoreAlias = language.replace('_', '-')))) {
            throw _locale.LocaleException("unsupported locale setting: " + locale2.toString());
        }
        _locale.changeCurrentLocale(new JyLocale(newLocale, encoding2));
    }

    private static void changeCurrentLocaleToC() {
        _locale.changeCurrentLocale(new CEmulationLocale());
    }

    private static boolean isAvailableLocale(Locale locale2) {
        return locale2 != null && !locale2.toString().isEmpty() && AVAILABLE_LOCALES.contains(locale2);
    }

    private static Locale loadLocale(String language) {
        Locale newLocale = Locale.forLanguageTag(language);
        Py.writeDebug("_locale", "Current: " + currentLocale.getUnderlyingLocale());
        Py.writeDebug("_locale", "New: " + newLocale + " loaded with tag: " + language);
        return newLocale;
    }

    private static void changeCurrentLocale(PyLocale pyLocale) {
        Py.writeDebug("_locale", "Locale changed to: " + pyLocale.getLocaleString());
        currentLocale = pyLocale;
    }

    public static DateSymbolLocale getDateSymbolLocale() {
        if (currentLocale == null) {
            return DEFAULT_LOCALE;
        }
        return currentLocale;
    }

    static {
        __doc__ = new PyString("The _locale module exposes locale functions in the underlying operating system or platform in a consistent way, for use by the Python locale module. It is a native Java implementation, paralleling libmodule.c in CPython and its dependence on C libraries provided by the OS.\nThis module is currently in beta, and is enabled with the registry property ``python.locale.control``. It is disabled by default, resulting in jython 2.7.1 (and previous) locale behaviour.\n\n+-------------------+-----------------------------------------+\n+ Property Value    + Behaviour                               |\n+===================+=========================================+\n| jython2_legacy    | Mix of implicit Java locale and         |\n|                   | emulated 'C'. Text and date formatting  |\n|                   | mostly Java locale (eg ``%b``).         |\n|                   | ``asctime()`` matches C emulation       |\n|                   | ``setlocale()`` always errors by design.|\n|                   | This matches version 2.7.1 and previous |\n|                   | behaviour. Will be deprecated in future |\n|                   | versions.                               |\n+-------------------+-----------------------------------------+\n| settable          | Java platform locale services made      |\n|                   | available via locale module.            |\n|                   | ``setlocale()`` works, using Java locale|\n|                   | identifiers and LC_ALL (only). C locale |\n|                   | available via ``setlocale()``. Initial  |\n|                   | locale and encoding per Java defaults.  |\n+-------------------+-----------------------------------------+\n| '' or unset       | As per ``jython2_legacy``.              |\n|                   | In future versions, per ``settable``.   |\n+-------------------+-----------------------------------------+\n");
        LC_CTYPE = new PyInteger(0);
        LC_NUMERIC = new PyInteger(1);
        LC_TIME = new PyInteger(2);
        LC_COLLATE = new PyInteger(3);
        LC_MONETARY = new PyInteger(4);
        LC_MESSAGES = new PyInteger(5);
        LC_ALL = new PyInteger(6);
        CHAR_MAX_PY_INT = new PyInteger(127);
        C_LOCALE_PY_STRING = new PyString("C");
        DEFAULT_LOCALE = new DateSymbolJyLocale(Locale.getDefault());
        currentLocale = null;
        HashSet<Locale> set = new HashSet<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        AVAILABLE_LOCALES = Collections.unmodifiableSet(set);
        __doc___localeconv = new PyString("Database of local conventions, mapped from Java.\nNote that Java locale information is relatively unicode-rich, particularly for currency symbols. Where that is not supported by the current encoding, the international currency symbol is used.\nC locale emulation matches CPython C locale emulation.");
        __doc___strcoll = new PyString("Compare Java (unicode) strings using the Java collator for the current locale, and the encoding normalization provided by strxfrm\n.In the 'C' locale, this simply calls str.__cmp__() ");
        __doc___strxfrm = new PyString("Normalize a string to unicode, for common comparison, using the locale encoding.\nIn the 'C' locale, this is a no-op, returning the parameter.");
        __doc___setlocale = new PyString("Sets the locale given a category and normalized locale string.\nOnly category LC_ALL is supported. Other categories such as LC_TIME or LC_NUMERIC result in a locale.Error.\nNormalized format is per RFC 1766, but using underscores instead of dashes, eg zh_CH.UTF-8. Briefly, the format is [language]_[locality].[encoding], where [language] is a two character language identifer, locality is a regional indicator, and encoding is a character encoding. Other examples are en_AU.ISO8859-1 and de_DE.ISO8859-15.\nIf this is an empty locale, the same language tag will be tried with dashes instead of underscores, ie [lanuage]-[locality].\nNormalization would usually be done by the enclosing locale module.\nThis function treats a missing encoding as using UTF-8.\n");
    }
}

