/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.util.List;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.ByteToMessageDecoder;
import org.python.netty.handler.ssl.SslContext;
import org.python.netty.handler.ssl.SslHandler;
import org.python.netty.util.ReferenceCountUtil;
import org.python.netty.util.internal.ObjectUtil;

public class OptionalSslHandler
extends ByteToMessageDecoder {
    private final SslContext sslContext;

    public OptionalSslHandler(SslContext sslContext) {
        this.sslContext = ObjectUtil.checkNotNull(sslContext, "sslContext");
    }

    @Override
    protected void decode(ChannelHandlerContext context2, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        if (SslHandler.isEncrypted(in)) {
            this.handleSsl(context2);
        } else {
            this.handleNonSsl(context2);
        }
    }

    private void handleSsl(ChannelHandlerContext context2) {
        SslHandler sslHandler = null;
        try {
            sslHandler = this.newSslHandler(context2, this.sslContext);
            context2.pipeline().replace(this, this.newSslHandlerName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease(sslHandler.engine());
            }
        }
    }

    private void handleNonSsl(ChannelHandlerContext context2) {
        ChannelHandler handler2 = this.newNonSslHandler(context2);
        if (handler2 != null) {
            context2.pipeline().replace(this, this.newNonSslHandlerName(), handler2);
        } else {
            context2.pipeline().remove(this);
        }
    }

    protected String newSslHandlerName() {
        return null;
    }

    protected SslHandler newSslHandler(ChannelHandlerContext context2, SslContext sslContext) {
        return sslContext.newHandler(context2.alloc());
    }

    protected String newNonSslHandlerName() {
        return null;
    }

    protected ChannelHandler newNonSslHandler(ChannelHandlerContext context2) {
        return null;
    }
}

