/*
 * Decompiled with CFR 0.152.
 */
package robot.api;

import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=38)
@MTime(value=1615466356983L)
@Filename(value="/Users/juhosaarinen/git/robotframework/build/Lib/robot/api/logger.py")
public class logger$py
extends PyFunctionTable
implements PyRunnable {
    static logger$py self;
    static final PyCode f$0;
    static final PyCode write$1;
    static final PyCode trace$2;
    static final PyCode debug$3;
    static final PyCode info$4;
    static final PyCode warn$5;
    static final PyCode error$6;
    static final PyCode console$7;

    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setglobal("__doc__", PyString.fromInterned("Public logging API for test libraries.\n\nThis module provides a public API for writing messages to the log file\nand the console. Test libraries can use this API like::\n\n    logger.info('My message')\n\ninstead of logging through the standard output like::\n\n    print('*INFO* My message')\n\nIn addition to a programmatic interface being cleaner to use, this API\nhas a benefit that the log messages have accurate timestamps.\n\nIf the logging methods are used when Robot Framework is not running,\nthe messages are redirected to the standard Python ``logging`` module\nusing logger named ``RobotFramework``.\n\nLog levels\n----------\n\nIt is possible to log messages using levels ``TRACE``, ``DEBUG``, ``INFO``,\n``WARN`` and ``ERROR`` either using the :func:`write` function or, more\ncommonly, with the log level specific :func:`trace`, :func:`debug`,\n:func:`info`, :func:`warn`, :func:`error` functions.\n\nBy default the trace and debug messages are not logged but that can be\nchanged with the ``--loglevel`` command line option. Warnings and errors are\nautomatically written also to the console and to the *Test Execution Errors*\nsection in the log file.\n\nLogging HTML\n------------\n\nAll methods that are used for writing messages to the log file have an\noptional ``html`` argument. If a message to be logged is supposed to be\nshown as HTML, this argument should be set to ``True``. Alternatively,\n:func:`write` accepts a pseudo log level ``HTML``.\n\nExample\n-------\n\n::\n\n    from robot.api import logger\n\n    def my_keyword(arg):\n        logger.debug('Got argument %s.' % arg)\n        do_something()\n        logger.info('<i>This</i> is a boring example.', html=True)\n"));
        pyFrame.setline(66);
        PyString.fromInterned("Public logging API for test libraries.\n\nThis module provides a public API for writing messages to the log file\nand the console. Test libraries can use this API like::\n\n    logger.info('My message')\n\ninstead of logging through the standard output like::\n\n    print('*INFO* My message')\n\nIn addition to a programmatic interface being cleaner to use, this API\nhas a benefit that the log messages have accurate timestamps.\n\nIf the logging methods are used when Robot Framework is not running,\nthe messages are redirected to the standard Python ``logging`` module\nusing logger named ``RobotFramework``.\n\nLog levels\n----------\n\nIt is possible to log messages using levels ``TRACE``, ``DEBUG``, ``INFO``,\n``WARN`` and ``ERROR`` either using the :func:`write` function or, more\ncommonly, with the log level specific :func:`trace`, :func:`debug`,\n:func:`info`, :func:`warn`, :func:`error` functions.\n\nBy default the trace and debug messages are not logged but that can be\nchanged with the ``--loglevel`` command line option. Warnings and errors are\nautomatically written also to the console and to the *Test Execution Errors*\nsection in the log file.\n\nLogging HTML\n------------\n\nAll methods that are used for writing messages to the log file have an\noptional ``html`` argument. If a message to be logged is supposed to be\nshown as HTML, this argument should be set to ``True``. Alternatively,\n:func:`write` accepts a pseudo log level ``HTML``.\n\nExample\n-------\n\n::\n\n    from robot.api import logger\n\n    def my_keyword(arg):\n        logger.debug('Got argument %s.' % arg)\n        do_something()\n        logger.info('<i>This</i> is a boring example.', html=True)\n");
        pyFrame.setline(68);
        Object object = imp.importOne("logging", pyFrame, -1);
        pyFrame.setlocal("logging", (PyObject)object);
        object = null;
        pyFrame.setline(70);
        object = new String[]{"librarylogger"};
        object = imp.importFrom("robot.output", (String[])object, pyFrame, -1);
        Object object2 = object[0];
        pyFrame.setlocal("librarylogger", (PyObject)object2);
        object2 = null;
        pyFrame.setline(71);
        object = new String[]{"EXECUTION_CONTEXTS"};
        object = imp.importFrom("robot.running.context", (String[])object, pyFrame, -1);
        object2 = object[0];
        pyFrame.setlocal("EXECUTION_CONTEXTS", (PyObject)object2);
        object2 = null;
        pyFrame.setline(74);
        object = new PyObject[]{PyString.fromInterned("INFO"), pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, write$1, PyString.fromInterned("Writes the message to the log file using the given level.\n\n    Valid log levels are ``TRACE``, ``DEBUG``, ``INFO`` (default), ``WARN``, and\n    ``ERROR``. Additionally it is possible to use ``HTML`` pseudo log level that\n    logs the message as HTML using the ``INFO`` level.\n\n    Instead of using this method, it is generally better to use the level\n    specific methods such as ``info`` and ``debug`` that have separate\n    ``html`` argument to control the message format.\n    "));
        pyFrame.setlocal("write", (PyObject)object);
        object = null;
        pyFrame.setline(98);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, trace$2, PyString.fromInterned("Writes the message to the log file using the ``TRACE`` level."));
        pyFrame.setlocal("trace", (PyObject)object);
        object = null;
        pyFrame.setline(103);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, debug$3, PyString.fromInterned("Writes the message to the log file using the ``DEBUG`` level."));
        pyFrame.setlocal("debug", (PyObject)object);
        object = null;
        pyFrame.setline(108);
        object = new PyObject[]{pyFrame.getname("False"), pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, info$4, PyString.fromInterned("Writes the message to the log file using the ``INFO`` level.\n\n    If ``also_console`` argument is set to ``True``, the message is\n    written both to the log file and to the console.\n    "));
        pyFrame.setlocal("info", (PyObject)object);
        object = null;
        pyFrame.setline(119);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, warn$5, PyString.fromInterned("Writes the message to the log file using the ``WARN`` level."));
        pyFrame.setlocal("warn", (PyObject)object);
        object = null;
        pyFrame.setline(124);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, error$6, PyString.fromInterned("Writes the message to the log file using the ``ERROR`` level.\n    "));
        pyFrame.setlocal("error", (PyObject)object);
        object = null;
        pyFrame.setline(130);
        object = new PyObject[]{pyFrame.getname("True"), PyString.fromInterned("stdout")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, console$7, PyString.fromInterned("Writes the message to the console.\n\n    If the ``newline`` argument is ``True``, a newline character is\n    automatically added to the message.\n\n    By default the message is written to the standard output stream.\n    Using the standard error stream is possibly by giving the ``stream``\n    argument value ``'stderr'``.\n    "));
        pyFrame.setlocal("console", (PyObject)object);
        object = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject write$1(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(84);
        PyString.fromInterned("Writes the message to the log file using the given level.\n\n    Valid log levels are ``TRACE``, ``DEBUG``, ``INFO`` (default), ``WARN``, and\n    ``ERROR``. Additionally it is possible to use ``HTML`` pseudo log level that\n    logs the message as HTML using the ``INFO`` level.\n\n    Instead of using this method, it is generally better to use the level\n    specific methods such as ``info`` and ``debug`` that have separate\n    ``html`` argument to control the message format.\n    ");
        pyFrame.setline(85);
        PyObject pyObject = pyFrame.getglobal("EXECUTION_CONTEXTS").__getattr__("current");
        PyObject pyObject2 = pyObject._isnot(pyFrame.getglobal("None"));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(86);
            pyFrame.getglobal("librarylogger").__getattr__("write").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(1), pyFrame.getlocal(2));
        } else {
            pyFrame.setline(88);
            pyObject = pyFrame.getglobal("logging").__getattr__("getLogger").__call__(threadState, (PyObject)PyString.fromInterned("RobotFramework"));
            pyFrame.setlocal(3, pyObject);
            pyObject = null;
            pyFrame.setline(89);
            pyObject = new PyDictionary(new PyObject[]{PyString.fromInterned("TRACE"), pyFrame.getglobal("logging").__getattr__("DEBUG")._floordiv(Py.newInteger(2)), PyString.fromInterned("DEBUG"), pyFrame.getglobal("logging").__getattr__("DEBUG"), PyString.fromInterned("INFO"), pyFrame.getglobal("logging").__getattr__("INFO"), PyString.fromInterned("HTML"), pyFrame.getglobal("logging").__getattr__("INFO"), PyString.fromInterned("WARN"), pyFrame.getglobal("logging").__getattr__("WARN"), PyString.fromInterned("ERROR"), pyFrame.getglobal("logging").__getattr__("ERROR")}).__getitem__(pyFrame.getlocal(1));
            pyFrame.setlocal(1, pyObject);
            pyObject = null;
            pyFrame.setline(95);
            pyFrame.getlocal(3).__getattr__("log").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(0));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject trace$2(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(99);
        PyString.fromInterned("Writes the message to the log file using the ``TRACE`` level.");
        pyFrame.setline(100);
        pyFrame.getglobal("write").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("TRACE"), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject debug$3(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(104);
        PyString.fromInterned("Writes the message to the log file using the ``DEBUG`` level.");
        pyFrame.setline(105);
        pyFrame.getglobal("write").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("DEBUG"), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject info$4(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(113);
        PyString.fromInterned("Writes the message to the log file using the ``INFO`` level.\n\n    If ``also_console`` argument is set to ``True``, the message is\n    written both to the log file and to the console.\n    ");
        pyFrame.setline(114);
        pyFrame.getglobal("write").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("INFO"), pyFrame.getlocal(1));
        pyFrame.setline(115);
        if (pyFrame.getlocal(2).__nonzero__()) {
            pyFrame.setline(116);
            pyFrame.getglobal("console").__call__(threadState, pyFrame.getlocal(0));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject warn$5(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(120);
        PyString.fromInterned("Writes the message to the log file using the ``WARN`` level.");
        pyFrame.setline(121);
        pyFrame.getglobal("write").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("WARN"), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject error$6(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(126);
        PyString.fromInterned("Writes the message to the log file using the ``ERROR`` level.\n    ");
        pyFrame.setline(127);
        pyFrame.getglobal("write").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("ERROR"), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject console$7(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(139);
        PyString.fromInterned("Writes the message to the console.\n\n    If the ``newline`` argument is ``True``, a newline character is\n    automatically added to the message.\n\n    By default the message is written to the standard output stream.\n    Using the standard error stream is possibly by giving the ``stream``\n    argument value ``'stderr'``.\n    ");
        pyFrame.setline(140);
        pyFrame.getglobal("librarylogger").__getattr__("console").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(1), pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public logger$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
        stringArray = new String[]{"msg", "level", "html", "logger"};
        write$1 = Py.newCode(3, stringArray, string2, "write", 74, false, false, (PyFunctionTable)self, 1, null, null, 0, 4097);
        stringArray = new String[]{"msg", "html"};
        trace$2 = Py.newCode(2, stringArray, string2, "trace", 98, false, false, (PyFunctionTable)self, 2, null, null, 0, 4097);
        stringArray = new String[]{"msg", "html"};
        debug$3 = Py.newCode(2, stringArray, string2, "debug", 103, false, false, (PyFunctionTable)self, 3, null, null, 0, 4097);
        stringArray = new String[]{"msg", "html", "also_console"};
        info$4 = Py.newCode(3, stringArray, string2, "info", 108, false, false, (PyFunctionTable)self, 4, null, null, 0, 4097);
        stringArray = new String[]{"msg", "html"};
        warn$5 = Py.newCode(2, stringArray, string2, "warn", 119, false, false, (PyFunctionTable)self, 5, null, null, 0, 4097);
        stringArray = new String[]{"msg", "html"};
        error$6 = Py.newCode(2, stringArray, string2, "error", 124, false, false, (PyFunctionTable)self, 6, null, null, 0, 4097);
        stringArray = new String[]{"msg", "newline", "stream"};
        console$7 = Py.newCode(3, stringArray, string2, "console", 130, false, false, (PyFunctionTable)self, 7, null, null, 0, 4097);
    }

    @Override
    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new logger$py("robot/api/logger$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(logger$py.class);
    }

    @Override
    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        logger$py logger$py = this;
        PyFrame pyFrame2 = pyFrame;
        ThreadState threadState2 = threadState;
        switch (n) {
            case 0: {
                return logger$py.f$0(pyFrame2, threadState2);
            }
            case 1: {
                return logger$py.write$1(pyFrame2, threadState2);
            }
            case 2: {
                return logger$py.trace$2(pyFrame2, threadState2);
            }
            case 3: {
                return logger$py.debug$3(pyFrame2, threadState2);
            }
            case 4: {
                return logger$py.info$4(pyFrame2, threadState2);
            }
            case 5: {
                return logger$py.warn$5(pyFrame2, threadState2);
            }
            case 6: {
                return logger$py.error$6(pyFrame2, threadState2);
            }
            case 7: {
                return logger$py.console$7(pyFrame2, threadState2);
            }
        }
        return null;
    }
}

